<?php Fun::lang() ?>
<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
    <fieldset>
        <legend><?php echo e(__('administrator.product')); ?></legend>
        <div class="col-xs-12 col-sm-12 col-md-8 col-lg-8 col-lg-offset-2 col-md-offset-2">
            <div class="form-group row">
                <label class="col-sm-3 text-right"><?php echo e(__('administrator.name')); ?><span
                            class="text-danger">*</span></label>
                <div class="col-sm-9">
                    <?php echo Form::text('product_name',null, ['placeholder'=>__('administrator.product_name'),'class' => 'form-control']); ?>

                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-3 text-right"><?php echo e(__('administrator.item_code')); ?><span
                            class="text-danger">*</span></label>
                <div class="col-sm-9">
                    <?php echo Form::text('item_code',null, ['placeholder'=>__('administrator.code'),'class' => 'form-control']); ?>

                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-3 text-right"><?php echo e(__('administrator.brands')); ?><span
                            class="text-danger">*</span></label>
                <div class="col-sm-9">
                    <div class="input-group">
                        <?php echo Form::select('brand_id', getProductBrand(), null, ['class' => 'brand form-control select2', 'placeholder' =>  __('administrator.please_select')  ]); ?>

                        <span class="input-group-addon getHtmlForm"
                              data-href="<?php echo e(route('brand.create')); ?>?input_name=brand_id" data-name="Create Brand"><i
                                    class="fa fa-plus-circle text-blue"></i></span>
                    </div>
                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-3 text-right"><?php echo e(__('administrator.category')); ?><span
                            class="text-danger">*</span></label>
                <div class="col-sm-9">
                    <div class="input-group">
                        <?php echo Form::select('category_id', getCategory(), null, ['class' => 'form-control select2', 'placeholder' =>  __('administrator.please_select')  ]); ?>

                        <span class="input-group-addon getHtmlForm"
                              data-href="<?php echo e(route('category.create')); ?>?input_name=category_id"
                              data-name="Create Category"><i class="fa fa-plus-circle text-blue"></i></span>
                    </div>
                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-3 text-right"><?php echo e(__('administrator.default')); ?> <?php echo e(__('administrator.shelf')); ?></label>
                <div class="col-sm-9">
                    <div class="input-group">
                        <?php echo Form::select('shelf', getProductShelf(), null, ['class' => 'form-control select2', 'placeholder' =>  __('administrator.please_select')  ]); ?>

                        <span class="input-group-addon getHtmlForm"
                              data-href="<?php echo e(route('shelf.create')); ?>?input_name=shelf"
                              data-name="Create Category"><i class="fa fa-plus-circle text-blue"></i></span>
                    </div>
                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-3 text-right"><?php echo e(__('administrator.description')); ?></label>
                <div class="col-sm-9">
                    <?php echo Form::textarea('description',null, ['placeholder'=>__('administrator.description'),'class' => 'form-control','rows'=>2]); ?>


                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-3 text-right"><?php echo e(__('administrator.image')); ?></label>
                <div class="col-sm-9">
                    <div class="input-group">
                        <input type="file" name="image">
                    </div>
                </div>
            </div>
        </div>
        <div class="form-group formName row">
            <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                <table class="table table-bordered">
                    <thead class="table-success">
                    <tr>
                        <th class="required"> <?php echo e(__('administrator.unit')); ?></th>
                        <th class="required"> <?php echo e(__('administrator.item_code')); ?></th>
                        <th class="required"> <?php echo e(__('administrator.barcode')); ?></th>
                        <th class="required"> <?php echo e(__('administrator.net_cost')); ?></th>
                        <th class="required"> <?php echo e(__('administrator.price')); ?></th>
                        <th width="5%" class="text-center text-light-blue"><i
                                    class="fa fa-plus text-green btn btn-default" title="Add"></i></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php if(@$product_unit): ?>
                        <?php $__currentLoopData = $product_unit; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <div class="input-group">
                                        <?php echo Form::select('unit_id[]', getUnit(), $row->unit_id, ['class' => 'unit form-control select2', 'placeholder' => __('administrator.please_select') ]); ?>

                                        <span class="input-group-addon getHtmlForm"
                                              data-href="<?php echo e(route('unit.create')); ?>?input_name=unit_id[]"
                                              data-name="Create Unit"><i class="fa fa-plus-circle text-blue"></i></span>
                                    </div>
                                </td>
                                <td>
                                    <input name="code[]" type="text" maxlength="15" class="code form-control"
                                           placeholder=" <?php echo e(__('administrator.code')); ?>" value="<?php echo e($row->item_code); ?>"
                                           autocomplete="off"/>
                                    <input name="product_unit_id[]" value="<?php echo e($row->id); ?>" type="hidden"/>
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input name="barcode[]" type="text" maxlength="50" class="barcode form-control"
                                               placeholder="Barcode" autocomplete="off" value="<?php echo e($row->barcode); ?>"/>
                                        <span class="input-group-addon">
                                    <i class="fa fa-code"></i>
                                </span>
                                    </div>
                                </td>
                                <td>
                                    <input name="cost[]" type="text" maxlength="15" class="cost form-control numeric"
                                           value="<?php echo e($row->cost); ?>"
                                           placeholder="<?php echo e(__('administrator.cost')); ?>" autocomplete="off"/>
                                </td>
                                <td>
                                    <input name="price[]" type="text" maxlength="15" class="price form-control numeric"
                                           value="<?php echo e($row->retail_price); ?>"
                                           placeholder="<?php echo e(__('administrator.price')); ?>" autocomplete="off"/>
                                </td>
                                <td>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="col-xs-12 col-sm-12 col-md-8 col-lg-8 col-lg-offset-2 col-md-offset-2 text-right">
            <?php echo $__env->make('component.form-btn', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </fieldset>
</div>
<?php $__env->startSection('script'); ?>
    <script>
        $(document).ready(function () {
            <?php if(!@$product_unit): ?>
            appendTbody();
            <?php endif; ?>

        });

        $(document).on('click', '.fa.fa-plus', function () {
            appendTbody();
        });

        $(document).on('click', '.fa.fa-code', function () {
            let e = $(this);
            setTimeout(function () {
                e.closest('.input-group').find('input[name="barcode[]"]').val(dateToNiceString());
            }, 500);
        });


        function appendTbody() {
            $('.formName tbody').append(`<tr>
            <td>
                <div class="input-group">
                        <?php echo Form::select('unit_id[]', getUnit(), null, ['class' => 'unit form-control select2', 'placeholder' => __('administrator.please_select') ]); ?>

            <span class="input-group-addon getHtmlForm"  data-href="<?php echo e(route('unit.create')); ?>?input_name=unit_id" data-name="Create Unit"><i class="fa fa-plus-circle text-blue"></i></span>
                    </div>
            </td>
            <td>
                <input name="code[]" type="text" maxlength="50" class="code form-control" placeholder=" <?php echo e(__('administrator.code')); ?>" autocomplete="off"/>
                <input name="product_unit_id[]" value="0" type="hidden" />
            </td>
            <td>
                <div class="input-group">
                    <input name="barcode[]" type="text" maxlength="15" class="barcode form-control" placeholder="Barcode" autocomplete="off" value="${dateToNiceString()}"/>
                    <span class="input-group-addon">
                        <i class="fa fa-code"></i>
                    </span>
                </div>
            </td>
            <td>
                <input name="cost[]" type="text" maxlength="15" class="cost form-control numeric" placeholder="<?php echo e(__('administrator.cost')); ?>" autocomplete="off"/>
            </td>
            <td>
                <input name="price[]" type="text" maxlength="15" class="price form-control numeric" placeholder="<?php echo e(__('administrator.price')); ?>" autocomplete="off"/>
            </td>
            <td>
                <i class="fa fa-times text-red btn btn-default" onclick="$(this).closest('tr').remove();" title=" <?php echo e(__('administrator.remove')); ?>"></i>
            </td>
        </tr>`).find('tr:last .select2').select2();
        }
    </script>

<?php $__env->stopSection(); ?>
<?php /**PATH /home/nsowos/public_html/vitadermo/resources/views/administrator/item-setup/products/form.blade.php ENDPATH**/ ?>