<div class="col-sm-8 col-xs-12 display-none">
    <?php
        $roles = \Spatie\Permission\Models\Role::where(['group_role'=>'app'])
        ->pluck('name', 'name');
    ?>
</div>
<?php
$team_leader = [];
if (request('type') === 'member') {
    $acc = [
        'type' => 'hr',
        'title' => 'account',
    ];
    $member_type = [
        'type' => 'select',
        'name' => 'member_type_id',
        'title' => 'member_type',
        'option' => getMemberTypes()->prepend(__('administrator.please_select'),''),
        'required' => 'required',
    ];
    if(!ifMember()){
        $team_leader = [
            'type' => 'select',
            'name' => 'leader_id',
            'title' => 'team_leader',
            'placeholder' => __('administrator.please_select'),
            'option' => getUsers('', 'member')->prepend(__('administrator.please_select'),''),
        ];
    }
    $info =[
        [
            'type' => 'hr',
            'title' => 'personal_info',
        ],
        [
            'type' => 'text',
            'name' => 'id_card',
            'title' => 'id_card',
        ],
        [
            'type' => 'text',
            'name' => 'date_of_birth',
            'title' => 'date_of_birth',
            'class' => 'date_picker',
            'value' => @$master?date('d-m-Y',strtotime($master->date_of_birth)):'',
        ],
        [
            'type' => 'select',
            'name' => 'province_id',
            'title' => 'province',
            'option' => getProvince(),
        ],
        [
            'type' => 'select',
            'name' => 'district_id',
            'title' => 'district',
            'option' => @$district??[''=>__('administrator.please_select')],
        ],
        [
            'type' => 'select',
            'name' => 'commune_id',
            'title' => 'commune',
            'option' =>  @$commune??[''=>__('administrator.please_select')],
        ],
        [
            'type' => 'select',
            'name' => 'village_id',
            'title' => 'village',
            'option' =>  @$village??[''=>__('administrator.please_select')],
        ],
        [
            'type' => 'text',
            'name' => 'house',
            'title' => 'house',
        ],
        [
            'type' => 'text',
            'name' => 'street',
            'title' => 'street',
        ],
        [
            'type' => 'file',
            'name' => 'image',
            'title' => 'image',
        ],
    ];
} else {
    $acc = [];
    $member_type = [];
    $info =[];
}
$input = [
    $acc,
    $member_type,
    [
        'type' => 'text',
        'name' => 'name',
        'title' => 'name',
        'required' => 'required',
    ],
    [
        'type' => 'select',
        'name' => 'gender',
        'title' => 'gender',
        'option' => getGender(),
    ],
    [
        'type' => 'text',
        'name' => 'phone',
        'title' => 'phone',
    ],
    [
        'type' => 'text',
        'name' => 'email',
        'title' => 'email',
    ],
    $team_leader,
    [
        'type' => 'select',
        'name' => 'roles[]',
        'title' => 'role',
        'option' => $roles,
        'value' => @$role_val->name??null,
        'class'=>(request('type')==='member'?'display-none':''),
        'no-select2'=>1
    ],
    [
        'type' => 'text',
        'name' => 'username',
        'title' => 'username',
    ],
    [
        'type' => 'password',
        'name' => 'password',
        'title' => 'password',
    ]
];
$input = array_merge($input,$info);
?>

<?php echo $__env->make('component.form-component',['input'=>$input], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo Form::hidden('user_type',request('type'));; ?>

<?php $__env->startSection('jq'); ?>
    <script>
        $(document).ready(function (){
            let s = function (name){return `select[name=${name}]`;};
           $(`${s('province_id')},${s('district_id')},${s('commune_id')}`).on('change',function (){
               getLocation($(this).attr('name'));
           });
        });
        function getLocation(name){



            let province_id = $('select[name=province_id]').val();
            let district = $('select[name=district_id]');
            let commune = $('select[name=commune_id]');
            let village = $('select[name=village_id]');

            switch (name){
                case 'province_id':
                    district.html('');
                    commune.html('');
                    village.html('');
                case 'district_id':
                    commune.html('');
                    village.html('');
                case 'commune_id':
                    village.html('');
                default:
            }


            let district_id = district.val();
            let commune_id = commune.val();
            let village_id = village.val();

            $.get('<?php echo e(route('get-location-data')); ?>',{province_id,district_id,commune_id,village_id},function (res){
                let option = `<option value=""><?php echo e(__('administrator.please_select')); ?></option>`;
                if(res){
                    $.each(res,function (ii,vv){
                        option += `<option value="${ii}">${vv}</option>`;
                    });
                    if(!district_id){
                        district.html(option);
                        return;
                    }
                    if(!commune_id){
                        commune.html(option);
                        return;
                    }
                    if(!village_id){
                        village.html(option);
                    }
                }
            });
        }
    </script>
<?php $__env->stopSection(); ?>
<?php /**PATH /home/nsowos/public_html/vitadermo/resources/views/administrator/users/form.blade.php ENDPATH**/ ?>