<?php Fun::lang() ?>

<?php $__env->startSection('content'); ?>

    <div class="page">

        <div class="top-content">
            <div class="row">
                <div class="col-sm-12 col-xs-12">
                    <div class="title-add">
                        <div class="pull-left">
                            <h3>Create Account Chart</h3>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12 col-xs-12">

                <div class="form-wrapper">
                    <?php echo Form::model($account_chart, ['method' => 'PATCH','route' => ['account-chart.update', $account_chart->id],'enctype'=>'multipart/form-data','id' => 'form-acc']); ?>


                    <div class="form-group row">
                        <div class="col-sm-4 col-12">
                            <label class="required">Account Type</label>
                            <input type="text" name="acctype" value="<?php echo e($acc_type); ?>" class="form-control" readonly>
                        </div>
                        <div class="col-sm-4 col-12">
                            <label >Account Type Name</label>
                            <input type="text" class="form-control" value="<?php echo e($acc_type_name); ?>" readonly>
                        </div>
                        <div class="col-sm-4 col-12">
                            <label>Sub Account Of</label>
                            <input type="text" value="<?php echo e($sub_acc_of); ?>" readonly class="form-control">
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-sm-4 col-12">
                            <label>Account Number</label>
                            <input type="text" class="form-control number-only" name="acc_num" id="acc_num" readonly value="<?php echo e($account_chart->id); ?>">
                        </div>
                        <div class="col-sm-4 col-xs-12 ">
                            <label class="required">Sub Account</label>
                            <?php echo Form::text('acc_name', null, array('placeholder' => 'Sub Account','class' => 'form-control','required')); ?>

                        </div>
                        <div class="col-sm-4 col-xs-12">
                            <label class="required">Sub Account Khmer</label>
                            <?php echo Form::text('acc_namekh', null, array('placeholder' => 'Sub Account Khmer','class' => 'form-control')); ?>

                        </div>

                    </div>
                    <div class="form-group row">
                        <div class="col-sm-12 col-xs-12 ">
                            <label>Description</label>
                            <?php echo Form::textarea('acc_des', null, array('placeholder' => 'Description','class' => 'form-control','rows'=>'3')); ?>

                        </div>
                    </div>


                    <div class="form-group row">
                        <div class="col-sm-12 col-xs-12">
                            <div class="form-group">
                                <button type="submit" class="button_sm button_primary pull-right"><span class="fa fa-save"></span> Save</button>
                                <button type="button"  onClick="javascript:history.go(-1)" class="button_sm button_warning pull-right">
                                    <span class=" fa fa-arrow-circle-left"></span> Back</button>
                            </div>
                        </div>
                    </div>

                    <?php echo Form::close(); ?>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script type="text/javascript">
        $(document).on('change','#account-type',function () {
            var account_type = $(this).val();
            $.ajax({
                type:'GET',
                url: '/realty/get-account-code/'+account_type,
                dataType:'json',
                data:
                    {
                        'account_code':account_type
                    },
                success:function (data) {
                    $('#acc-type').empty();
                    $('#acc-type').append('<option value="" disabled="disabled" selected>Please Select</option>');
                    $.each(data['acc_chart'],function (i,val) {
                        $('#acc-type').append('<option value="'+val.id+'">'+val.id + " | " + val.acc_name +'</option>');
                    });
                },
                error:function (err) {
                    console.log(err);
                }
            });
        });
        $(document).on('change','#acc-type',function () {
            var account_type = $(this).val();
            var acc_type = $(this).val();
            $.ajax({
                type:'GET',
                url:'/realty/get-account-code/'+account_type,
                dataType:'json',
                data:
                    {
                        'account_code':account_type,
                        'acc_type' : acc_type
                    },
                success:function (data) {
                    $('#sub-account-type').empty();
                    $('#sub-account-type').append('<option value="" disabled="disabled" selected>Please Select</option>');
                    $.each(data['acc_chart'],function (i,val) {
                        $('#sub-account-type').append('<option value="'+val.id+'">'+val.id + " | " + val.acc_name +'</option>');
                    });
                    $('#acc_num').val(data['acc_num']);
                },
                error:function (err) {
                    console.log(err);
                }
            });
        });
        $('#acc-check').change(function(){
            if(this.checked)
            {
                $('#sub-account-type').removeAttr('disabled');
                $('#sub-account-type').prop('required');
            }
            else
            {
                $('#sub-account-type').val(1).trigger('change.select2');
                $('#sub-account-type').prop('disabled',true);
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(branchMenu(), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/vitadermo/resources/views/Accounting/account-chart/edit.blade.php ENDPATH**/ ?>