
<?php $__env->startSection('content'); ?>
    <?php Fun::lang()?>
    <div class="page">
        <div class=container-fluid>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <div class="title-add">
                            <div class="pull-left">
                                <h3><?php echo e(__('administrator.request_stock')); ?></h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <br>&nbsp;
            <br>

            <div class="wrapper-table">
                <table id="print_table" width="100%" class="table table-striped table-hover ​​">
                    <thead>
                    <tr>
                        <th>#</th>
                        <th><?php echo e(__('administrator.invoice_number')); ?></th>
                        <th><?php echo e(__('administrator.request_by')); ?></th>
                        <th><?php echo e(__('administrator.date')); ?></th>
                        <th><?php echo e(__('administrator.status')); ?></th>
                        <th style="width:200px;"><?php echo e(__('administrator.action')); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script type="text/javascript">
        function getTable(supplier='',type='') {
            $('#print_table').DataTable().destroy();
            $('#print_table').DataTable({
                "oLanguage": {
                    "sSearch": "<?php echo e(__('administrator.search')); ?>:",
                    "sLengthMenu": "<?php echo e(__('administrator.display')); ?> _MENU_ <?php echo e(__('administrator.record_per_page')); ?>",
                    "sZeroRecords": "<?php echo e(__('administrator.Nothing_foundsorry')); ?>",
                    "sInfo": "<?php echo e(__('administrator.showing')); ?> _START_ <?php echo e(__('administrator.to')); ?> _END_ <?php echo e(__('administrator.of')); ?> _TOTAL_ <?php echo e(__('administrator.record')); ?>",
                    "sInfoEmpty": "<?php echo e(__('administrator.showing')); ?> 0 <?php echo e(__('administrator.to')); ?> 0 <?php echo e(__('administrator.of')); ?> 0 <?php echo e(__('administrator.record')); ?>",
                    "sInfoFiltered": "(<?php echo e(__('administrator.filter_form')); ?> _MAX_ <?php echo e(__('administrator.total_records')); ?>)",
                    "oPaginate": {
                        "sFirst": "<?php echo e(__('administrator.first')); ?>",
                        "sLast": "<?php echo e(__('administrator.last')); ?>",
                        "sNext": "<?php echo e(__('administrator.next')); ?>",
                        "sPrevious": "<?php echo e(__('administrator.previous')); ?>"
                    },
                },
                ordering: false,
                serverSide: true,
                lengthMenu: tbLength,
                ajax: {
                    url:"<?php echo e(route('request-stock-item.index')); ?>",
                    data:{
                        supplier:supplier,
                        type:type
                    }
                },
                columns:
                    [
                        {data: 'DT_RowIndex', 'searchable': false},
                        {data: 'invoice_number', 'name': 'nso007_production_request.invoice_number'},
                        {data: 'request_by', 'searchable': false},
                        {data: 'date', 'searchable': false},
                        {data: 'status', 'searchable': false},
                        {data: 'action', 'searchable': false},
                    ],

                "initComplete": function (settings, json) {
                }
            });
        }
        $(document).ready(function () {
            getTable();
            $('.select2').on('change',function () {
                var supplier = $('select[name=supplier]').val();
                var type = $('select[name=type]').val();
                getTable(supplier,type);
            });


            $(document).on('click',' .show_request',function () {
                let id = $(this).data('id');
                $.ajax({
                    url:$(this).data('href'),
                    method:'get',
                    dataType: 'json',
                    success:function (data) {
                        $.alert({
                            title:'',
                            theme:'modern',
                            useBootstrap:false,
                            boxWidth:'50%',
                            content:data.html,
                            buttons:{
                                reject: {
                                    text: '<?php echo e(__('administrator.reject')); ?>',
                                    btnClass: 'button_danger status_btn',
                                    action: function () {
                                        let this_ = this;
                                        update_status(id, this, 2);
                                        return false;
                                    }
                                },
                                approve: {
                                    text: '<?php echo e(__('administrator.approve')); ?>',
                                    btnClass: 'button_success status_btn',
                                    action: function () {
                                        update_status(id, this, 1);
                                        return false;
                                    }
                                },
                                close: {
                                    text: '<?php echo e(__('administrator.close')); ?>',
                                    btnClass: 'button_warning',
                                },
                            }
                        });

                    }
                });
            });
        });
        function update_status(id, this_, status)
        {
            let text_note = '<label><?php echo e(__('administrator.note')); ?></label><?php echo Form::textarea('request_note',null, ['class' => 'form-control no-resize','placeholder'=>__('administrator.note')]); ?>';
            $.confirm({
                title: '',
                theme: 'modern',
                content: text_note,
                buttons: {
                    submit: {
                        text: (status === 2 ? '<?php echo e(__('administrator.reject')); ?>' : '<?php echo e(__('administrator.approve')); ?>'),
                        btnClass: (status === 2 ? 'button_danger' : 'btn bg-olive btn-flat margin'),
                        action: function () {
                            let this_ = this;
                            this_.buttons.submit.disable();
                            let note = this.$content.find('textarea[name=request_note]').val();
                            $.ajax({
                                url: '<?php echo e(route("request-stock-item-update-status")); ?>',
                                dataType: 'json',
                                data: {
                                    "_token": "<?php echo e(csrf_token()); ?>",
                                    id: id,
                                    status: status,
                                    note: note,
                                },
                                method: 'post'
                            }).done(function (response) {
                                if (response.status === 'success') {
                                    window.location.reload();
                                } else {
                                    if (parseInt(response.count) > 0) {
                                        $.alert({
                                            title: '',
                                            content: response.message,
                                            theme: 'modern',
                                        });
                                        this_.buttons.submit.enable();
                                    }
                                }
                            }).fail(function (xhr) {
                                let error       = xhr.responseJSON.errors;
                                let text_err    = '';
                                $.each(error, function (i, val) {
                                    text_err += '' + val + '<br>';
                                });
                                if (text_err === '') {
                                    text_err = 'Data is Invalid...';
                                }
                                $.alert(text_err);
                                this_.buttons.submit.enable();
                            });
                            return false;
                        }
                    },
                    cancel: {
                        text: '<?php echo e(__('administrator.cancel')); ?>',
                        btnClass: 'button_warning',
                        action: function () {
                        }
                    },
                },
            });
            return false;
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/vitadermo/resources/views/administrator/request-stock/index.blade.php ENDPATH**/ ?>