<?php $__env->startSection('content'); ?>
    <?php Fun::lang()?>
    <div class="row">
        <div class="col-xs-12">
            <div class="box">
                <div class="box-header">
                    <div class="row">
                        <div class="col-sm-12 col-xs-12">
                            <div class="title-add">
                                <div class="pull-left">
                                    <h3><?php echo e(__('administrator.purchase_approval')); ?></h3>
                                </div>
                                <div class="pull-right">
                                    <?php if(request('show')==='p'): ?>
                                        <a href="<?php echo e(route('purchases-item.create')); ?>" class="btn bg-olive btn-flat margin"><span class="fa fa-plus"></span> <?php echo e(__('administrator.new_record')); ?></a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="top-content">
                    <div class="row">
                        <div class="col-sm-12 col-xs-12">
                            <form class="form_data">
                                <div class="col-sm-4 col-md-4">
                                    <div class="col-sm-4 col-md-4">
                                        <?php echo e(__('administrator.from_date')); ?> :
                                    </div>
                                    <div class="form-group col-sm-8 col-md-8">
                                        <?php echo Form::text('from_date',null, ['placeholder'=>__('administrator.from_date'),'class' => 'form-control date_picker']); ?>

                                    </div>
                                </div>
                                <div class="col-sm-4 col-md-4">
                                    <div class="col-sm-4 col-md-4">
                                        <?php echo e(__('administrator.to_date')); ?> :
                                    </div>
                                    <div class="form-group col-sm-8 col-md-8">
                                        <?php echo Form::text('to_date',null, ['placeholder'=>__('administrator.to_date'),'class' => 'form-control date_picker']); ?>

                                    </div>
                                </div>
                                <div class="col-sm-4 col-md-4">
                                    <div class="col-sm-4 col-md-4">
                                        <?php echo e(__('administrator.payment_status')); ?> :
                                    </div>
                                    <div class="form-group col-sm-8 col-md-8">
                                        <?php echo Form::select('payment_status',getPaymentStatus(),null, ['placeholder'=>__('administrator.please_select'),'class' => 'form-control select2']); ?>

                                    </div>
                                </div>
                                <?php if(!ifMember()): ?>
                                    <div class="col-sm-4 col-md-4">
                                        <div class="col-sm-4 col-md-4">
                                            <?php echo e(__('administrator.purchase_by')); ?> :
                                        </div>
                                        <div class="form-group col-sm-8 col-md-8">
                                            <?php echo Form::select('user_id',$user,null, ['placeholder'=>__('administrator.please_select'),'class' => 'form-control select2']); ?>

                                        </div>
                                    </div>
                                    <?php if(request('show')==='p'): ?>
                                        <div class="col-sm-4 col-md-4">
                                            <div class="col-sm-4 col-md-4">
                                                <?php echo e(__('administrator.supplier')); ?> :
                                            </div>
                                            <div class="form-group col-sm-8 col-md-8">
                                                <?php echo Form::select('supplier_id',getSupplier(),null, ['placeholder'=>__('administrator.please_select'),'class' => 'form-control select2']); ?>

                                            </div>
                                        </div>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="box-body table-responsive">
                    <table id="data_table" width="100%" class="table table-bordered table-striped dataTable">
                        <thead>
                        <tr>
                            <th>N°</th>
                            <th><?php echo e(__('administrator.purchase_date')); ?></th>
                            <th><?php echo e(__('administrator.invoice_number')); ?></th>
                            <th><?php echo e(__('administrator.purchase_by')); ?></th>
                            <th><?php echo e(__('administrator.supplier')); ?></th>
                            <th><?php echo e(__('administrator.grand_total')); ?></th>
                            <th><?php echo e(__('administrator.paid')); ?></th>
                            <th><?php echo e(__('administrator.remain_amount')); ?></th>
                            <th><?php echo e(__('administrator.payment_status')); ?></th>
                            <th><?php echo e(__('administrator.status')); ?></th>
                            <th><?php echo e(__('administrator.confirm_received')); ?></th>
                            <th><?php echo e(__('administrator.action')); ?></th>
                        </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script type="text/javascript">
        let table = $('#data_table');
        $(document).ready(function () {
            dataTable();
            table.on('click', '.btn_receive', function () {
                let href = $(this).data('href');
                $.get(href, function (res) {
                    href = href + '?confirm=1';
                    confirmForm(href, '', res, 'success', '900px', '', 'green', {confirm_: 1});
                });
            });
            table.on('click', '.btn_delete', function () {
                let this_ = $(this);

                function td(nth) {
                    return this_.closest('tr').find('td:nth-child(' + nth + ')').text();
                }

                let request = td(2);
                let inv = td(3);
                let date = td(4);
                let text = '';
                if (request) {
                    text += '<b>Request By</b>: ' + request;
                }
                text += '<br><b>Invoice Number</b>: ' + inv;
                text += '<br><b>Request Date</b>: ' + date;


                confirmForm($(this).data('href'), '<?php echo e(__('administrator.are_you_sure')); ?>', text, 'danger', '500px', 'fa fa-trash', 'red');
            });
            $(document).on('change', '.form-control', function () {
                dataTable();
            });
            table.on('click', '.btn-approve', function () {
                let url = $(this).data('url');
                $.confirm({
                    icon: 'flaticon-danger',
                    title: '<?php echo e(__('administrator.confirm')); ?>!',
                    content: '<?php echo e(__('administrator.Are_you_sure_to_Approve_this_item')); ?>?',
                    type: 'blue',
                    typeAnimated: true,
                    closeIcon: true,
                    closeIconClass: 'flaticon-close',
                    buttons: {
                        'confirm': {
                            btnClass: 'btn-blue confirmmm',
                            text: '<?php echo e(__('administrator.confirm')); ?>',
                            action: function () {
                                this.buttons.confirm.disable();
                                $.ajax({
                                    url: url,
                                    type: 'GET',
                                    dataType: 'json',
                                    success: function (data) {
                                        console.log(data);
                                        if (data.route) {
                                            toastDemo('<?php echo e(__('administrator.approved_successfully')); ?>', '<?php echo e(__('administrator.success')); ?>');
                                            $('.jconfirm-buttons .btn-default').trigger('click');
                                            $('#data_table').DataTable().destroy();
                                            dataTable();
                                            $('.jconfirm-closeIcon').trigger('click');
                                        } else {
                                            showWarningToast(data[0]);
                                        }
                                    },
                                    error: function (xhr) {
                                        alertErrorFormController(xhr);
                                    }
                                });
                            }
                        },
                        '<?php echo e(__('administrator.cancel')); ?>': {
                            action: function () {
                            }
                        }
                    }
                });
            });
        });

        function dataTable() {

            table.DataTable().destroy();
            table.DataTable({
                serverSide: true,
                ordering: false,
                searching: false,
                lengthMenu: tbLength,
                ajax: {
                    url: "<?php echo e(route('purchases-item-approval')); ?>?" + $('.form_data').serialize(),
                    data: {show: '<?php echo e(request('show')); ?>'}
                },
                columns:
                    [
                        {data: 'DT_RowIndex'},
                        {data: 'purchase_date'},
                        {data: 'invoice_number'},
                        {data: 'member_id'},
                        {data: 'request_to'},
                        {data: 'grand_total'},
                        {data: 'paid_usd'},
                        {data: 'remain_amount'},
                        {data: 'payment_status'},
                        {data: 'status'},
                        {data: 'confirm_receive'},
                        {data: 'action'},
                    ],
                "initComplete": function (settings, json) {

                }
            });
        }

        // delete Purchase
        $(document).on('click', '.fa.fa-times.btn.btn-sm.btn-danger', function () {
            let url = $(this).data('url');
            $.confirm({
                icon: 'flaticon-danger',
                title: '<?php echo e(__('administrator.confirm')); ?>!',
                content: '<?php echo e(__('administrator.Are_you_sure_to_Approve_this_item')); ?>!',
                type: 'red',
                typeAnimated: true,
                closeIcon: true,
                closeIconClass: 'flaticon-close',
                buttons: {
                    '<?php echo e(__('administrator.confirm')); ?>': {
                        btnClass: 'btn-red',
                        action: function () {
                            $.ajax({
                                url: url,
                                type: 'GET',
                                dataType: 'json',
                                success: function (data) {
                                    if (data[1] == 401) {
                                        showWarningToast(data[0]);
                                    } else {
                                        toastDemo('<?php echo e(__('administrator.delete_item_successfully')); ?>', '<?php echo e(__('administrator.success')); ?>');
                                        $('.jconfirm-buttons .btn-default').trigger('click');
                                        dataTable();
                                        $('.jconfirm-closeIcon').trigger('click');
                                    }
                                }
                            });
                            return false;
                        }
                    },
                    '<?php echo e(__('administrator.cancel')); ?>': {
                        action: function () {
                        }
                    }
                }
            });
        });
        // end
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(branchMenu(), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/vitadermo/resources/views/administrator/stock-inventory/purchases/item/approval.blade.php ENDPATH**/ ?>