<?php Fun::lang() ?>

<?php $__env->startSection('content'); ?>
    <style>
        .select2-container .select2-selection--single {
            height: 35px !important;
            width: 211px !important;
        }

        .col-sm-3 {
            width: 15% !important;
        }

    </style>
    <div class="page">
        <div class="top-content">
            <div class="row">
                <div class="col-sm-12 col-xs-12">
                    <div class="title-add">
                        <div class="pull-left">
                            <h3>Ledger List</h3>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-12" id="block-action">
                    <div class="content-action">
                        <?php echo Form::open(['class'=>'form_search']); ?>

                        <div class="form-group col-sm-3 col-xs-3">
                            <label>Date</label>
                            <?php echo Form::text('date', date('d-m-Y'), array('placeholder' => __('administrator.date'),'class' => 'form-control date_picker')); ?>

                        </div>
                        <div class="form-group col-sm-3 col-xs-3">
                            <label>Account Number</label>
                            <?php echo Form::text('account_number', null, array('placeholder' => __('administrator.account_number'),'class' => 'form-control ')); ?>

                        </div>
                        <?php echo Form::close(); ?>

                        <div class="col-sm-1">
                            <label> </label>
                            <button type="button" class="btn btn-primary fa fa-search button_search form-control">
                                Search
                            </button>
                        </div>
                        <div class="col-sm-1">
                            <label> </label>
                            <button type="button" class="btn btn-success fa fa-print form-control" onclick="printThis_('Income Statement')"></button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12 col-xs-12">
                <div class="form-wrapper">
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="table-responsive">
                                <?php
                                    $account_chart = DB::table('nso007_account_chart as chart')
                                        ->join('nso007_journal as jn', 'jn.journal_acccode', '=', 'chart.id')
                                        ->selectRaw('chart.id,chart.acc_name,chart.acctype,SUBSTRING(chart.acctype, 1, 1) AS acc_type')
                                        ->groupBy('acc_type')
                                        ->get();
                                ?>
                                <div class="acc_type_table">


                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script type="text/javascript">
        $(document).ready(function () {
            getLedger();
            $('.button_search').on('click', function () {
                $('.acc_type_table').html('');
                getLedger();
            });
            $(document).on('change','.number_order',function () {
                let number_order = $(this).val();
                let acc_type = $(this).data('acc');
                LedgerTable(acc_type,number_order,'');
            });
            $(document).on('change','.number_order',function () {
                let number_order = $(this).val();
                let acc_type = $(this).data('acc');
                LedgerTable(acc_type,number_order,'');
            });
        });


        function printThis_(title = '') {

            $('.acc_type_table').printThis({
                header: `
                 <h1 style='text-align: center;padding:50px !important;'>${title}</h1>
                 <hr >
                `
            });
        }


        function getLedger() {
            <?php $__currentLoopData = $account_chart; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $chart): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            LedgerTable('<?php echo e($chart->acc_type); ?>',10);
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        }
        function LedgerTable(acc_type,number_order,loop=1) {
            $.ajax({
                url: '<?php echo e(route('accounting-report.ledger')); ?>?'+$('.form_search').serialize(),
                dataType: 'html',
                method: 'get',
                data: {
                    acc_type,
                    number_order,
                    loop,
                },
                success: function (data) {
                    if(loop){
                        $('.acc_type_table').append(data);
                    }else{
                        $('#tbody'+acc_type).html(data);
                    }
                },
                error(xhr) {
                    alertErrorFormController(xhr);
                }
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(branchMenu(), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/vitadermo/resources/views/Accounting/reports/ledger.blade.php ENDPATH**/ ?>