<!doctype html>
<?php
Fun::lang();
$myBranch = mainBranch();
?>

<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>NSO POS</title>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/pos-invoice.css')); ?>">
    <style>
.tb-header{
    text-align: center!important;
}
    </style>
</head>
<body>
<?php
$hr = '<div style="width: 100%;border-top: 1px dashed rgba(1,1,1,0.5);margin: 10px 0;"></div>';
?>
<?php if($master): ?>
<div class="print_this_form">
    <table class="tb-header" width="100%">
        <tr>
            <td><img src="<?php echo e(asset($myBranch->logo)); ?>" style="width: 100px;"></td>
        </tr>
        <tr>
            <td>
                  <span>
                     <b class="name_logo"><?php echo e($myBranch->name); ?></b><br>
                    <i style="font-size: 11px"><?php echo e($myBranch->address); ?><br><?php echo e($myBranch->contact); ?></i>
                </span>
            </td>
        </tr>
    </table>
    <hr width="40%">
    <table>
        <tr style="text-align: left;">
            <td style="width: 70%;">
                <table>
                    <tr class="font_12">
                        <td><?php echo e(__('administrator.date')); ?> </td>
                        <td>:
                            <?php if($master): ?>
                            <b><?php echo e(date('d-m-Y',strtotime($master->return_date))); ?> </b>
                                <?php endif; ?>
                        </td>
                    </tr>
                    <tr class="font_12">
                        <td class="width-20"><?php echo e(__('administrator.invoice')); ?></td>
                        <td>: <?php echo e($master->invoice_number); ?></td>
                    </tr>
                    <tr class="font_12">
                        <td class="width-20"><?php echo e(__('administrator.returner')); ?></td>
                        <td>: <?php echo e(findUser($master->user_id)->name); ?></td>
                    </tr>
                </table>
            </td>
            <td>
                <?php if($master->customer_id): ?>
                    <?php
                        $customer = findCustomer($master->customer_id);
                    ?>
                    <table>

                        <?php if($customer): ?>
                            <tr class="font_12">
                                <td><?php echo e(__('administrator.customer')); ?></td>
                                <td> : <?php echo e($customer->customer_name); ?></td>
                            </tr>
                            <?php if( $customer->customer_phone): ?>
                                <tr class="font_12">
                                    <td class="width-15"><?php echo e(__('administrator.phone')); ?></td>
                                    <td> : <?php echo e($customer->customer_phone); ?></td>
                                </tr>
                            <?php endif; ?>
                            <?php if($customer->customer_address): ?>
                                <tr class="font_12">
                                    <td><?php echo e(__('administrator.location')); ?></td>
                                    <td> : <?php echo e($customer->customer_address); ?></td>
                                </tr>
                            <?php endif; ?>
                        <?php endif; ?>

                    </table>
                <?php endif; ?>
            </td>
        </tr>
    </table>
    <?php
    $key = 0;
    $total_return = 0;
    $total_change = 0;
    ?>
    <h4 class="m-top-30"><?php echo e(__('administrator.return_item')); ?></h4>
    <table class="table ">
        <thead>
        <tr>
            <th width="6%">#</th>
            <th><?php echo e(__('administrator.item_name')); ?></th>
            <th><?php echo e(__('administrator.item_code')); ?></th>
            <th><?php echo e(__('administrator.qty')); ?></th>
            <th><?php echo e(__('administrator.price')); ?></th>
            <th><?php echo e(__('administrator.total')); ?></th>
        </tr>
        </thead>
        <tbody>


        <?php if($in): ?>
            <?php $__currentLoopData = $in; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                $punit = \App\Model\ProductUnitModel::find($row->product_unit_id);
                $product = getProductById($punit->product_id);
                $unit = (findUnit($punit->unit_id));

                $itotal = $row->price*$row->qty;
                $total_return += $itotal;
                ?>
                <tr role="row">
                    <td><?php echo e($key+=1); ?></td>
                    <td><?php echo e($product->product_name); ?></td>
                    <td><?php echo e($punit->item_code); ?></td>
                    <td><?php echo e($row->qty.' '.($unit?$unit->unit:'')); ?></td>
                    <td>$<?php echo e(number_format($row->price,2)); ?></td>
                    <td>$<?php echo e(number_format($itotal,2)); ?></td>

                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        <?php endif; ?>
        </tbody>
        <tr class="">
            <td colspan="4" class="text-left no-border" style="position: relative;"></td>
            <td style="" class="my-customer-border"><span></span><?php echo e(__('administrator.sub_total')); ?>

            </td>
            <td class="text-left " style="position: relative;">$<?php echo e($total_return); ?></td>
        </tr>

    </table>
    <h4 class="m-top-30"><?php echo e(__('administrator.change_item')); ?></h4>
    <table class="table ">
        <thead>
        <tr>
            <th width="6%">#</th>
            <th><?php echo e(__('administrator.item_name')); ?></th>
            <th><?php echo e(__('administrator.item_code')); ?></th>
            <th><?php echo e(__('administrator.qty')); ?></th>
            <th><?php echo e(__('administrator.price')); ?></th>
            <th><?php echo e(__('administrator.total')); ?></th>
        </tr>
        </thead>
        <tbody>


        <?php if($out): ?>
            <?php $__currentLoopData = $out; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                $punit = \App\Model\ProductUnitModel::find($row->product_unit_id);
                $product = getProductById($punit->product_id);
                $unit = (findUnit($punit->unit_id));
                $itotal = $row->price*$row->qty;
                $total_change += $itotal;

                ?>
                <tr role="row">
                    <td><?php echo e($key+=1); ?></td>
                    <td><?php echo e($product->product_name); ?></td>
                    <td><?php echo e($punit->item_code); ?></td>
                    <td><?php echo e($row->qty.' '.($unit?$unit->unit:'')); ?></td>
                    <td>$<?php echo e(number_format($row->price,2)); ?></td>
                    <td>$<?php echo e(number_format($itotal,2)); ?></td>

                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        <?php endif; ?>
        </tbody>
        <tr class="">
            <td colspan="4" class="text-left no-border" style="position: relative;"></td>
            <td style="" class="my-customer-border"><span></span><?php echo e(__('administrator.sub_total')); ?>

            </td>
            <td class="text-left " >$<?php echo e($total_change); ?></td>
        </tr>
    </table>
</div>
    <?php endif; ?>
</body>
</html>
<?php /**PATH /home/nsowos/public_html/vitadermo/resources/views/pos/product-return/show.blade.php ENDPATH**/ ?>