<?php $__env->startSection('content'); ?>
<?php Fun::lang()?>
<div class="row">
    <div class="col-xs-12">
        <div class="box">
            <div class="box-header">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <div class="title-add">
                            <div class="pull-left">
                                <h3><?php echo e(__('administrator.invoice')); ?></h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <form class="form_data">
                            <div class="col-sm-4 col-md-4 ">
                                <div class="col-sm-4 col-md-4">
                                    <?php echo e(__('administrator.reference_invoice')); ?> :
                                </div>
                                <div class="form-group col-sm-8 col-md-8">
                                    <?php echo Form::text('reference_invoice',null, ['placeholder'=>__('administrator.reference_invoice'),'class' => 'form-control ']); ?>

                                </div>
                            </div>

                            <div class="col-sm-4 col-md-4 ">
                                <div class="col-sm-4 col-md-4">
                                    <?php echo e(__('administrator.sale_by')); ?> :
                                </div>
                                <div class="form-group col-sm-8 col-md-8">
                                    <?php echo Form::select('user_id',getUsers(),null, ['placeholder'=>__('administrator.please_select'),'class' => 'form-control select2 ']); ?>

                                </div>
                            </div>
                            <div class="col-sm-4 col-md-4 ">
                                <div class="col-sm-4 col-md-4">
                                    <?php echo e(__('administrator.payment_methods')); ?> :
                                </div>
                                <div class="form-group col-sm-8 col-md-8">
                                    <?php echo Form::select('payment_type',getPaymentType(),null, ['placeholder'=>__('administrator.please_select'),'class' => 'form-control select2 ']); ?>

                                </div>
                            </div>
                            <div class="col-sm-4 col-md-4">
                                <div class="col-sm-4 col-md-4">
                                    <?php echo e(__('administrator.from_date')); ?> :
                                </div>
                                <div class="form-group col-sm-8 col-md-8">
                                    <?php echo Form::text('from_date',null, ['placeholder'=>__('administrator.from_date'),'class' => 'form-control date_picker']); ?>

                                </div>
                            </div>
                            <div class="col-sm-4 col-md-4">
                                <div class="col-sm-4 col-md-4">
                                    <?php echo e(__('administrator.to_date')); ?> :
                                </div>
                                <div class="form-group col-sm-8 col-md-8">
                                    <?php echo Form::text('to_date',null, ['placeholder'=>__('administrator.to_date'),'class' => 'form-control date_picker']); ?>

                                </div>
                            </div>

                            <div class="col-sm-12 col-md-12 form-group text-right">
                                <button class="btn btn-md btn-warning btn-clear"
                                        type="button"><?php echo e(__('administrator.clear')); ?></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="box-body table-responsive">
                <table id="data_table" width="100%" class="table table-bordered table-striped dataTable">
                <thead>
                    <tr>
                        <th>N°</th>
                        <th><?php echo e(__('administrator.date')); ?></th>
                        <th><?php echo e(__('administrator.reference_invoice')); ?></th>
                        <th><?php echo e(__('administrator.sale_by')); ?></th>
                        <th><?php echo e(__('administrator.member')); ?></th>
                        <th><?php echo e(__('administrator.grand_total')); ?></th>
                        <th><?php echo e(__('administrator.paid')); ?></th>
                        <th><?php echo e(__('administrator.remain_amount')); ?></th>
                        <th><?php echo e(__('administrator.payment_type')); ?></th>
                        <th><?php echo e(__('administrator.payment_status')); ?></th>
                        <th><?php echo e(__('administrator.action')); ?></th>
                    </tr>
                </thead>
                <tbody>
                </tbody>
            </table>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script type="text/javascript">
//  start datatable
    var record = 20;
    var page = 1;
    let thistable = $('#data_table');
    $(document).ready(function() {
        getTable();
        $('.form_data').on('change','input,select',function () {
            getTable();
        });
        $('.btn-clear').on('click',function () {
            $('.form_data').find('select,input').val('').change();
            getTable();
        });
    });
    function getTable() {
        let data = $('.form_data').serialize();
        thistable.DataTable().destroy();
        thistable.DataTable({
            serverSide: true,
            ordering: false,
            searching: false,
            lengthMenu: tbLength,
            ajax: {
                url:"<?php echo e(route('wholesale.datatables')); ?>?"+data,

            },
            columns:
                [
                    {data: 'DT_RowIndex'},
                    {data: 'sale_date'},
                    {data: 'reference_number'},
                    {data: 'seller'},
                    {data: 'member'},
                    {data: 'grand_total'},
                    {data: 'paid_amount_usd'},
                    {data: 'remain'},
                    {data: 'payment_method'},
                    {data: 'payment_status'},
                    {data: 'action'},
                ],
            "initComplete": function (settings, json) {

            }
        });
    }
// end

    $(document).on('click', '.showDetail', function(){
        let _this = $(this);
        var status = _this.data('status');
        var payment_url = _this.data('payment_url');
        var get_payment_url = _this.data('get_payment_url');
        var payment_id = _this.data('payment_id');
        $.ajax({
            url: _this.data('href'),
            dataType: 'html',
            method: 'get',
            success: function (data) {
                $.confirm({
                    title: '',
                    theme: 'modern',
                    useBootstrap: false,
                    boxWidth: '700px',
                    closeAnimation: 'zoom',
                    content: data,
                    buttons: {
                        hidden: {
                            btnClass: 'btn btn-warning click_close_form',
                            text: '<?php echo e(__('administrator.close')); ?>',
                            keys: ['esc'],
                            action: function () {

                            }
                        },
                        enter: {
                            btnClass: 'btn btn-info',
                            text: '<?php echo e(__('administrator.print')); ?>',
                            keys: ['enter'],
                            action: function () {
                                let this_ = this.$content.find('.print_this_form');
                                this_.printThis({
                                    //loadCSS: "<?php echo e(asset('assets/css/pos-invoice.css')); ?>",
                                    beforePrint: function () {
                                        $(document).find('button').hide();
                                    },
                                    afterPrint: function () {
                                        $(document).find('button').show();
                                    },
                                });
                                return false;
                            }
                        },
                        payment: {
                            isHidden: status=== 'paid',
                            btnClass: 'btn-blue',
                            action: function(){
                                getHtmlForm(get_payment_url,'<?php echo e(__('administrator.add_payment')); ?>','500px');
                                return false;
                            }
                        },
                    },
                });
            },
            error(xhr) {
                alertErrorFormController(xhr);
            }
        });
    });

    $(document).on('input', 'input[name="amount"]', function(){
        var remain = $('input[name="remain"]').val();
        remain = remain.replace("ដុល្លា" ,"");
        remain = remain.replace("," ,"");
        var pay = $('.decimal').val();
        if(parseFloat(pay) > parseFloat(remain)){
            $('.decimal').val(remain);
        }
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(branchMenu(), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/vitadermo/resources/views/pos/pos-wholesale/index.blade.php ENDPATH**/ ?>