
<?php $__env->startSection('content'); ?>
<?php Fun::lang()?>
<div class="row">
    <div class="col-xs-12">
        <div class="box">
            <div class="box-header">
                <div class="row">
                <div class="col-sm-12 col-xs-12">
                    <div class="title-add">
                        <div class="pull-left">
                            <h3><?php echo e(__('administrator.report_purchase')); ?></h3>
                        </div>
                        <div class="pull-right">

                        </div>
                    </div>
                </div>
            </div>
            </div>
            <div class="box-body table-responsive">
                <table id="data_table" width="100%" class="table table-bordered table-striped dataTable">
                <thead>
                    <tr>
                        <th>N°</th>
                        <th><?php echo e(__('administrator.invoice_number')); ?></th>
                        <th><?php echo e(__('administrator.purchase_date')); ?></th>
                        <th><?php echo e(__('administrator.total')); ?></th>
                        <th><?php echo e(__('administrator.paid')); ?></th>
                        <th><?php echo e(__('administrator.remain_amount')); ?></th>
                        <th><?php echo e(__('administrator.payment_status')); ?></th>
                        <th><?php echo e(__('administrator.total_qty')); ?></th>
                    </tr>
                    <tr>
                        <td></td>
                        <td>
                            <input type="text" name="invoice_number" class="form-control"  placeholder="<?php echo e(__('administrator.invoice_number')); ?>" autocomplete="off">
                        </td>
                        <td>
                            <input type="text" name="created_at" class="form-control"  placeholder="<?php echo e(__('administrator.purchase_date')); ?>" autocomplete="off" value="">
                        </td>
                        <td>
                            <input type="text" name="total" class="form-control"  placeholder="<?php echo e(__('administrator.total')); ?>" autocomplete="off" value="">
                        </td>
                        <td>
                            <input type="text" name="paid" class="form-control"  placeholder="<?php echo e(__('administrator.paid')); ?>" autocomplete="off" value="">
                        </td>
                        <td>
                            <input type="text" name="remain_amount" class="form-control"  placeholder="<?php echo e(__('administrator.remain_amount')); ?>" autocomplete="off" value="">
                        </td>
                        <td>
                            <?php echo Form::select('payment_status', ['owe' => 'Owe', 'paid' => 'Paid'], null, ['class' => 'form-control', 'placeholder' => __('administrator.payment_status')]); ?>

                        </td>
                        <td></td>

                    </tr>
                </thead>
                <tbody></tbody>
            </table>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script type="text/javascript">
    $(document).ready(function() {
        dataTable();
    });
    $(document).on('change', 'select[name="payment_status"]', function() {
        dataTable();
    });

    $(document).on('blur', '#data_table input', function(){
        dataTable();
    })


    function dataTable() {
        var invoice_number = $('input[name="invoice_number"]').val();
        var created_at = $('input[name="created_at"]').val();
        var total = $('input[name="total"]').val();
        var paid = $('input[name="paid"]').val();
        var remain_amount = $('input[name="remain_amount"]').val();
        var payment_status = $('select[name="payment_status"]').val();
        $('#data_table').DataTable().destroy();

        $('#data_table').DataTable({
            "oLanguage": {
                "sSearch": "<?php echo e(__('administrator.search')); ?>:",
                "sLengthMenu": "<?php echo e(__('administrator.display')); ?> _MENU_ <?php echo e(__('administrator.record_per_page')); ?>",
                "sZeroRecords": "<?php echo e(__('administrator.Nothing_foundsorry')); ?>",
                "sInfo": "<?php echo e(__('administrator.showing')); ?> _START_ <?php echo e(__('administrator.to')); ?> _END_ <?php echo e(__('administrator.of')); ?> _TOTAL_ <?php echo e(__('administrator.record')); ?>",
                "sInfoEmpty": "<?php echo e(__('administrator.showing')); ?> 0 <?php echo e(__('administrator.to')); ?> 0 <?php echo e(__('administrator.of')); ?> 0 <?php echo e(__('administrator.record')); ?>",
                "sInfoFiltered": "(<?php echo e(__('administrator.filter_form')); ?> _MAX_ <?php echo e(__('administrator.total_records')); ?>)",
                "oPaginate": {
                    "sFirst": "<?php echo e(__('administrator.first')); ?>",
                    "sLast": "<?php echo e(__('administrator.last')); ?>",
                    "sNext": "<?php echo e(__('administrator.next')); ?>",
                    "sPrevious": "<?php echo e(__('administrator.previous')); ?>"
                },
            },
            serverSide: true,
            ordering: false,
            searching: false,
            dom: 'lBfrtip',
            buttons: [
                {
                    extend: 'excelHtml5',
                    autoFilter: true,
                    className: 'btn btn-info pull-right',
                    filename: menu_name,
                    title: menu_name,
                    sheetName: menu_name,
                    footer:true,
                    header: true,
                    text: 'Save as Excel',
                },
            ],
            lengthMenu: tbLength,
            ajax: {
                url:"<?php echo e(route('report-purchases.index')); ?>",
                data:{
                    invoice_number,
                    created_at,
                    total,
                    paid,
                    remain_amount,
                    payment_status,
                }
            },
            columns:
                [
                    {data: 'DT_RowIndex'},
                    {data: 'invoice_number'},
                    {data: 'purchase_date'},
                    {data: 'total'},
                    {data: 'paid_usd'},
                    {data: 'remain_amount'},
                    {data: 'payment_status'},
                    {data: 'total_qty'},
                ],
            "initComplete": function (settings, json) {

            }
        });
    }
// end
// delete Purchase
    $(document).on('click', '.fa.fa-trash.btn.btn-sm.btn-danger', function(){
        var url = $(this).data('url');
        $.confirm({
            icon: 'flaticon-danger',
            title: 'Confirm!',
            content: 'Are you sure to delete this item?',
            type: 'red',
            typeAnimated: true,
            closeIcon: true,
            closeIconClass: 'flaticon-close',
            buttons: {
                confirm: {
                    btnClass: 'btn-red',
                    action: function () {
                        $.ajax({
                            type: 'DELETE',
                            url: url,
                            data:{
                                '_token': '<?php echo e(csrf_token()); ?>'
                            },
                            dataType:'json',
                            success:function(data){
                                if(data[1] == 401){
                                    showWarningToast(data[0]);
                                }else{
                                    showSuccessToast('Purchase deleted successfully!');
                                    $('.jconfirm-buttons .btn-default').trigger('click');
                                    $('#data_table').DataTable().destroy();
                                    dataTable();
                                }
                            }
                        });
                        return false;
                    }
                },
                cancel: {
                    action: function () {
                    }
                }
            }
        });
    });
// end
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(branchMenu(), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/vitadermo/resources/views/administrator/reportpurchases/index.blade.php ENDPATH**/ ?>