
<?php $__env->startSection('content'); ?>
    <?php Fun::lang() ?>
    <style>
        .select2 {
            width: 100% !important;
        }
        .overflow-auto{
            overflow-y: scroll;
            height: 70vh;
            border: 1px solid rgba(1,1,1,0.5);
        }
        .overflow-auto::-webkit-scrollbar {
            width: 3px;
        }
        .overflow-auto::-webkit-scrollbar-thumb {
            background: #666;
            border-radius: 3px;
        }
    </style>
    <div class="page-purchases">
        <div class="preview">
            <?php echo Form::open(array('route' => 'transfer-stock.store','method'=>'POST','enctype'=>'multipart/form-data','id'=>'submit_post','class'=>'jform')); ?>

            <div class="col-sm-12 col-md-12">
                <div class="row">
                    <div class="col-sm-8 col-md-8">
                        <div class="col-sm-12 col-md-12 ">
                            <h3><?php echo e(__('administrator.tranfer_stock')); ?></h3>
                            <div class="overflow-auto">
                                <table class="table table-hover text-center">
                                    <thead class="">
                                    <tr>
                                        <th>#</th>
                                        <th><?php echo e(__('administrator.item_name')); ?></th>
                                        <th><?php echo e(__('administrator.unit')); ?> <span class="text-red">*</span></th>
                                        <th><?php echo e(__('administrator.stock_qty')); ?> <span class="text-red">*</span></th>
                                        <th><?php echo e(__('administrator.qty')); ?> <span class="text-red">*</span></th>
                                        <th style="padding: 5px">
                                            <button type="button" class="btn btn-default btn_add_return btn-sm"><i
                                                        class="fa fa-plus"></i></button>
                                        </th>
                                    </tr>
                                    </thead>
                                    <tbody id="return_item">

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-4 col-md-4 ">
                        <h3>&nbsp;</h3>
                        <div class="col-sm-6 form-group">
                            <label class="required"><?php echo e(__('administrator.date')); ?> :</label>
                            <?php echo Form::text('date',date('d-m-Y'),array('placeholder'=>__('administrator.date'),'class'=>'date_picker form-control','required')); ?>

                        </div>
                        <div class="col-sm-6 form-group">
                            <label class="required"><?php echo e(__('administrator.transfer_to')); ?> :</label>
                            <?php echo Form::select('transfer_to',getBranch(null,1),null,array('placeholder'=>__('administrator.please_select'),'class'=>' form-control select2','required')); ?>

                        </div>

                        <div class="col-sm-12 "></div>
                        <div class="col-sm-12 form-group">
                            <label><?php echo e(__('administrator.note')); ?></label>
                            <?php echo Form::textarea('note', null, ['placeholder'=>__('administrator.note'),'class' => 'form-control form-control no-resize','maxlength'=>'20','rows'=>'3']); ?>

                        </div>
                        <div class="col-sm-12">
                            <div class="">
                                <button type="submit"
                                        class="btn btn-primary pull-right"><?php echo e(__('administrator.submit')); ?></button>
                                <button type="button" class="btn btn-warning"
                                        onclick="history.back(1)"><?php echo e(__('administrator.back')); ?></button>
                            </div>
                        </div>
                    </div>
                </div>
                <?php echo Form::close(); ?>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script type="text/javascript">
        $(document).ready(function () {
            add_row();
            $('body').addClass('sidebar-collapse');
            $(document).on('click', '.btn_remove', function () {
                $(this).closest('tr').remove();
            });
            $(document).on('click', '.btn_add_return', function () {
                add_row();
            });
            $(document).on('change', '.search_product', function () {
                let this_=$(this);
                let product_unit = this_.val();
                this_.closest('tr').find('.select_unit').html('').select2();
                $.get('<?php echo e(route('get-product-unit-and-shelf-by-product-id')); ?>?product_unit='+product_unit,function (data) {
                    this_.closest('tr').find('.select_unit').html('<option value=""><?php echo e(__('administrator.please_select')); ?></option>'+data.unit).select2();
                });
            });

            $(document).on('change', '.select_unit', function () {
                let this_=$(this);
                let product_unit = this_.closest('tr').find('.search_product').val();
                let unit = this_.closest('tr').find('.select_unit').val();
                $.get('<?php echo e(route('get-stock-and-price-by-shelf-id')); ?>',{product_unit,unit},function (data) {
                    this_.closest('tr').find('.stock_qty').val(data.stock);
                    check_stock(this_);
                });
            });
            $('table').on('keyup', '.item_qty', function () {
                let this_=$(this);
                check_stock(this_);
            });

        });
        function check_stock(this_) {
            let qty = this_.closest('tr').find('.item_qty').val();
            let stock = this_.closest('tr').find('.stock_qty').val();
            stock = stock?parseFloat(stock):0;
            qty = qty?parseFloat(qty):0;
            if(qty>stock){
                this_.closest('tr').find('.item_qty').val(stock);
            }
        }
        function add_row() {

            let key = $('#return_item tr').length;
            let html = ` <tr>
               <td>${key+1}</td>
               <td>
                   <?php echo Form::select('product[]', [], null, ['class' => 'form-control search_product','placeholder'=>__('administrator.please_select'),'required']); ?>

                </td>
                <td>
                    <?php echo Form::select('unit[]', [], null, ['class' => 'form-control select2 select_unit','placeholder'=>__('administrator.please_select'),'required']); ?>

                </td>
                 <td>
                    <?php echo Form::text('stock_qty[]', 0, ['class' => 'form-control stock_qty','placeholder'=>__('administrator.stock_qty'),'readonly']); ?>

                </td>
                 <td>
                    <?php echo Form::text('qty[]', 1, ['class' => 'form-control number-only item_qty','placeholder'=>__('administrator.qty'),'required']); ?>

                </td>
                <td><button class="btn btn-danger btn_remove" type="button"><i class="fa fa-times "></i></button></td>
            </tr>`;
            $('#return_item').append(html);
            search_product();
            date_picker();
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(branchMenu(), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/vitadermo/resources/views/administrator/transfer-stock/create.blade.php ENDPATH**/ ?>