<?php
$branch = findBranch(1);
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="POS <?php echo e($branch->name); ?>">
    <title><?php echo e($branch->name); ?></title>
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link rel="icon" href="<?php echo e($branch->logo); ?>">
    <title>Login to <?php echo e($branch->name); ?></title>
</head>
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('/css/bootstrap.min.css')); ?>">
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('/css/login-style.css')); ?>">
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('/css/responsive.css')); ?>">

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
<body>
<header class="header-area">
    <div class="header-main bg-red white">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="logo-wrapper">
                        <div class="logo">
                            
                            <h2><b><?php echo e($branch->name); ?></b></h2>
                        </div>
                    </div>
                    <div class="header-main-content">
                        <div class="header-info">
                            
                            <div class="header-info-text">
                                <h4><?php echo e($branch->contact); ?></h4>
                                <span>We are open 9 am - 17pm</span>
                            </div>
                        </div>
                        <div class="header-info">
                            <img src="<?php echo e(asset('/icons/message.png')); ?>" alt="">
                            <div class="header-info-text">
                                <h4><?php echo e($branch->email); ?></h4>
                                <span>You can mail us</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Main Menu Area Start -->
    <div class="mainmenu-area header-sticky d-lg-block d-md-block">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 col-12">
                    <div class="main-menu text-center">
                        <div>
                            <ul>
                                <li><a href="#home">HOME</a></li>
                                <li><a href="#qoute">QOUTE</a></li>
                                <li><a href="#service">SERVICES</a></li>
                                <li><a href="#about">ABOUT US</a></li>
                                <li><a href="#client">Clients</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</header>

<div class="intro-section" id="home">
    <div class="slide-1 bg-1">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-12">
                    <div class="row align-items-center">
                        <div class="col-lg-6 mb-4">
                            <h1>ឱកាសចំណេញពីការវិនិយោគ</h1>
                            <p class="mb-4">យើង​មាន​ការ​ប្ដេជ្ញា​ចិត្ត​ក្នុង​ការ​ផ្តល់​ជូន​នូវ​ផលិតផល​ដែល​មាន​គុណភាព
                                ដើម្បី​លើក​ស្ទួយ​កម្រិត​ស្តង់ដារ​នៃ​ការ​រស់នៅ
                                និង​ការ​ទទួល​បាន​នូវ​សុខមាលភាព​ល្អ​ជូន​ដល់​ប្រជាជន​កម្ពុជា។.</p>
                            <p><a href="https://utrustgroup.biz" class="btn btn-primary py-3 px-5 btn-pill"
                                  target="blank">visit our website</a></p>
                        </div>
                        <div class="col-lg-5 ml-auto">
                            <form action="<?php echo e(url('login')); ?>" method="post" class="form-box login-form jform">
                                <?php echo csrf_field(); ?>
                                <h3 class="h4 text-black mb-4 text-center text-uppercase"><?php echo e($branch->name); ?></h3>
                                <div class="form-group">
                                    <input type="text" name="username" class="form-control"
                                           placeholder="Username" required>
                                </div>
                                <div class="form-group">
                                    <input type="password" name="password" class="form-control" placeholder="Password"
                                           autocomplete="on" required>
                                </div>
                                <div class="form-group text-center">
                                    <button type="submit" class="btn btn-primary w-100">
                                        <span class="login_text"><?php echo e(__('administrator.login')); ?></span><i class="fa fa-circle-o-notch fa-spin fa-fw login_loading"></i></button>
                                </div>
                                <div class="form-group text-center error text-warning" ></div>

                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="<?php echo e(asset('/assets/js/jquery3.4.1.min.js')); ?>"></script>
<script src="<?php echo e(asset('/assets/js/jquery.form.js')); ?>"></script>
<script>
    $('.login_loading').hide();
    $(document).ready(function () {
        $('.jform').ajaxForm({
            beforeSend: function () {
                $('.login_text').hide();
                $('.login_loading').show();
            },
            uploadProgress: function (event, position, total, percentComplete) {
                console.log(percentComplete);
            },
            success: function (response) {
                if (response.status === 'success') {
                    location.href = response.route;
                } else {
                    $('.login_text').show();
                    $('.login_loading').hide();
                    $('.error').empty().text('These credentials do not match our records.');
                }
            },
            error: function (xhr, textStatus, errorThrown) {
                let error = xhr.responseJSON.errors;
                $('.error').empty().text(error.username);
                $('.login_text').show();
                $('.login_loading').hide();
            },
        });
    });
</script>
</body>
</html>
<?php /**PATH /home/nsowos/public_html/vitadermo/resources/views/frontend/login.blade.php ENDPATH**/ ?>