<?php

    use App\Http\Controllers\Administrator\UserController;
    use App\Model\PaymentDetailModel;
    use App\Model\PaymentModel;
    use App\Model\PurchaseDetailsModel;
    use App\Model\PurchaseModel;
    use App\Model\SaleDetailsModel;
    use App\Model\SaleModel;
    use App\Model\StockModel;
    use Illuminate\Support\Facades\Auth;

    Route::get('/clear-cache', function () {
        Artisan::call('cache:clear');
        return "Cache is cleared";
    });
    Auth::routes();
// Language Controller
    Route::get('/en', 'LanguageController@en')->name('en');
    Route::get('/km', 'LanguageController@km')->name('km');

    Auth::routes(['verify' => true]);

    Route::group(['namespace' => 'FrontEnd'], function () {
        Route::GET('/', function () {
            return redirect('login');
        })->name('home');
    });
    Route::get('login', 'FrontEnd\LoginController@login')->name('customer_login');
    Route::POST('/sidebar-mini', 'Administrator\DashboardAdministratorController@sidebar_mini')->name('sidebar_mini');

    Route::group(['middleware' => 'Administrator', ['auth'], 'namespace' => 'Administrator'], function () {

        Route::resource('roles', 'RoleController');
        Route::resource('permissions', 'PermissionController');
        Route::resource('users', 'UserController');
        route::resource('customer-care', 'CustomerCaseController');
        Route::resource('customer', 'CustomerController');

        Route::get('/users-delete/{id}', 'UserController@destroy')->name('users.delete');
        Route::match(['GET', 'POST'], 'customer-change-status/{id}', 'CustomerController@changeStatus')->name('customer-change-status');
        Route::get('customer-delete/{id}', 'CustomerController@destroy')->name('customer-delete');


        Route::match(['GET', 'POST'], 'customer-change-type-of-customer/{id}', 'CustomerController@change_type_customer')->name('customer-change-type-of-customer');
        Route::get('admin-dealer/{type?}', 'CustomerController@customer_dealer')->name('admin-dealer');
        Route::match(['GET', 'POST'], 'customer-change-agent/{id}', 'CustomerController@change_agent')->name('customer-change-agent');
        Route::get('upcoming-customer-care', 'CustomerController@upcoming_customer_care')->name('upcoming-customer-care');
        Route::get('upcoming-customer-product', 'CustomerController@upcoming_customer_product')->name('upcoming-customer-product');
        Route::get('customer-pospect', 'CustomerController@pospect')->name('customer.pospect');
        Route::get('customer-dealer', 'CustomerController@dealer')->name('customer.dealer');
        Route::get('customer-partner', 'CustomerController@partner')->name('customer.partner');
        Route::match(['GET', 'POST'], 'customer-history/{id}', 'CustomerController@history')->name('customer.history');
        Route::match(['GET', 'POST'], 'customer-product-history/{id}', 'CustomerController@product_history')->name('customer.product-history');
        Route::match(['GET', 'POST'], 'customer-care-view/{id}', 'CustomerCaseController@index')->name('customer_care.view');
        Route::get('customer-care-consultant/{id}', 'CustomerController@consultant')->name('customer-care-consultant');
        Route::get('customer-care-view-delete/{id}', 'CustomerCaseController@destroy')->name('customer-care-view-delete');

        route::resource('suppliers', 'SupplierController');
        Route::resource('currency', 'CurrencyController');
        route::get('/currency-changeStatus', 'CurrencyController@currency_changeStatus')->name('currency-changeStatus');
        Route::GET('get-image', 'DashboardAdministratorController@get_image')->name('get-image');
        Route::GET('currency-history', 'CurrencyController@history')->name('currency-history');
        Route::GET('app-dashboard', 'DashboardAdministratorController@index')->name('app_dashboard');
        Route::GET('dashboard-sale-purchase', 'DashboardAdministratorController@sale_purchase')->name('dashboard-sale-purchase');
        Route::GET('dashboard-pos-stock-request', 'DashboardAdministratorController@pos_request_stock_request')->name('dashboard-pos-stock-request');
        Route::GET('dashboard-income-statement', 'DashboardAdministratorController@get_income_statement')->name('dashboard-income-statement');


        //====================PeoPle======================
        Route::get('user-status', 'UserController@user_status');

        Route::GET('customer/change-status/{id}/{status}', 'CustomerController@change_status')->name('customer.change-status');

        //===============================Purchase============================================
        route::resource('/purchases', 'PurchaseController');

        Route::POST('purchase-addcart/', 'PurchaseController@purchase_addcart')->name('purchase_addcart');
        Route::get('get-purchase-addcart/', 'PurchaseController@get_purchase_addcart')->name('get_purchase_addcart');
        Route::POST('purchase-remove-session', 'PurchaseController@purchase_remove_session')->name('purchase_remove_session');
        Route::POST('purchase-removecart', 'PurchaseController@purchase_removecart')->name('purchase_removecart');
        Route::patch('purchase-updatecart', 'PurchaseController@purchase_updatecart')->name('purchase_updatecart');
        Route::POST('autocomplete', 'PurchaseController@autocomplete')->name('autocomplete');
        Route::DELETE('destroy-puchase-detail/{detail_id}', 'PurchaseController@destroy_puchase_detail')->name('destroy_puchase_detail');
        Route::POST('/purchase-update-all', 'PurchaseController@update_all')->name('update-all-purchase.cart-session');

    });

    Route::group(['middleware' => 'Administrator', ['auth'], 'namespace' => 'Administrator\stock_inventory'], function () {
        //++++++++++++++++++++++++++purchases-item +++++++++++++++++++++++++++++
        route::resource('/purchases-item', 'PurchaseItemController');
        route::get('purchases-item-get-cost/{id?}', function ($id) {return response()->json(getProductCost($id));});
        route::get('purchases-item-get-approval', 'PurchaseItemController@getApproval')->name('purchases-item-approval');
        route::get('purchases-item-get-approval/{id?}/{type?}', 'PurchaseItemController@updateApproval')->name('purchases-item-approve');
        route::get('purchases-item-confirm-receive/{id?}', 'PurchaseItemController@confirm_receive')->name('purchases-item-confirm-receive');
        Route::GET('purchases-item-delete/{id}', 'PurchaseItemController@delete')->name('purchases-item-delete');

        //++++++++++++++++++++++++++ Adjustment +++++++++++++++++++++++++++++
        route::resource('adjustment', 'AdjustmentController');

        //++++++++++++++++++++++++++ Member Stock +++++++++++++++++++++++++++++
    });

//++++++++++++++++++++++++++setup-item +++++++++++++++++++++++++++++
    Route::group(['middleware' => 'AdminOnly', ['auth'], 'namespace' => 'Administrator\Item'], function () {
        route::resource('category', 'CategoryController');
        route::resource('unit', 'UnitController');
        route::resource('brand', 'BrandController');
        route::resource('shelf', 'ShelfController');
        route::resource('product', 'ProductController');
    });
//++++++++++++++++++++++++++ Setup +++++++++++++++++++++++++++++
    Route::group(['middleware' => 'AdminOnly', ['auth'], 'namespace' => 'setup'], function () {
        Route::resource('member-type', 'MemberTypeController');
        Route::resource('customer-status', 'CustomerStatusController');
        Route::resource('reason', 'ReasonController');
        Route::get('customer-status-delete/{id}', 'CustomerStatusController@destroy')->name('customer-status-delete');
        Route::get('reason-delete/{id}', 'ReasonController@destroy')->name('reason-delete');

    });
    Route::group(['middleware' => ['Administrator'], ['auth'], 'namespace' => 'setup'], function () {
        Route::get('member', [UserController::class, 'index'])->name('member.index');
    });


//++++++++++++++++++++++++++Human Resource +++++++++++++++++++++++++++++

    Route::group(['middleware' => 'Administrator', ['auth'], 'namespace' => 'HR'], function () {
        Route::resource('branch', 'HrBranchController');
        Route::get('branch-set-main/{id}', 'HrBranchController@branch_changeStatus')->name('branch-set-main');
    });
//++++++++++++++++++++++++++ Branch +++++++++++++++++++++++++++++
    Route::group(['middleware' => 'Branch', ['auth'], 'namespace' => 'Branch'], function () {
        Route::resource('dashboard-branch', 'BranchDashboardController');
        //=============================== Report ============================================
        Route::GET('/report-stockreport-stock-branch', 'RequestStockController@get_report_stock')->name('get-report-stock');
        Route::GET('/report-sale-branch', 'SallerRequestController@get_report_sale')->name('get-report-sale');
        Route::GET('/report-sale-detail-branch', 'SallerRequestController@get_report_sale_detail')->name('get-report-sale-detail');
    });

    Route::group(['middleware' => 'pos', ['auth'], 'namespace' => 'Branch'], function () {
//=============================== Request Stock =============
        Route::resource('request-stock', 'RequestStockController');

        Route::GET('request-stock-get-update-status/{id}', 'RequestStockController@get_update_status')->name('request-stock.get-update-status');
        Route::POST('request-stock-update-status/{id}', 'RequestStockController@update_status')->name('request-stock.update-status');

        Route::get('request-stock-update-confirm/{id}', 'RequestStockController@request_stock_update_confirm')->name('request-stock-update-confirm');
        Route::post('request-stock-update-confirm/{id}', 'RequestStockController@request_stock_update_confirm')->name('request-stock-update-confirm');

        Route::resource('illness-type', 'IllnessTypeController');
        Route::get('illness-type-delete/{id}', 'IllnessTypeController@destroy')->name('illness-type.delete');


        // Tranfer Stock
        Route::resource('tranfer-stock', 'TranferStockController');
        Route::get('tranfer-stock-add-product/{id?}', 'TranferStockController@addProduct')->name('tranfer-stock-addProduct');
        Route::get('tranfer-stock-get-product', 'TranferStockController@getProduct')->name('tranfer-stock-getProduct');
        Route::get('tranfer-stock-update-product/{id}', 'TranferStockController@updateProduct');
        Route::get('tranfer-stock-delete-product/{id}', 'TranferStockController@deleteProduct');
        Route::get('tranfer-stock-delete-product', function () {
            session()->forget('tranferStock');
        });
        Route::POST('tranfer-stock-autocomplete', 'TranferStockController@wholesale_autocomplete')->name('tranfer-stock-autocomplete');
        Route::GET('tranfer-stock-scan-code', 'TranferStockController@scan_code')->name('tranfer-stock-scan-code');
    });

    Route::get('get-account-code', 'Accounting\AccountChartController@get_account_code')->name('get-account-code');
    Route::group(['middleware' => 'Administrator', ['auth'], 'namespace' => 'Accounting'], function () {
//=============================== Accounting ============================================

        Route::GET('/account-type', 'AccountTypeController@account_type')->name('account.type');
        Route::resource('/account-chart', 'AccountChartController');

        Route::POST('account-chart/delete', 'AccountChartController@confirm_delete')->name('account-chart.delete');
        Route::GET('/datatable_get_account_chart', 'AccountChartController@datatable_get_account_chart')->name('datatable.datatable_get_account_chart');


        route::resource('accounting-dashboard', 'AccountingDashboardController');
        Route::resource('journal', 'JournalController');
        Route::match(['get', 'post'], '/get-journal', 'JournalController@get_journal')->name('datatable.get-journal');
        Route::POST('search/account-code', 'JournalController@query_account_code')->name('search-account-code');
        Route::GET('/journal-confirm-delete/{journal_tran_id}', 'JournalController@journal_confirm_delete')->name('journal_confirm_delete');
        Route::GET('/print/voucher', 'JournalController@print_voucher')->name('voucher.print');


        //*********************************** Ledger *******************************************//
        //*************************************************************************************//
        Route::get('ledger', 'AccountingReportsController@ledger')->name('accounting-report.ledger');
        //*********************************** Income Statement *******************************************//
        //*************************************************************************************************************//

        Route::get('income-statement', 'AccountingReportsController@income_statement')->name('accounting-report.income-statement');
        Route::match(['get', 'post'], '/accounting-report/get-income-statement', 'AccountingReportsController@get_income_statement')->name('accounting-report.get-income-statement');

        //*********************************** accounting-report.get-trail-balanceTrial Balance *******************************************//
        //*************************************************************************************//
        Route::get('trail-balance', 'AccountingReportsController@trial_balance')->name('accounting-report.trail-balance');

        //*********************************** Balance Sheet *******************************************//
        //********************************************************************************************//
        Route::get('balance-sheet', 'AccountingReportsController@balance_sheet')->name('accounting-report.balance-sheet');

        //  Run Audit
        Route::get('/accounting-run-audit', 'AccountingReportsController@run_trial_balance')->name('run_trial_balance');
    });

//===============================Transfer Stock============================================

    Route::resource('transfer-stock', 'Administrator\TransferStockController');
    Route::GET('transfer-stock-scan-code', 'Administrator\TransferStockController@transfer_stock_scan_code')->name('transfer-stock-scan-code');
    Route::get('transfer-stock-confirm/{status}', 'Administrator\TransferStockController@transfer_stock_confirm')->name('transfer-stock-confirm');

//===============================Public Route============================================

    Route::group(['middleware' => 'pos', ['auth'], 'namespace' => 'CRM'], function () {
        Route::resource('lead', 'LeadController');
        Route::resource('task', 'CRMTaskController');
        Route::patch('lead-close-deal/{id?}', 'LeadController@closeDeal')->name('lead.close_deal');
        Route::patch('task-complete/{id?}', 'CRMTaskController@complete')->name('task.complete');
        Route::resource('lead-source', 'LeadSourceController');
        Route::get('lead-report', 'LeadController@report');
        Route::get('prospect-report', 'LeadController@reportProspect');
        Route::get('upcoming-task', 'LeadController@upcoming_task')->name('upcoming-task');
        Route::get('abandon-prospect', 'LeadController@abandon_prospect')->name('abandon-prospect');
        Route::get('get-prospects', 'LeadController@get_prospects')->name('get-prospects');
        Route::get('lead-destroy/{id}', 'LeadController@destroy')->name('lead.destroy');
    });
    Route::get('select2-search-account-chart', 'Accounting\AccountChartController@search_acc_chart')->name('select2-search-account-chart');
    Route::get('select2-search-customer', 'Administrator\CustomerController@search_customer')->name('select2-search-customer');
    Route::get('select2-search-lead', 'CRM\LeadController@search_lead')->name('select2-search-lead');
    Route::get('get-item-code-and-shelf-by-product-id', 'Administrator\Item\ProductController@get_item_code_shelf')->name('get-item-code-and-shelf-by-product-id');
    Route::get('select2-search-product', 'Administrator\Item\ProductController@search_product')->name('select2-search-product');
    Route::get('select2-search-member', 'Administrator\UserController@search_member')->name('select2-search-member');


    Route::get('get-location-data', 'Administrator\UserController@getLocation')->name('get-location-data');

    Route::get('clear-table', function () {
        SaleModel::query()->delete();
        SaleDetailsModel::query()->delete();
        PaymentModel::query()->delete();
        PaymentDetailModel::query()->delete();
        PurchaseModel::query()->delete();
        PurchaseDetailsModel::query()->delete();
        StockModel::query()->delete();
        return 'Oh My ជីជ្រក់';
    });

