@extends(branchMenu())
@section('content')
    <?php Fun::lang()?>
    <div class="row">
        <div class="col-xs-12">
            <div class="box">
                <div class="box-header">
                    <div class="row">
                        <div class="col-sm-12 col-xs-12">
                            <div class="title-add">
                                <div class="pull-left">
                                    <h3>{{__('administrator.reason')}}</h3>
                                </div>
                                <div class="pull-right">
                                    @can('Reason Create')
                                            <a class="btn btn-sm btn-primary button_primary create_reason"><span class="fa fa-plus"></span> {{__('administrator.new_record')}}</a>
                                    @endcan
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="box-body">
                    <form class="form_data">
                        <table id="data_table" class="table table-bordered table-striped dataTable">
                            <thead>
                            <tr>
                                <th>N°</th>
                                <th>{{__('administrator.reason')}}</th>
                                <th>{{__('administrator.action')}}</th>
                            </tr>
                            </thead>
                            <tbody>
                                @foreach($reason as $key=> $row)
                                    <tr>
                                        <td>{{$key+1}}</td>
                                        <td>{{$row->reason}}</td>
                                        <td>
                                            <button data-href="{{route('reason.edit',$row->id)}}" type="button" class="btn btn-warning fa fa-edit btn_edit"></button>
                                            <button type="button" class="btn btn-danger fa fa-trash btn_delete" data-href ="{{route('reason-delete',$row->id)}}"></button></td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script type="text/javascript">
        $(document).ready(function () {
            $('#data_table').dataTable();
        });

        $(document).on('click', '.create_reason', function () {
            getHtmlForm('{{route('reason.create')}}', '{{__('administrator.create')}} {{__('administrator.reason')}}');
        });
        $(document).on('click', '.btn_edit', function () {
            $href = $(this).data('href');
            getHtmlForm($href, '{{__('administrator.edit')}} {{__('administrator.reason')}}');
        });
        $(document).on('click', '.btn_delete', function () {
            $href = $(this).data('href');
            let text = $(this).closest('tr').find('td:nth-child(2)').text();
            confirmForm($href,  '<?php echo e(__('administrator.are_you_sure')); ?>',  'Name: '+text,  'danger', '400px', 'fa fa-trash', 'red')
        });

    </script>
@endsection
