@extends(branchMenu())
@section('content')

    <?php Fun::lang()?>
    <div class="row">
        <div class="col-xs-12">
            <div class="box">
                <div class="box-header">
                    <div class="row">
                        <div class="col-sm-12 col-xs-12">
                            <div class="title-add">
                                <div class="pull-left " >
                                    <h3 class="set_menu_name">{{__('administrator.sale_history')}}</h3>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="top-content">
                    <div class="row">
                        <div class="col-sm-12 col-xs-12">
                            <form class="form_data">
                                <div class="col-sm-4 col-md-4 ">
                                    <div class="col-sm-4 col-md-4">
                                        {{__('administrator.reference_invoice')}} :
                                    </div>
                                    <div class="form-group col-sm-8 col-md-8">
                                        {!! Form::text('reference_invoice',null, ['placeholder'=>__('administrator.reference_invoice'),'class' => 'form-control ']) !!}
                                    </div>
                                </div>
                                <div class="col-sm-4 col-md-4 ">
                                    <div class="col-sm-4 col-md-4">
                                        {{__('administrator.sale_by')}} :
                                    </div>
                                    <div class="form-group col-sm-8 col-md-8">
                                        {!! Form::select('user_id',getUsers(),null, ['placeholder'=>__('administrator.please_select'),'class' => 'form-control select2 ']) !!}
                                    </div>
                                </div>
                                <div class="col-sm-4 col-md-4 ">
                                    <div class="col-sm-4 col-md-4">
                                        {{__('administrator.payment_methods')}} :
                                    </div>
                                    <div class="form-group col-sm-8 col-md-8">
                                        {!! Form::select('payment_type',getPaymentType(),null, ['placeholder'=>__('administrator.please_select'),'class' => 'form-control select2 ']) !!}
                                    </div>
                                </div>
                                <div class="col-sm-4 col-md-4">
                                    <div class="col-sm-4 col-md-4">
                                        {{__('administrator.from_date')}} :
                                    </div>
                                    <div class="form-group col-sm-8 col-md-8">
                                        {!! Form::text('from_date',null, ['placeholder'=>__('administrator.from_date'),'class' => 'form-control date_picker']) !!}
                                    </div>
                                </div>
                                <div class="col-sm-4 col-md-4">
                                    <div class="col-sm-4 col-md-4">
                                        {{__('administrator.to_date')}} :
                                    </div>
                                    <div class="form-group col-sm-8 col-md-8">
                                        {!! Form::text('to_date',null, ['placeholder'=>__('administrator.to_date'),'class' => 'form-control date_picker']) !!}
                                    </div>
                                </div>
                                <div class="col-sm-4 col-md-4 ">
                                    <div class="col-sm-4 col-md-4">
                                        {{__('administrator.payment_status')}} :
                                    </div>
                                    <div class="form-group col-sm-8 col-md-8">
                                        {!! Form::select('payment_status',getPaymentStatus(),null, ['placeholder'=>__('administrator.please_select'),'class' => 'form-control select2 ']) !!}
                                    </div>
                                </div>
                                <div class="col-sm-12 col-md-12 form-group text-right">
                                    <button class="btn btn-md btn-warning btn-clear"
                                            type="button">{{ __('administrator.clear') }}</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="box-body table-responsive">
                    <table id="data_table" width="100%" class="table table-bordered table-striped dataTable">
                        <thead>
                        <tr>
                            <th>N°</th>
                            <th>{{__('administrator.date')}}</th>
                            <th>{{__('administrator.reference_number')}}</th>
                            <th>{{__('administrator.sale_by')}}</th>
                            <th>{{__('administrator.member')}}</th>
                            <th>{{__('administrator.grand_total')}}</th>
                            <th>{{__('administrator.paid')}}</th>
                            <th>{{__('administrator.remain_amount')}}</th>
                            <th>{{__('administrator.payment_method')}}</th>
                            <th>{{__('administrator.payment_status')}}</th>
                            <th>{{__('administrator.action')}}</th>
                        </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script type="text/javascript">
        //  start datatable
        var record = 20;
        var page = 1;
        let table_ = $('#data_table');
        let form_data = $('.form_data');
        $(document).ready(function () {
            dataTable();
            let menu_name = $('.treeview-menu').find('li.active a').text();
        });
        form_data.on('change', 'input,select', function () {
            page = 1;
            dataTable();
        });
        $(document).on('click', '.page-item', function () {
            page = $('.page-item.active .page-link').text();
            dataTable();
        });
        form_data.on('click', '.btn-clear', function () {
            form_data.find('input,select').val('').change();
            dataTable();
        });


        $(document).on('click', '.showDetail', function () {
            getHtmlFormShow($(this).data('href'), '700px');
        });

        $(document).on('click', '.btn_delete', function () {
            let inv = $(this).closest('tr').find('td:nth-child(3)').text();
            let customer = $(this).closest('tr').find('td:nth-child(5)').text();
            confirmForm($(this).data('href'), '{{__('administrator.are_you_sure')}}', `<b>{{__('administrator.invoice_number')}}</b> : ${inv}<br><b>{{__('administrator.customer_name')}}</b> : ${customer}`, 'danger', '500px', 'fa fa-trash', 'red');
        });

        function dataTable() {
            table_.DataTable().destroy();
            table_.DataTable({
                "oLanguage": {
                    "sSearch": "{{__('administrator.search')}}:",
                    "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
                    "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
                    "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
                    "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
                    "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
                    "oPaginate": {
                        "sFirst": "{{__('administrator.first')}}",
                        "sLast": "{{__('administrator.last')}}",
                        "sNext": "{{__('administrator.next')}}",
                        "sPrevious": "{{__('administrator.previous')}}"
                    },
                },
                serverSide: true,
                ordering: false,
                searching: false,
                pageLength: record,
                lengthMenu: tbLength,
                ajax: {
                    url: "{{ route('wholesale.datatables') }}?"+form_data.serialize(),
                    data:{
                        'pos_history':1,
                    }
                },
                columns:
                    [
                        {data: 'DT_RowIndex'},
                        {data: 'sale_date'},
                        {data: 'reference_number'},
                        {data: 'seller'},
                        {data: 'member'},
                        {data: 'grand_total'},
                        {data: 'paid_amount_usd'},
                        {data: 'remain'},
                        {data: 'payment_method'},
                        {data: 'payment_status'},
                        {data: 'action'},
                    ],
                "initComplete": function (settings, json) {
                        // $('select[name
                },
                "createdRow": function (row, data, dataIndex) {
                    if (data.delete_at) {
                        $(row).addClass('text-danger');
                    }
                },
            });
        }
        // end
    </script>
@endsection
