<!doctype html>
<?php Fun::lang()?>
<html>
<head>
    <meta charset="utf-8">
    <title>NSO POS</title>
    <link rel="stylesheet" type="text/css" href="{{asset('assets/css/pos-invoice.css')}}">
    <?php
    $hr = '<div style="width: 100%;border-top: 1px dashed rgba(1,1,1,0.5);margin: 10px 0;"></div>';
    ?>
    <style>
        .inv-tfoot{
            text-align: right;
            font-size: 13px;
        }
    </style>
</head>
<body>
<?php
$warehouse = findWarehouse($master->warehouse_id);
$customer = findCustomer($master->customer_id);
$branch = \App\Model\Hr\HrBranch::where('main',1)->first();

$sale = \App\Model\SaleModel::where('request_id',$master->id)->first();

$customer_phone = $customer ? $customer->customer_phone : '';
$customer_name = $customer ? $customer->customer_name : '';
$customer_address = $customer ? $customer->customer_address : '';

$seller = findUser($master->request_by);
$warehouse = $warehouse ? $warehouse->warehouse_name : '';
$seller = $seller ? $seller->name : '';
$status = $master->status;
$payment_status = $master->payment_status;
$grand_total = 0;
?>
<div class="print_this_form" style="font-size: 12px">
    <table class="table-borderless" width="100%">
        <thead>
        <tr>
            <td class="text-center">
                <br>
                <label>បង្កាន់ដៃ / Receipt</label>
            </td>
        </tr>
        </thead>
    </table>
    <hr>
    <table class="table-borderless">
        <thead>
        <tr>
            <td class="text-left">កាលបរិច្ឆេទ</td>
            <td class="text-left">: {{date('d-m-Y h:i',strtotime($master->purchase_date))}}</td>
        </tr>
        <tr>
            <td class="text-left">លេខ​វិ​ក័​យ​ប័ត្រ</td>
            <td class="text-left">: {{$master->invoice_number}}</td>
        </tr>
        <tr>
            <td class="text-left">ស្នើទៅទីតាំំង</td>
            <td class="text-left">: {{$warehouse}}</td>
        </tr>
        <tr>
            <td class="text-left">អតិថិជន</td>
            <td class="text-left">: {{$customer_name}}</td>
        </tr>
        <tr>
            <td class="text-left">ទូរស័ព្ទ</td>
            <td class="text-left">: {{$customer_phone}}</td>
        </tr>
        <tr>
            <td class="text-left">ទីតាំង</td>
            <td class="text-left"><p>: {{$customer_address}}</p></td>
        </tr>
        <tr>
            <td class="text-left">ស្ថានភាពដំណើរការ</td>
            <td class="text-left">:
                <b>{{$status=== 3 ? 'លុបចោល' : ($status === 1 ? 'ជោគជ័យ' : ($status === 0 ? 'រងចាំ': 'បរាជ័យ'))}} </b>
            </td>
        </tr>
        <tr>
            <td class="text-left">ស្ថានភាពទូទាត់</td>
            <td class="text-left">
                : {!! getPaymentStatus($master->payment_status,1) !!}
            </td>
        </tr>
        <tr>
            <td class="text-left">អ្នកគិតលុយ</td>
            <td class="text-left">: {{$seller}}</td>
        </tr>
        </thead>
    </table>
    <hr>
    <table class="table-borderless" width="100%">
        <thead>
        <tr>
            <th class="text-left">ឈ្មោះ</th>
            <th class="text-left">បរិមាណ</th>
            <th>តម្លៃសរុប</th>
        </tr>
        </thead>
        <tbody>
        @foreach($detail as $key=>$row)
            @php

                $product_unit = \App\Model\ProductUnitModel::find($row->product_unit_id);
                $product = null;
                if($product_unit){
                     $product = getProductById($product_unit->product_id);
                     $product = $product?$product->item_code:'';
                }
                 $member = \App\Model\MemberModel::find($row->member_package);
                if($member){
                    $qty_text = $row->qty;
                }else{
                    $qty_text = $row->qty.' x $'.$row->sale_price;
                }

                $grand_total+=$row->total;
            @endphp
            <tr>
                <td>{{$product}}</td>
                <td>{{$qty_text}}</td>
                <td>${{$row->total}}</td>
            </tr>
        @endforeach
        @if($master->using_point)
            <?php
            $using_point = $master->using_point/2;
            $grand_total-=$using_point;
            ?>
            <tr>
                <td>ការប្រើប្រាស់ពិន្ទុ / Using Point</td>
                <td>{{$master->using_point}}</td>
                <td>-0.5$</td>
                <td>-{{$using_point}}$</td>
            </tr>
        @endif
        <?php
            $delivery_fee = $master->delivery_en+($master->delivery_kh?$master->delivery_kh/ currencyExchange():0);
            $grand_total+=$delivery_fee;

            $grand_total = number_format($grand_total,2);

        ?>
        @if($delivery_fee)
            <tr>
                <td>ចំណូលការដឹក / Delivery Fee</td>
                <td>1</td>
                <td>{{($master->delivery_kh?('៛'.$master->delivery_kh):'').($master->delivery_en?('$'.$master->delivery_en):'')}}</td>
                <td>{{($master->delivery_kh?('៛'.$master->delivery_kh):'').($master->delivery_en?('$'.$master->delivery_en):'')}}</td>
            </tr>
        @endif
        </tbody>
    </table>
    <hr>
    <?php
    $point = $master->using_point / 2;
    $grand_total -= ($grand_total * $master->discount / 100);
    $g_kh = currencyExchange() * $grand_total;
    $paid = ($master->paid_amount_kh / currencyExchange()) + ($master->paid_amount_usd);
    $owe = $grand_total - $paid;
    $change = $paid - $grand_total;
    ?>
    <table class="text-right inv-tfoot">
        <thead>
        <tr>
            <td ><label>អត្រាប្តូរប្រាក់ / Exchange rate: 1ដុល្លា = {!! json_encode(currencyExchange()) !!}រៀល</label></td>
        </tr>
        <tr>
            <td >ពិន្ទុនៅសល់ / Balance Point:</td>
            <td>{{$sale->balance_point??($customer->points??0)}}</td>
        </tr>
        <tr style="color: #337ab7">
            <td >សរុបរួម / Grant Total USD:</td>
            <td>${{$grand_total}}</td>
        </tr>
        <tr style="color: #337ab7">
            <td >សរុបរួម / Grant Total KH: </td>
            <td>៛{{number_format($g_kh,2)}}</td>
        </tr>
        @if($master->paid_amount_usd)
            <tr style="color: darkgreen">
                <td >ប្រាក់បានបង់ / Paid USD:</td>
                   <td> ${{number_format($master->paid_amount_usd,2)}}</td>
            </tr>
        @endif
        @if($master->paid_amount_kh)
            <tr style="color: darkgreen">
                <td >ប្រាក់បានបង់ / Paid KH:</td>
                 <td> ៛{{number_format($master->paid_amount_kh,2)}}</td>
            </tr>
        @endif
        @if($change>0)
            <tr style="color: #a94442;">
                <td >លុយអាប់សរុប / Change Amount USD: </td><td>{{number_format($change,2)}}</td>
            </tr>
            <tr style="color: #a94442;">
                <td >លុយអាប់សរុប / Change Amount KH: </td><td>{{number_format($change*currencyExchange(),2)}}</td>
            </tr>
        @endif
        @if($owe>0)
            <tr style="color: #a94442;">
                <td >លុយជំពាក់ / Remain Amount USD: </td><td>{{number_format($owe,2)}}</td>
            </tr>
            <tr style="color: #a94442;">
                <td >លុយជំពាក់ / Remain Amount KH: </td><td>{{number_format($owe*currencyExchange(),2)}}</td>
            </tr>
        @endif
        </thead>
    </table>
    <table class="table-borderless" width="100%" style="margin-top: 70px;">
        <thead>
        <tr>
            <td class="text-center" >
                <label>{!! $branch->quote??'' !!}</label>
            </td>
        </tr>
        </thead>
    </table>
</div>
<script>

</script>
</body>
</html>
