<header class="main-header">
    <a href="{{ url('app-dashboard') }}" class="logo hidden-xs">
        <span class="logo-mini"><b>TL</b></span>
        <span class="logo-lg">
        @php $branch = mainBranch(); @endphp
            @if(Auth::user()->user_type!=='member')
                @if($branch->logo)
                    <img src="{{findImg($branch->logo)}}" alt="">
                @else
                    <b>{{$branch->name}}</b>
                @endif
            @else
                <b>{{Auth::user()->member_type->name??''}}</b>
            @endif
    </span>
    </a>
    <nav class="navbar navbar-static-top">
        <a href="#" class="sidebar-toggle" data-toggle="push-menu" role="button">
            <span class="sr-only">Toggle navigation</span>
        </a>
        <div class="navbar-custom-menu">
            <ul class="nav navbar-nav">
                <li class="dropdown messages-menu" style="display: none">
                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" aria-expanded="true">
                        <i class="fa fa-bell-o"></i>
                        <span class="label label-success">{{ $alert_cust_case_count }}</span>
                    </a>
                    <ul class="dropdown-menu">
                        <li>
                            <ul class="menu">
                                @foreach($alert_cust_case as $key => $value)
                                    <li>
                                        <a href="{{ url('customer-care-view/'.$value->id) }}">
                                            <div class="pull-left">
                                                <i class="fa fa-users text-aqua"></i>
                                            </div>
                                            <h4>
                                                {{ $value->customer_name }}
                                                <small><i
                                                        class="fa fa-clock-o"></i> {{  date('d-m-Y', strtotime($value->next_meeting ))}}
                                                </small>
                                            </h4>
                                            <p>{{  str_limit($value->note_next_meeting,45) }}</p>
                                        </a>
                                    </li>
                                @endforeach
                            </ul>
                        </li>
                        <li class="footer"><a href="#">See All Messages</a></li>
                    </ul>
                </li>

                <li class="pt_lang fmgp42">
                    @if(Fun::lang() == "en")
                        <a href="{{ route('km') }}">
                            <img id="FlagKhmer" src='{{ asset("images/en.png") }}' title='Khmer'/>
                        </a>
                    @elseif(Fun::lang() == "km")
                        <a href="{{ route('en') }}">
                            <img id="FlagEnglish" src='{{ asset("images/kh.png") }}' title='English'/>
                        </a>
                    @endif
                </li>

                <li class="dropdown user user-menu">
                    <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                        {{-- <img src="{{ asset('adminlte/dist/img/user2-160x160.jpg') }}" class="user-image" alt="User Image"> --}}
                        <span>{{ Auth::user()->name }}</span>
                    </a>
                    <ul class="dropdown-menu">

                        <li class="user-header">
                            <img
                                src="{{ findImg($branch->logo) }}"
                                class="img-circle" alt="User Image">
                            <p> {{ Auth::user()->name }}
                            </p>
                        </li>
                        <li class="user-footer">
                            <div class="pull-left">
                                <a href="{{ route('users.edit',Auth::id()) }}?lo=opexicvg" class="btn btn-default btn-flat">Profile</a>
                            </div>
                            <div class="pull-right">
                                <form id="logout-form" action="{{ route('logout') }}" method="POST"
                                      style="display: none;">
                                    {{ csrf_field() }}
                                </form>
                                <a href="javsript:;" class="btn btn-default btn-flat signOut">Sign out</a>
                            </div>
                        </li>
                    </ul>
                </li>
            </ul>
        </div>
    </nav>
</header>
