@extends(branchMenu())
@section('content')
    <?php Fun::lang();


    ?>

    <style>
    </style>
    <div class="row">
        <div class="col-xs-12">
            <div class="box">
                <div class="box-header">
                    <div class="row">
                        <div class="col-sm-12 col-xs-12 col-md-12">
                            <div class="title-add">
                                <div class="pull-left">
                                    <h3>{{__('administrator.upcoming_task')}}</h3>
                                </div>
                            </div>
                        </div>
                        <form class="form_data">
                            <div class="col-sm-12 col-xs-12 col-md-12">
                                <div class="form-group col-sm-3 col-xs-3 ">
                                    <div class="col-sm-4 col-xs-12 ">
                                        <label class="" for="name">{{__('administrator.lead_name')}} </label>
                                    </div>
                                    <div class="col-sm-8">
                                        {!! Form::select('lead_id',[], null, ['placeholder'=>__('administrator.please_select'),'class' => 'form-control search_lead']) !!}
                                    </div>
                                </div>
                                <div class="form-group col-sm-3 col-xs-3 ">
                                    <div class="col-sm-4 col-xs-12 ">
                                        <label class="" for="name">{{__('administrator.task_type')}} </label>
                                    </div>
                                    <div class="col-sm-8">
                                        {!! Form::select('task_type',getTaskType(), null, ['placeholder'=>__('administrator.please_select'),'class' => 'form-control select2']) !!}
                                    </div>
                                </div>
                                <div class="form-group col-sm-3 col-xs-3 ">
                                    <div class="col-sm-4 col-xs-12 ">
                                        <label class="" for="name">{{__('administrator.from_date')}} </label>
                                    </div>
                                    <div class="col-sm-8">
                                        {!! Form::text('from_date', null, ['placeholder'=>__('administrator.date'),'class' => 'form-control date_picker','autocomplete'=>'off']) !!}
                                    </div>
                                </div>
                                <div class="form-group col-sm-3 col-xs-3 ">
                                    <div class="col-sm-4 col-xs-12 ">
                                        <label class="" for="name">{{__('administrator.to_date')}} </label>
                                    </div>
                                    <div class="col-sm-8">
                                        {!! Form::text('to_date', null, ['placeholder'=>__('administrator.date'),'class' => 'form-control date_picker','autocomplete'=>'off']) !!}
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="box-body table-responsive">
                    <table id="data_table" class="table table-bordered table-striped dataTable">
                        <thead>
                        <tr>
                            <th>N°</th>
                            <th>{{ __('administrator.date') }}</th>
                            <th>{{__('administrator.agent')}}</th>
                            <th>{{ __('administrator.lead') }}</th>
                            <th>{{ __('administrator.contact') }}</th>
                            <th>{{ __('administrator.subject') }}</th>
                            <th>{{ __('administrator.task_type') }}</th>
                            <th>{{ __('administrator.place') }}</th>
                            <th>{{ __('administrator.note') }}</th>
                            <th>{{ __('administrator.action') }}</th>
                        </tr>

                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script type="text/javascript">
        //  start datatable
        $(document).ready(function () {
            dataTable();
            $('.form_data').on('change', 'select,input', function () {
                dataTable();

            });
        });

        function dataTable() {
            let data = $('.form_data').serialize();

            $('#data_table').DataTable().destroy();
            $('#data_table').DataTable({
                serverSide: true,
                ordering: false,
                searching: false,
                autoWidth: false,
                lengthMenu: tbLength,
                ajax: {
                    url: "{{ route('upcoming-task') }}?" + data,
                },
                columns:
                    [
                        {data: 'DT_RowIndex'},
                        {data: 'date'},
                        {data: 'agent_id'},
                        {data: 'name'},
                        {data: 'contact'},
                        {data: 'subject'},
                        {data: 'task_type'},
                        {data: 'where'},
                        {data: 'note'},
                        {data: 'action'},
                    ],
                "initComplete": function (settings, json) {

                }

            });
        }

        // end

    </script>
@endsection
