@extends(branchMenu())
@section('content')
<?php Fun::lang()?>
<style>
    .padding-5{
        padding: 5px !important;
    }
    .fa-pencil{
        cursor: pointer !important;
    }
    .jconfirm .jconfirm-box div.jconfirm-content-pane .jconfirm-content{
        overflow: hidden;
    }
    .ui-timepicker-container{
        z-index: 99999999 !important;
    }
</style>
<div class="row">
    <div class="col-xs-12">
        <div class="box">
            <div class="box-header">
                <div class="row">
                <div class="col-sm-12 col-xs-12">
                    <div class="title-add">
                        <div class="pull-left">
                            <h3>{{__('administrator.lead_source')}}</h3>
                        </div>
                        <div class="pull-right">
                                <a class="btn bg-olive btn-flat margin"><span class="fa fa-plus"></span> {{__('administrator.new_record')}}</a>

                        </div>
                    </div>
                </div>
            </div>
            </div>
            <div class="box-body">
                <table id="data_table" width="100%" class="table table-bordered table-striped dataTable">
                <thead>
                    <tr>
                        <th width="5%">N°</th>
                        <th>{{__('administrator.type')}}</th>
                        <th>{{__('administrator.lead_source')}}</th>
                        <th>{{__('administrator.note')}}</th>
                        <th width="15%">{{ __('administrator.action') }}</th>
                    </tr>

                </thead>
                <tbody>

                </tbody>

            </table>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
<script type="text/javascript">
//  start datatable
    var record = 20;
    var page = 1;
    $(document).ready(function() {
       getTable();
    });


    $(document).on('click', '.page-item', function() {
        page = $('.page-item.active .page-link').text();

       getTable();

    });

    function getTable() {
        $('#data_table').DataTable().destroy();
        $('#data_table').DataTable({
            "oLanguage": {
                "sSearch": "{{__('administrator.search')}}:",
                "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
                "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
                "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
                "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
                "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
                "oPaginate": {
                    "sFirst": "{{__('administrator.first')}}",
                    "sLast": "{{__('administrator.last')}}",
                    "sNext": "{{__('administrator.next')}}",
                    "sPrevious": "{{__('administrator.previous')}}"
                },
            },
            serverSide: true,
            ordering: false,
            searching: false,
            pageLength: record,
            lengthMenu: tbLength,
            ajax: {
                url:"{{ route('lead-source.index') }}",
                data:{
                    record,
                    page
                }
            },
            columns:
                [
                    {data: 'DT_RowIndex'},
                    {data: 'type'},
                    {data: 'source_name'},
                    {data: 'note'},
                    {data: 'action'},
                ],
            "initComplete": function (settings, json) {
                $('select[name="data_table_length"]').val(json.records);
                $('.dataTables_paginate').empty();
                $('#data_table_paginate').twbsPagination('destroy');
                $('#data_table_paginate').twbsPagination({
                    totalPages: json.totalPage,
                    visiblePages: 5,
                    startPage: parseInt(json.activePage),
                    next: 'Next',
                    prev: 'Prev',
                    onPageClick: function (event, pageD) {
                    }
                });
            }
        });
    }
// end

// create lead source
$('.btn.bg-olive.btn-flat').on('click', function () {
    getHtmlForm('{{route('lead-source.create')}}', '{{__('administrator.create').' '.__('administrator.lead_source')}}');
});
// end

// edit lead source
$('#data_table').on('click','.fa.fa-pencil.btn.btn-sm.btn-warning',function () {
    getHtmlForm($(this).data('href'), '{{__('administrator.edit').' '.__('administrator.lead_source')}}');
});

// delete Lead source
    $(document).on('click', '.fa.fa-trash.btn.btn-sm.btn-danger', function(){
        var url = $(this).data('url');
        $.confirm({
            icon: 'flaticon-danger',
            title: '{{__('administrator.confirm')}}!',
            content:  '{{__('administrator.are_you_sure')}}!',
            type: 'red',
            typeAnimated: true,
            closeIcon: true,
            closeIconClass: 'flaticon-close',
            buttons: {
                '{{__('administrator.confirm')}}': {
                    btnClass: 'btn-red',
                    action: function () {
                        $.ajax({
                            type: 'DELETE',
                            url: url,
                            data:{
                                '_token': '{{ csrf_token() }}'
                            },
                            dataType:'json',
                            success:function(data){
                                if(data[1] == 401){
                                    showWarningToast(data[0]);
                                }else{
                                    showSuccessToast('Lead Source deleted successfully!');
                                    $('.jconfirm-buttons .btn-default').trigger('click');
                                    $('#data_table').DataTable().destroy();
                                   getTable();
                                }
                            }
                        });
                        return false;
                    }
                },
                {{__('administrator.cancel')}}: {
                    action: function () {
                    }
                }
            }
        });
    });
// end
</script>
@endsection
