@if(Auth::user()->user_type==1)
    @extends(branchMenu())
@endif
@section('content')
    <?php Fun::lang()?>

    <div class="page box box-primary">
        <div class=container-fluid>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <div class="title-add">
                            <div class="pull-left">
                                <h3>{{__('administrator.type_of_illness')}}</h3>
                            </div>
                            <div class="pull-right">
                                {{-- <a href="{{route('customers.create')}}" class=" button_info"><span class="fa fa-plus"></span> {{__('administrator.new_customer')}}</a> --}}
                                <a class="btn bg-olive btn-flat margin btn-create"><span
                                        class="fa fa-plus"></span> {{__('administrator.new_record')}}</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="wrapper-table table-responsive">
                <table id="data_table" class="table table-striped table-hover customize">
                    <thead>
                    <tr>
                        <th>{{ __('administrator.no') }}</th>
                        <th>{{__('administrator.name_km')}}</th>
                        <th>{{__('administrator.name_en')}}</th>
                        <th>{{__('administrator.description')}}</th>
                        <th>{{__('administrator.action')}}</th>
                    </tr>
                    <tr>
                        <td></td>
                        <td>
                            <input type="text" name="s_en_name" class="form-control searchable"
                                   placeholder="{{__('administrator.searching')}} {{__('administrator.en_name')}}"
                                   autocomplete="off">
                        </td>
                        <td>
                            <input type="text" name="s_km_name" class="form-control searchable"
                                   placeholder="{{__('administrator.searching')}} {{__('administrator.khmer_name')}}"
                                   autocomplete="off">
                        </td>
                        <td>
                            <input type="text" name="s_description" class="form-control searchable"
                                   placeholder="{{__('administrator.description')}} {{__('administrator.description')}} "
                                   autocomplete="off">
                        </td>
                        <td>
                        </td>
                    </tr>
                    </thead>
                    <tbody>

                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection


@section('script')
    <script>
        let record = 20;
        let page = 1;
        getTable();

        $(document).on('change', '.searchable', function () {
            page = 1;
            record = 20;
            $('#data_table').DataTable().destroy();
            getTable();
        })

        function getTable() {
            let name_en = $('[name="s_en_name"]').val();
            let name_km = $('[name="s_km_name"]').val();
            let description = $('[name="s_description"]').val();

            $('#data_table').DataTable({
                "oLanguage": {
                    "sSearch": "{{__('administrator.search')}}:",
                    "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
                    "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
                    "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
                    "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
                    "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
                    "oPaginate": {
                        "sFirst": "{{__('administrator.first')}}",
                        "sLast": "{{__('administrator.last')}}",
                        "sNext": "{{__('administrator.next')}}",
                        "sPrevious": "{{__('administrator.previous')}}"
                    },
                },
                serverSide: true,
                ordering: false,
                searching: false,
                pageLength: record,
                lengthMenu: tbLength,
                ajax: {
                    url: "{{ route('illness-type.index') }}",
                    data: {
                        name_en,
                        name_km,
                        description,
                        record,
                        page
                    }
                },
                columns:
                    [
                        {data: 'DT_RowIndex'},
                        {data: 'name_km'},
                        {data: 'name_en'},
                        {data: 'description'},
                        {data: 'action'},
                    ],
                "initComplete": function (settings, json) {
                    $('select[name="data_table_length"]').val(json.records);
                    $('.dataTables_paginate').empty();
                    $('#data_table_paginate').twbsPagination('destroy');
                    $('#data_table_paginate').twbsPagination({
                        totalPages: json.totalPage,
                        visiblePages: 5,
                        startPage: parseInt(json.activePage),
                        next: 'Next',
                        prev: 'Prev',
                        onPageClick: function (event, pageD) {
                        }
                    });
                    $('select[name="data_table_length"]').val(record).change();

                }
            });
        }

        // end

        $(document).on('click', '.btn-delete', function () {
            confirmForm($(this).data('href'), '{{__('administrator.are_you_sure')}}', '', 'danger', '90%', 'fa fa-trash', 'red');

        });

        $('.btn-create').on('click', function () {
            getHtmlForm('{{route('illness-type.create')}}', '{{__('administrator.create').' '.__('administrator.type_of_illness')}}');
        });
        $('#data_table').on('click', '.btn-edit', function () {
            getHtmlForm($(this).data('href'), '{{__('administrator.edit').' '.__('administrator.type_of_illness')}}');
        });
    </script>
@endsection






