@extends(branchMenu())
@section('content')
    <?php Fun::lang()?>
    <div class="page box box-primary">
        <div class="container-fluid">
            <div class="top-content box-header with-border">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        {{-- <div class="title-add"> --}}
                        <div class="pull-left">
                            <h3 class="set_menu_name"></h3>
                        </div>
                        {{-- </div> --}}
                    </div>
                </div>
            </div>
            <br>
            <div class="wrapper-table table-responsive">
                <table id="data_table" class="table table-striped table-hover table-bordered">
                        <thead>
                        <tr>
                            <th> N°</th>
                            @if (request('show'))
                                <th>{{__('administrator.member')}}</th>
                            @endif
                            <th>{{__('administrator.item_code')}}</th>
                            <th>{{__('administrator.item_name')}}</th>
                            <th>{{__('administrator.shelf')}}</th>
                            <th>{{__('administrator.stock_in')}}</th>
                            <th>{{__('administrator.stock_out')}}</th>
                            <th>{{__('administrator.balance_qty')}}</th>
                        </tr>
                        <tr>
                            <td></td>
                            @if (request('show'))
                            <td></td>
                            @endif
                            <td></td>
                            <td>{!! Form::select('product_unit_id', [] , null , ['placeholder'=>__('administrator.please_select'),'class' => 'form-control search_product']) !!}</td>
                            <td>{!! Form::select('shelf_id', $shelf , null , ['placeholder'=>__('administrator.please_select'),'class' => 'form-control select2']) !!}</td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                        </thead>
                    <tbody class="tbody">
                    </tbody>
                </table>
            </div>
        </div>
    </div>
        @endsection
        @section('script')
            <script type="text/javascript">
                let table = $('#data_table');
                $(document).ready(function () {
                    dataTable();
                });

                table.on('change', 'select,input', function () {
                    dataTable();
                });
                table.on('click', '.cursor', function () {
                    getHtmlFormShow($(this).data('href'), '50%');
                });

                function dataTable() {
                    let date = $('thead').find('input[name=date]').val();
                    let from_date = $('thead').find('input[name=from_date]').val();
                    let to_date = $('thead').find('input[name=to_date]').val();
                    let branch_id = $('thead').find('select[name=branch_id]').val();
                    let product_unit_id = $('thead').find('select[name=product_unit_id]').val();
                    let shelf_id = $('thead').find('select[name=shelf_id]').val();
                    table.DataTable().destroy();
                    let column = [
                        {data: 'DT_RowIndex'},
                        @if (request('show'))
                        {data: 'member_id'},
                        @endif
                        {data: 'item_code'},
                        {data: 'product_name'},
                        {data: 'shelf_name'},
                        {data: 'stock_in'},
                        {data: 'stock_out'},
                        {data: 'balance'},
                    ];
                    table.DataTable({
                        "oLanguage": {
                            "sSearch": "{{__('administrator.search')}}:",
                            "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
                            "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
                            "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
                            "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
                            "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
                            "oPaginate": {
                                "sFirst": "{{__('administrator.first')}}",
                                "sLast": "{{__('administrator.last')}}",
                                "sNext": "{{__('administrator.next')}}",
                                "sPrevious": "{{__('administrator.previous')}}"
                            },
                        },
                        dom: 'lBfrtip',
                        buttons: [
                            {
                                extend: 'excelHtml5',
                                autoFilter: true,
                                className: 'btn btn-info pull-right',
                                filename: menu_name,
                                title: menu_name,
                                sheetName: menu_name,
                                footer:true,
                                header: true,
                                text: 'Save as Excel',
                            },
                        ],
                        serverSide: true,
                        ordering: false,
                        searching: false,
                        lengthMenu: tbLength,
                        ajax: {
                            url: "{{ route('get-stock') }}",
                            data:{
                                from_date,
                                to_date,
                                date,
                                branch_id,
                                product_unit_id,
                                shelf_id,
                                type:'{{$type}}',
                                show:'{{request('show')}}'
                            },
                        },

                        columns: column,
                    });
                }
            </script>
@stop



