@extends(branchMenu())
@section('content')
    <?php Fun::lang()?>

    <div class="page">
        <div class=container-fluid>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <div class="title-add">
                            <div class="pull-left">
                                <h3>{{__('administrator.supplier')}}</h3>
                            </div>
                            <div class="pull-right">
                                <a class=" btn btn-primary btn_add"><span
                                        class="fa fa-plus"></span> {{__('administrator.create')}}</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="wrapper-table">
                <table id="datatable" width="100%" class="table table-striped table-hover ">
                    <thead>
                    <tr>
                        <th>#</th>
                        <th>{{__('administrator.name')}}</th>
                        <th>{{__('administrator.phone')}}</th>
                        <th>{{__('administrator.address')}}</th>
                        <th>{{__('administrator.action')}}</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($data as $key=>$value)
                        <tr>
                            <td>{{$key+1}}</td>
                            <td>{{$value->name}}</td>
                            <td>{{$value->phone}}</td>
                            <td>{{$value->address}}</td>
                            <td>
                                <a data-href="{{route('suppliers.edit',$value->id)}}"
                                   class="btn btn-warning btn_edit">{{__('administrator.edit')}}</a>
                            </td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
                <div class="text-right">
                    {{ $data->links() }}
                </div>
            </div>
        </div>
    </div>

@endsection
@section('script')
    <script type="text/javascript">
        $(document).ready(function () {
            $('#datatable').DataTable();
            $(document).on('click', '.btn_add', function () {
                getHtmlForm('{{route('suppliers.create')}}', '{{__('administrator.create')}} {{__('administrator.supplier')}}');
            });
            $(document).on('click', '.btn_edit', function () {
                getHtmlForm($(this).data('href'), '{{__('administrator.edit')}} {{__('administrator.supplier')}}');
            });
        });
    </script>
@stop



