@foreach($products as $key => $row)
    <?php
    $barcode = $row->barcode;
    $color = findColor($row->color_id);
    $size = findSize($row->size_id);
    $product = getProductById($row->product_id);
    ?>
    <div class="col-sm-3 col-xs-6 paddin-5"  title="{{$row->product_name}} (Size:{{$size?$size->size:''}})">
        <div class="item-show">
            <a class="add-product cursor"
               data-name="{{  $row->product_name}}"
               data-code="{{  $barcode }}"
               data-price="{{  $row->cost}}"
               data-currency="{{  $row->currency}}"
               data-symbol="{{  findCurrency($row->currency)->symbol}}"
               data-size="{{  $size?$size->size:''}}"
               data-unit="{{  findUnit($row->unit_id)->unit}}"
               data-id="{{ $row->id }}">
                <img src="{{findImg($product)}}">
                <span class="item-show-name">
                   {{$barcode}} <br>{{ str_limit($row->product_name,15) }}
                </span>
            </a>
        </div>
    </div>
@endforeach
<div class="col-sm-12 col-xs-12">
    <div class="pagin">
        {!! $products->render() !!}
    </div>
</div>
