    @extends(branchMenu())
@section('content')
<style>
    .table-borderless .text-center,  .table-borderless .text-left, .table-borderless .text-right{
        padding: 4px !important;
    }
    hr{
        margin-top: 3px;
        margin-bottom: 9px;
        border: 0;
        border-top: 1px dashed #bbb4b46b !important;
    }
</style>
<?php Fun::lang()?>
<div class="row">
    <div class="col-xs-12">
        <div class="box">
            <div class="box-header">
                <div class="row">
                <div class="col-sm-12 col-xs-12">
                    <div class="title-add">
                        <div class="pull-left">
                            <h3>{{__('administrator.purchases')}}</h3>
                        </div>
                        <div class="pull-right">
                            @can('New Purchase')
                                <a href="{{ route('purchases-item.create') }}" class="btn bg-olive btn-flat margin"><span class="fa fa-plus"></span> {{__('administrator.new_record')}}</a>
                            @endcan
                        </div>
                    </div>
                </div>
            </div>
            </div>
            <div class="box-body table-responsive">
                <table id="data_table" class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>N°</th>
                        <th>{{__('administrator.invoice_number')}}</th>
                        <th>{{__('administrator.purchase_date')}}</th>
                        <th>{{__('administrator.total')}}</th>
                        <th>{{__('administrator.paid')}}</th>
                        <th>{{__('administrator.remain_amount')}}</th>
                        <th>{{__('administrator.payment_status')}}</th>
                        <th>{{__('administrator.action')}}</th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
<script type="text/javascript">
    //  start datatable
    var record = 20;
    var page = 1;
    $(document).ready(function() {
        dataTable();
        $('#data_table').on('click','.btn_delete',function () {
        let href = $(this).data('href');
        confirmForm(href,'Are you sure?');
        });
    });
    $(document).on('click', '.page-item', function() {
        page = $('.page-item.active .page-link').text();
        dataTable();

    });

    $(document).on('click', '.fa.fa-eye', function(){
        let payment_status = $(this).data('payment_status');
        let url = $(this).data('url');
        let get_payment_url = $(this).data('payment_url');
        $.ajax({
            type: 'GET',
            url :url,
            async: false,
            success: function(data){
                $.confirm({
                    type: 'blue',
                    title: '',
                    theme: 'modern',
                    useBootstrap: false,
                    boxWidth:'800px',
                    content: data,
                    buttons: {
                        close: {
                            btnClass: 'btn-warning',
                            action: function(){
                            }
                        },
                        print: {
                            btnClass: 'btn-info',
                            action: function(){
                                let this_ = this.$content.find('.print_this_form');
                                this_.printThis({
                                    //loadCSS: "{{asset('assets/css/pos-invoice.css')}}",
                                    beforePrint: function () {
                                        $(document).find('button').hide();
                                    },
                                    afterPrint: function () {
                                        $(document).find('button').show();
                                        // window.location.reload();
                                    },
                                });
                                return false;
                            }
                        },
                        payment: {
                            isHidden: payment_status==='paid',
                            btnClass: 'btn-blue',
                            action: function(){
                                getHtmlForm(get_payment_url,'{{__('administrator.add_payment')}}','500px');
                                return false;
                            }
                        },
                    },
                });
            }
        });
    });
    function dataTable() {
        let invoice_number = $('input[name="invoice_number"]').val();
        let created_at = $('input[name="created_at"]').val();
        let total = $('input[name="total"]').val();
        let paid = $('input[name="paid"]').val();
        let remain_amount = $('input[name="remain_amount"]').val();
        let payment_status = $('select[name="payment_status"]').val();
        $('#data_table').DataTable().destroy();
        $('#data_table').DataTable({
            serverSide: true,
            ordering: false,
            searching: false,
            pageLength: record,
            lengthMenu: tbLength,
            ajax: {
                url:"{{ route('purchases-item.index') }}",
                data:{
                    invoice_number,
                    created_at,
                    total,
                    paid,
                    remain_amount,
                    payment_status,
                    record,
                    page
                }
            },
            columns:
                [
                    {data: 'DT_RowIndex'},
                    {data: 'invoice_number'},
                    {data: 'purchase_date'},
                    {data: 'total'},
                    {data: 'paid_usd'},
                    {data: 'remain_amount'},
                    {data: 'payment_status'},
                    {data: 'action'},
                ],
            "initComplete": function (settings, json) {
                $('select[name="data_table_length"]').val(json.records);
                $('.dataTables_paginate').empty();
                $('#data_table_paginate').twbsPagination('destroy');
                $('#data_table_paginate').twbsPagination({
                    totalPages: json.totalPage,
                    visiblePages: 5,
                    startPage: parseInt(json.activePage),
                    next: 'Next',
                    prev: 'Prev',
                    onPageClick: function (event, pageD) {
                    }
                });
            }
        });
    }
// end
// delete Purchase
    // $(document).on('click', '.fa.fa-trash.btn.btn-sm.btn-danger', function(){
    //     var url = $(this).data('url');
    //     $.confirm({
    //         icon: 'flaticon-danger',
    //         title: 'Confirm!',
    //         content: 'Are you sure to delete this item?',
    //         type: 'red',
    //         typeAnimated: true,
    //         closeIcon: true,
    //         closeIconClass: 'flaticon-close',
    //         buttons: {
    //             confirm: {
    //                 btnClass: 'btn-red',
    //                 action: function () {
    //                     $.ajax({
    //                         type: 'DELETE',
    //                         url: url,
    //                         data:{
    //                             '_token': '{{ csrf_token() }}'
    //                         },
    //                         dataType:'json',
    //                         success:function(data){
    //                             if(data[1] == 401){
    //                                 showWarningToast(data[0]);
    //                             }else{
    //                                 showSuccessToast('Purchase deleted successfully!');
    //                                 $('.jconfirm-buttons .btn-default').trigger('click');
    //                                 $('#data_table').DataTable().destroy();
    //                                 dataTable();
    //                             }
    //                         }
    //                     });
    //                     return false;
    //                 }
    //             },
    //             cancel: {
    //                 action: function () {
    //                 }
    //             }
    //         }
    //     });
    // });
// end

    function makePayment(invoice_number, amout, remain, url, id){
        $.confirm({
            title: 'Payment',
            columnClass: 'medium',
            content:`
            <form action="${url}" method="POST">
                <table class="table">
                    <tbody>
                        <tr>
                            <td style="padding-top:15px;">{{ __('administrator.invoice_number') }}</td>
                            <td>
                                <input class="form-control" name="invoice_number" value="${invoice_number}" disabled />
                            </td>
                        </tr>
                        <tr>
                            <td style="padding-top:15px;">{{ __('administrator.remain') }}</td>
                            <td>
                                <input class="form-control" name="remain" value="${remain}" disabled />
                            </td>
                        </tr>
                        <tr>
                            <td style="padding-top:15px;">{{ __('administrator.amount') }}</td>
                            <td>
                                <input class="form-control decimal" name="amount" value="" placeholder="0.00" />
                            </td>
                        </tr>
                        <tr>
                            <td style="padding-top:15px;">{{ __('administrator.payment_type') }}</td>
                            <td>
                                {!! Form::select('payment_type', getPaymentType(), '', array('placeholder' =>__('administrator.payment_type'),'class' => 'form-control input-sm', 'required', 'style' => 'width:100%')) !!}
                            </td>
                        </tr>
                        <tr>
                            <td style="padding-top:15px;">{{ __('administrator.date') }}</td>
                            <td>
                                <input type="text" class="form-control date_picker" name="date" value="" />
                            </td>
                        </tr>
                        <tr>
                            <td style="padding-top:15px;">{{ __('administrator.note') }}</td>
                            <td>
                                <textarea name="note" class="form-control" rows="3"></textarea>
                            </td>
                        </tr>
                    </tbody>
                </table>
            `,
            buttons: {
                    save: {
                        text: 'SAVE',
                        btnClass: 'btn-blue',
                        keys: ['enter', 'shift'],
                        action: function(){
                            let boolean = 1;
                            this.$content.find('input').each(function(k, ele) {
                                if ($(ele).val() === '' || $(ele).val() == 'undefined')
                                {
                                    showWarningToast('Invalid Input');
                                    boolean = 0;
                                }
                            });
                            if (boolean == 0)
                                return false;
                            let payment_type = $('[name="payment_type"]').val();
                            if (!payment_type) {
                                showWarningToast('Please select payment type');
                                return false;
                            }
                            let form = this.$content.find('form').serialize();

                            $.ajax({
                                type:'GET',
                                url: `${url}`,
                                data:{
                                    _token : "{{ csrf_token() }}",
                                    form,
                                    id
                                },
                                success:function(data){
                                   $('#data_table').DataTable().ajax.reload();
                                   $('.btn-red').trigger('click');
                                   $('.btn-closeA').trigger('click');
                                }
                            });
                            return false;
                        }
                    },
                    close:{
                        text: 'close',
                        btnClass: 'btn-red btn-closeA'
                    }
            },
            onContentReady: function () {
                // ISO date
                var isoDate = new Date().toISOString().split('T')[0];
                this.$content.find('[name="date"]').val(isoDate);

                $('select').select2();
                $(".decimal").on("input", function(evt) {
                    var self = $(this);
                    self.val(self.val().replace(/[^0-9\.]/g, ''));
                    if ((evt.which != 46 || self.val().indexOf('.') != -1) && (evt.which < 48 || evt.which > 57))
                    {
                        evt.preventDefault();
                    }
                });
            },
        });
    }

</script>
@endsection
