@extends(branchMenu())
@section('content')
<?php Fun::lang()?>
<div class="row">
    <div class="col-xs-12">
        <div class="box">
            <div class="box-body" style="overflow-x:auto;">
                <div class="col-md-12">
                    <div class="card card-custom">
                        <div class="card-header flex-wrap border-0 pt-6 pb-0">
                            <div class="card-title">
                                <h3 class="card-label">{{__('administrator.exchange_rate')}}</h3>
                            </div>
                        </div>
                        <form>
                            <div class="card-body row">
                                @foreach($setting as $id => $item)
                                    <div class="form-group col-md-3">
                                        <label>{{ $item['name']}}</label>
                                        <input type="{{ $item['type']}}" class="{{ $item['class']}}" placeholder="{{ $item['name']}}" id="{{ $id }}" maxlength="{{ $item['max-length'] }}" value ="{{ $item['value'] }}"/>
                                    </div>
                                @endforeach
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
<script type="text/javascript">
    $(document).on('blur', 'input', function(){
        var id = $(this).attr('id');
        var val = $(this).val();
        var name = $(this).attr('placeholder');
        $.ajax({
            type:'GET',
            url: '{!! url("setting-update/'+id+'") !!}',
            data:{
                '_token': '{{ csrf_token() }}',
                val,
                name
            },
            dataType: 'json',
            success: function(data){
            }
        });
    });
</script>
@endsection
