@extends(branchMenu())
@section('content')
<?php Fun::lang()?>
<style>
    .padding-5 .fa-pencil-alt{
        position: relative;
        top: 38px;
        left: 27px;
        background: white;
        border-radius: 50%;
        font-size: 20px;
        cursor: pointer;
    }
    .previewImage{
        width: 100px;
        height: 98px;
        background-repeat: no-repeat;
        background-size: 100px 100px;
        background-color: #cccccc !important;
        border-radius: 50%;
        cursor: pointer;
    }

    .padding-5{
        padding: 5px !important;
    }

    .jconfirm .jconfirm-box div.jconfirm-content-pane .jconfirm-content{
        overflow: hidden;
    }

    .ui-timepicker-container{
        z-index: 99999999 !important;
    }

    .fa-minus-circle, .fa-plus-circle{
        cursor: pointer !important;
    }
</style>
<div class="row">
    <div class="col-xs-12">
        <div class="box">
            <div class="box-header">
                <div class="row">
                <div class="col-sm-12 col-xs-12">
                    <div class="title-add">
                        <div class="pull-left">
                            <h3>{{__('administrator.promotion')}}</h3>
                        </div>
                        <div class="pull-right">
                            {{-- @can('Category Create') --}}
                                <a href="{{ route('promotion.create') }}" class="btn bg-olive btn-flat margin"><span class="fa fa-plus"></span> {{__('administrator.new_record')}}</a>
                            {{-- @endcan --}}
                        </div>
                    </div>
                </div>
            </div>
            </div>
            <div class="box-body" style="overflow-x:auto;">
                <table id="data_table" width="100%" class="table table-bordered table-striped dataTable">
                <thead>
                    <tr>
                        <th>N°</th>
                        <th width="8%">{{__('administrator.image')}}</th>
                        <th>{{__('administrator.branch')}}</th>
                        <th>{{__('administrator.code')}}</th>
                        <th>{{__('administrator.name')}}</th>
                        <th>{{__('administrator.start_date')}}</th>
                        <th>{{__('administrator.end_date')}}</th>
                        <th>{{__('administrator.type')}}</th>
                        <th>{{__('administrator.price_us')}}</th>
                        <th>{{__('administrator.price_kh')}}</th>
                        <th>{{__('administrator.note')}}</th>
                        <th>{{__('administrator.action')}}</th>
                    </tr>
                    {{-- <tr>
                        <td></td>
                        <td></td>
                        <td>
                            <input type="text" name="size" class="form-control"  placeholder="Search Size" autocomplete="off">
                        </td>
                        <td>
                            <input type="text" name="note" class="form-control"  placeholder="Search Description" autocomplete="off">
                        </td>
                        <td>
                            <input type="text" name="created_at" class="form-control"  placeholder="Search Created At" autocomplete="off" value="">
                        </td>
                        <td class="text-center">
                            <i class="fa fa-times btn btn-sm btn-default" title="Clear"></i>
                        </td>
                    </tr> --}}
                </thead>
                <tbody>

                </tbody>

            </table>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
<script type="text/javascript">
//  start datatable
    var record = 20;
    var page = 1;
    $(document).ready(function() {
        dataTable();
    });

    $(document).on('change', '.form-control.input-sm', function() {
        record = $(this).val();
        page = 1;
        $('#data_table').DataTable().destroy();
        dataTable();
    });

    // $(document).on('blur', 'input[class="form-control"]', function(){
    //     page = 1;
    //     $('#data_table').DataTable().destroy();
    //     dataTable();
    // });

    // $(document).on('blur', 'input[name="created_at"]', function(){
    //     page = 1;
    //     $('#data_table').DataTable().destroy();
    //     dataTable();
    // })

    $(document).on('click', '.fa.fa-times', function(){
        page = 1;
        $('.form-control').val(null);
        $('#data_table').DataTable().destroy();
        dataTable();
    });

    $(document).on('click', '.page-item', function() {
        page = $('.page-item.active .page-link').text();
        $('#data_table').DataTable().destroy();
        dataTable();

    });


    function dataTable() {
        var size = $('input[name="size"]').val();
        var note = $('input[name="note"]').val();
        var created_at = $('input[name="created_at"]').val();
        $('#data_table').DataTable({
            "oLanguage": {
                "sSearch": "{{__('administrator.search')}}:",
                "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
                "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
                "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
                "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
                "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
                "oPaginate": {
                    "sFirst": "{{__('administrator.first')}}",
                    "sLast": "{{__('administrator.last')}}",
                    "sNext": "{{__('administrator.next')}}",
                    "sPrevious": "{{__('administrator.previous')}}"
                },
            },
            serverSide: true,
            ordering: false,
            searching: false,
            pageLength: record,
            lengthMenu: tbLength,
            ajax: {
                url:"{{ route('promotion.index') }}",
                data:{
                    size,
                    note,
                    record,
                    created_at,
                    page
                }
            },
            columns:
                [
                    {data: 'DT_RowIndex'},
                    {data: 'image'},
                    {data: 'branch'},
                    {data: 'code'},
                    {data: 'name'},
                    {data: 'start_date'},
                    {data: 'end_date'},
                    {data: 'type'},
                    {data: 'us_price'},
                    {data: 'riel_price'},
                    {data: 'note'},
                    {data: 'action'},
                ],
            "initComplete": function (settings, json) {
                $('select[name="data_table_length"]').val(json.records);
                $('.dataTables_paginate').empty();
                $('#data_table_paginate').twbsPagination('destroy');
                $('#data_table_paginate').twbsPagination({
                    totalPages: json.totalPage,
                    visiblePages: 5,
                    startPage: parseInt(json.activePage),
                    next: 'Next',
                    prev: 'Prev',
                    onPageClick: function (event, pageD) {
                    }
                });
            }
        });
    }
// end
// delete Size
    $(document).on('click', '.fa.fa-trash.btn.btn-sm.btn-danger', function(){
        var url = $(this).data('url');
        $.confirm({
            icon: 'flaticon-danger',
            title: 'Confirm!',
            content: 'Are you sure to delete this item?',
            type: 'red',
            typeAnimated: true,
            closeIcon: true,
            closeIconClass: 'flaticon-close',
            buttons: {
                confirm: {
                    btnClass: 'btn-red',
                    action: function () {
                        $.ajax({
                            type: 'DELETE',
                            url: url,
                            data:{
                                '_token': '{{ csrf_token() }}'
                            },
                            dataType:'json',
                            success:function(data){
                                if(data[1] == 401){
                                    showWarningToast(data[0]);
                                }else{
                                    showSuccessToast('Unit deleted successfully!');
                                    $('.jconfirm-buttons .btn-default').trigger('click');
                                    $('#data_table').DataTable().destroy();
                                    dataTable();
                                }
                            }
                        });
                        return false;
                    }
                },
                cancel: {
                    action: function () {
                    }
                }
            }
        });
    });
// end
</script>
@endsection
