@extends('layouts.jform')
@section('content')
    @php
          $paid = ($payment->paid_amount?$payment->paid_amount:0);
          $remain = $payment->payment_amount-$paid;
          $currency = '$';
    @endphp
    <style>
        .table-custom td {
            padding: 5px;
            vertical-align: middle;
        }
    </style>
    <hr width="100%">
    {!! Form::model($payment, ['method' => 'PATCH','route' => ['payment.update', $payment->id],'enctype'=>'multipart/form-data','class'=>'jform']) !!}
    @csrf
    <table class="table-custom" width="100%">
        <tbody>
        <tr>
            <td style="padding-top:15px;">{{ __('administrator.invoice_number') }}</td>
            <td>
                <input class="form-control" name="invoice_number" value="{{$invoice->invoice_number}}" disabled/>
            </td>
        </tr>
        <tr>
            <td style="padding-top:15px;">{{ __('administrator.payment_date') }}</td>
            <td>
                <input type="text" class="form-control date_picker" name="date" value="{{date('d-m-Y')}}"/>
            </td>
        </tr>
        <tr>
            <td style="padding-top:15px;">{{ __('administrator.total_amount') }}</td>
            <td>
                <input class="form-control" name="remain" value="{{$currency.$payment->payment_amount}}" readonly/>
            </td>
        </tr>
        <tr>
            <td style="padding-top:15px;">{{ __('administrator.paid_amount') }}</td>
            <td>
                <input class="form-control" name="remain" value="{{$currency.$paid}}" readonly/>
            </td>
        </tr>
        <tr>
            <td style="padding-top:15px;">{{ __('administrator.remain') }}</td>
            <td>
                <input class="form-control" name="remain" value="{{$currency.$remain}}" readonly/>
                <input class="form-control" name="remain_hidden" value="{{$remain}}" type="hidden"/>
            </td>
        </tr>

        <tr>
            <td style="padding-top:15px;" >{{ __('administrator.payment_method') }}<i class="text-danger">*</i></td>
            <td>
                {!!  Form::select('payment_method', $acc_chart, null, ['class' => 'payment_method form-control select2', 'placeholder' => __('administrator.please_select')]) !!}
            </td>
        </tr>
        <tr>
            <td style="padding-top:15px;">{{ __('administrator.bank_name') }}</td>
            <td>
                {!!  Form::select('sub_payment_method', [], null, ['class' => 'payment_type form-control select2', 'placeholder' => __('administrator.please_select')]) !!}
            </td>
        </tr>
        <tr>
            <td style="padding-top:15px;">{{ __('administrator.amount') }}<i class="text-danger">*</i></td>
            <td>
                <input class="form-control number-only decimal" name="amount" value="" placeholder="0.00"/>
            </td>
        </tr>
        <tr>
            <td style="padding-top:15px;">{{ __('administrator.note') }}</td>
            <td>
                <textarea name="note" class="form-control" rows="3"></textarea>
                <input type="submit" class="submit_ hidden">
            </td>
        </tr>
        </tbody>
    </table>
    {!! Form::close() !!}
@endsection
@section('jq')
    <script>
        var spm = $('select[name=sub_payment_method]');

        $(document).on('change', 'select[name=payment_method]', function () {
            $.getJSON('{{route('get-account-code',0)}}', {main_account: $(this).val()}, function (data) {
                let html = `<option value="">{{__('administrator.please_select')}}</option>`;
                $.each(data.sub_account, function (ii, vv) {
                    html += `<option value="${ii}">${vv}</option>`;
                });
                spm.html(html);
            });
        });

        $(document).on('input', 'input[name="amount"]', function () {
            let remain = $('input[name="remain_hidden"]').val();
            remain = remain.replace("ដុល្លា", "");
            remain = remain.replace(",", "");
            let pun = ($('input[name="punishment"]').val());
            let amount = '{{$payment->payment_amount}}';
            amount = parseFloat(amount);
            let $total = (amount * pun) / 100;
            let pay = $('.decimal').val();
            if (parseFloat(pay) > parseFloat(remain+$total)) {
                $('.decimal').val(remain);
            }
        });
        $(document).on('input', 'input[name="punishment"]', function () {
            find_cash();
        });
        function find_cash() {
            let amount = '{{$payment->payment_amount}}';
            amount = parseFloat(amount);
            let pun = ($('input[name="punishment"]').val());
            pun = pun ? parseFloat(pun) : 0;
            if (pun > 100) {
                pun = 100;
                $(this).val(pun);
            }
            let $total = (amount * pun) / 100;
            $('input[name="punishment_cash"]').val('{{$currency}}'+$total);
        }
    </script>
@endsection
