@extends(branchMenu())
@section('content')
    <?php Fun::lang()?>
@php
$from_date = @$_GET['from_date'];
$to_date = @$_GET['to_date'];
$user_id = @$_GET['user_id'];
$iloveucustomer = @$_GET['iloveucustomer'];
$product_id = @$_GET['product_id'];
$sale_type = @$_GET['sale_type'];
@endphp
    <div class="page">
        <div class=container-fluid>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12 col-xs-12 form-group">
                        <div class="title-add">
                            <div class="pull-left">
                                <h3>{{__('administrator.report_sale_detail')}}</h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12 col-xs-12 form-group paddin-0">
                        <div>
                             {!! Form::open(array('route' => 'report-sale-detail','method'=>'get')) !!}
                            <div class="col-sm-3">
                                <div class="form-group">
                                    {!! Form::select('sale_type', ['wholesale'=> __('administrator.wholesale'),'retail'=> __('administrator.retail')],$sale_type, array('placeholder' => __('administrator.type'),'class' => 'form-control','autocomplete select2' => 'off','')) !!}
                                </div>
                            </div>
                            <div class="col-sm-3">
                                <div class="form-group">
                                    {!! Form::select('user_id', pluckAllUser(),$user_id, array('placeholder' => __('administrator.seller'),'class' => 'form-control','autocomplete select2' => 'off','')) !!}
                                </div>
                            </div>
                            <div class="col-sm-3">
                                <div class="form-group">
                                    {!! Form::select('iloveucustomer', pluckAllCustomer(),$iloveucustomer, array('placeholder' => __('administrator.customer'),'class' => 'form-control select2','autocomplete' => 'off','')) !!}
                                </div>
                            </div>
                            <div class="col-sm-3">
                                <div class="form-group">
                                    {!! Form::select('product_id', getAllProduct()->pluck('product_name','id'),$product_id, array('placeholder' => __('administrator.products'),'class' => 'form-control select2','autocomplete' => 'off','')) !!}
                                </div>
                            </div>
                            <div class="col-sm-3">
                                <div class="form-group">
                                    {!! Form::text('from_date', $from_date, array('placeholder' => __('administrator.from_date'),'class' => 'form-control date_picker','autocomplete' => 'off','')) !!}
                                </div>
                            </div>
                            <div class="col-sm-3">
                                <div class="form-group">
                                    {!! Form::text('to_date', $to_date, array('placeholder' => __('administrator.to_date'),'class' => 'form-control date_picker','autocomplete' => 'off','')) !!}
                                </div>
                            </div>
                            <div class=" col-sm-6">
                                {!! Form::open(array('route' => 'reportsales_print','method'=>'GET')) !!}
                                <button class=" button_success pull-right print_button" type="button" ><i class="fa fa-print "></i> {{__('administrator.print')}}</button>
                                {!! Form::close() !!}
                                <button class=" btn bg-olive btn-flat margin pull-right"   type="submit"> {{__('administrator.search')}}</button>
                            </div>
                             {!! Form::close() !!}
                        </div>
                    </div>
                </div>
            </div>
            <div class="wrapper-table">
                <table id="print_table" width="100%" class="table table-striped table-hover ">
                    <thead>
                    <tr>
                        <th>#</th>
                        <th>{{__('administrator.type')}}</th>
                        <th>{{__('administrator.sale_date')}}</th>
                        <th>{{__('administrator.invoice')}}</th>
                        <th>{{__('administrator.seller')}}</th>
                        <th>{{__('administrator.customer_name')}}</th>
                        <th>{{__('administrator.products')}}</th>
                        <th>{{__('administrator.sale_price')}}</th>
                        <th>{{__('administrator.discount')}}</th>
                        <th>{{__('administrator.sale_qty')}}</th>
                        <th>{{__('administrator.total')}}</th>
                    </tr>
                    </thead>
                    <tbody class="tbody">

                    </tbody>
                    <tfoot class="tfoot">
                    <tr>
                        <th colspan="9" class="text-right"></th>
                        <th class="text-right"></th>
                        <th class="green"></th>
                    </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
        @endsection

        @section('script')

            <script type="text/javascript">

                $(document).ready(function () {

                    $('#print_table').DataTable({
                        "oLanguage": {
                            "sSearch": "{{__('administrator.search')}}:",
                            "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
                            "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
                            "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
                            "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
                            "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
                            "oPaginate": {
                                "sFirst": "{{__('administrator.first')}}",
                                "sLast": "{{__('administrator.last')}}",
                                "sNext": "{{__('administrator.next')}}",
                                "sPrevious": "{{__('administrator.previous')}}"
                            },
                        },

                        ordering: false,
                        serverSide: true,
                        lengthMenu: tbLength,
                        ajax: "{{ route('report-sale-detail') }}?from_date={{$from_date}}&to_date={{$to_date}}&sale_type={{$sale_type}}&user_id={{$user_id}}&product_id={{$product_id}}&iloveucustomer={{$iloveucustomer}}",
                       data:{customer_name :'{{$iloveucustomer}}' },

                        columns:
                            [
                                {data: 'DT_RowIndex', 'searchable': false},
                                {data: 'sale_type', 'name': 'nso007_sales.sale_type'},
                                {data: 'sale_date', 'name': 'nso007_sales.sale_date'},
                                {data: 'invoice_number', 'name': 'nso007_sales.invoice_number'},
                                {data: 'user_id', 'searchable': false},
                                {data: 'customer_id', 'searchable': false},
                                {data: 'product_id', 'searchable': false},
                                {data: 'sale_price', 'searchable': false},
                                {data: 'dis', 'searchable': false},
                                {data: 'qty', 'searchable': false},
                                {data: 'amount', 'searchable': false},

                            ],
                        "footerCallback": function (row, data, start, end, display) {
                            var api = this.api(), data;
                            var intVal = function (i) {
                                return typeof i === 'string' ?
                                    i.replace(/[\$,]/g, '') * 1 :
                                    typeof i === 'number' ?
                                        i : 0;
                            };
                            var cost_Total = api
                                .column(6)
                                .data()
                                .reduce(function (a, b) {
                                    return intVal(a) + intVal(b);
                                }, 0);


                            var numFormat = $.fn.dataTable.render.number('\,', '.', 2, '$ ').display;
                            $(api.column(6).footer()).html(numFormat(cost_Total));
                        },
                    });

                    $.fn.dataTable.ext.errMode = 'throw';
                });
            </script>
@stop




