@extends(branchMenu())

@section('content')

<?php Fun::lang()?>

<div class="row">
    <div class="col-xs-12">
        <div class="box">
            <div class="box-header">
                <div class="row">
                <div class="col-sm-12 col-xs-12">
                    <div class="title-add">
                        <div class="pull-left">
                            <h3 class="set_menu_name"></h3>
                        </div>
                        <div class="pull-right">
                            @can('Category Create')
                                <a class="btn btn-primary getHtmlForm set_menu_name fa fa-plus" data-href="{{route('unit.create')}}" data-name="{{__('administrator.create')}}"></a>
                            @endcan
                        </div>
                    </div>
                </div>
            </div>
            </div>
            <div class="box-body">
                <table id="my-table" class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>{{__('administrator.unit')}}</th>
                        <th>{{__('administrator.note')}}</th>
                        <th>{{__('administrator.created_at')}}</th>
                        <th>{{__('administrator.action')}}</th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
<script type="text/javascript">
    let tb = $('#my-table');
    $(document).ready(function() {
        getTable();
        tb.on('click','.btn_delete',function (){
            let t = $(this);
            let name = t.closest('tr').find('td:nth-child(2)').text();
            confirmForm(t.data('href'),'<?php echo e(__('administrator.are_you_sure')); ?>', 'Unit : '+name, 'danger', '500px', 'fa fa-trash', 'red');
        });
    });
    function getTable() {
        tb.DataTable().destroy();
        tb.DataTable({
            serverSide: true,
            ordering: false,
            lengthMenu: tbLength,
            ajax: {
                url:"{{ route('unit.index') }}",
            },
            columns:
                [
                    {data: 'DT_RowIndex',searchable:false},
                    {data: 'unit'},
                    {data: 'note'},
                    {data: 'created_at'},
                    {data: 'action'},
                ],

        });

    }
</script>

@endsection







