@extends(branchMenu())
@section('content')
    <?php Fun::lang()?>
    <div class="page">
        <div class=container-fluid>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <div class="title-add">
                            <div class="pull-left">
                                <h3>{{__('administrator.discount')}}</h3>
                            </div>
                            <div class="pull-right">
                                <a href="{{route('discount.create')}}" class=" button_info"><span
                                            class="fa fa-plus"></span> {{__('administrator.create')}}</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="wrapper-table">
                <table id="data_table" width="100%" class="table table-striped table-hover ">
                    <thead>
                    <tr>
                        <th>#</th>
                        <th>{{__('administrator.name')}}</th>
                        <th>{{__('administrator.discount')}}%</th>
                        <th>{{__('administrator.note')}}</th>
                        <th>{{__('administrator.action')}}</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($discount as $key => $value)
                        <tr>
                            <td>{{$key+1}}</td>
                            <td>{{$value->name}}</td>
                            <td>{{$value->discount}}</td>
                            <td>{{$value->note }}</td>
                            <td>
                                <a href="{{route('discount.edit',$value->id)}}"
                                   class=" button_warning">{{__('administrator.edit')}}</a>
                            </td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection



@section('script')

    <script type="text/javascript">
        $('#data_table').DataTable({
            "oLanguage": {
                "sSearch": "{{__('administrator.search')}}:",
                "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
                "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
                "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
                "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
                "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
                "oPaginate": {
                    "sFirst": "{{__('administrator.first')}}",
                    "sLast": "{{__('administrator.last')}}",
                    "sNext": "{{__('administrator.next')}}",
                    "sPrevious": "{{__('administrator.previous')}}"
                },
            }
        });
    </script>
@stop

    

