@extends(branchMenu())
@section('content')
    <link rel="stylesheet" href="https://cdn3.devexpress.com/jslib/21.2.5/css/dx.common.css">
    <link rel="stylesheet" href="https://cdn3.devexpress.com/jslib/21.2.5/css/dx.light.css">
    <script type="text/javascript" src="https://cdn3.devexpress.com/jslib/21.2.5/js/dx.all.js"></script>
    <?php Fun::lang(); ?>
    <div class="row">
        <div class="col-md-6 col-sm-6 col-xs-12">
            <div class="box-body " style="background: white;">
                <div class="row">

                    <div class="col-md-3 col-sm-3 col-xs-3" style="padding-top: 12%">
                    <span class="text-center stock_in_pie">
                        <p><b>{{__('administrator.total')}}</b>: 0</p>
                        <p><b>{{__('administrator.qty')}}</b>: 0</p>
                   </span>
                    </div>
                    <div class="col-md-1 col-sm-1 col-xs-1" style="padding-top: 12%">
                        <i class="fa fa-arrow-right fa-2x"></i>
                    </div>
                    <div class="col-md-4 col-sm-4 col-xs-4" style="">
                        <canvas id="sale_and_purchase" width="400" height="150">Your browser does not support the canvas
                            element.
                        </canvas>
                    </div>
                    <div class="col-md-1 col-sm-1 col-xs-1" style="padding-top: 12%">
                        <i class="fa fa-arrow-left fa-2x"></i>
                    </div>
                    <div class="col-md-3 col-sm-3 col-xs-3" style="padding-top: 12%">
                       <span class="text-center stock_out_pie">
                            <p><b>{{__('administrator.total')}}</b>: 0</p>
                            <p><b>{{__('administrator.qty')}}</b>: 0</p>
                       </span>
                    </div>
                    <div class="col-md-12 col-sm-12 col-xs-12">
                        <br>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-6 col-sm-6 col-xs-12">
            <div class="box-body " style="background: white;">
                <div class="row">
                    <div class="col-md-4 col-sm-4 col-xs-4" style="padding-top: 12%">
                    <span class="text-center posr_pie">
                   </span>
                    </div>
                    <div class="col-md-4 col-sm-4 col-xs-4" style="">
                        <canvas id="posr_stockr_chart">Your browser does not support the canvas element.</canvas>
                    </div>
                    <div class="col-md-4 col-sm-4 col-xs-4" style="padding-top: 12%">
                   <span class="text-center stockr_pie">
                   </span>
                    </div>
                    <div class="col-md-12 col-sm-12 col-xs-12">
                        <br>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-12 col-sm-12 col-xs-12"><br></div>
        <div class="col-md-3 col-sm-6 col-xs-12">
            <div class="info-box">
                <span class="info-box-icon bg-aqua"><i class="fa fa-user"></i></span>
                <div class="info-box-content">
                    <span class="info-box-text">{{__('administrator.total_customer')}}</span>
                    <span class="info-box-number">{{ @$total_customer }}</span>
                </div>
            </div>
        </div>
        <div class="col-md-3 col-sm-6 col-xs-12">
            <div class="info-box">
                <span class="info-box-icon bg-aqua"><i class="fa fa-handshake-o"></i></span>
                <div class="info-box-content">
                    <span class="info-box-text">{{__('administrator.total_partner')}}</span>
                    <span class="info-box-number">{{ @$total_partner }}</span>
                </div>
            </div>
        </div>
        <div class="col-md-3 col-sm-6 col-xs-12">
            <div class="info-box">
                <span class="info-box-icon bg-aqua"><i class="fa fa-users "></i></span>
                <div class="info-box-content">
                    <span class="info-box-text">{{__('administrator.total_dealer')}}</span>
                    <span class="info-box-number">{{ @$total_dealer }}</span>
                </div>
            </div>
        </div>
        <div class="col-md-3 col-sm-6 col-xs-12">
            <div class="info-box">
                <span class="info-box-icon bg-"><i class="fa fa-cubes"></i></span>
                <div class="info-box-content">
                    <span class="info-box-text">{{__('administrator.total_item')}}</span>
                    <span class="info-box-number" id="total_item">{{$all_item}}</span>
                </div>
            </div>
        </div>
        <div class="col-md-12 col-sm-12 col-xs-12">
            <h3>{{__('administrator.accounting')}}</h3>
        </div>
        <div class="col-md-6 col-sm-6 col-xs-12">
            <div class="box-body " style="background: white;">
                <div class="row">
                    <div class="col-md-12 col-sm-12 col-xs-12">
                        <h4>{{__('administrator.balance_sheet')}}</h4>
                    </div>
                    <div class="col-md-4 col-sm-4 col-xs-4" style="padding-top: 12%">

                    </div>
                    <div class="col-md-4 col-sm-4 col-xs-4">
                        <canvas id="balance_sheet_pie" width="400" height="150">Your browser does not support the canvas
                            element.
                        </canvas>
                    </div>
                    <div class="col-md-12 col-sm-12 col-xs-12">
                        <br>
                    </div>
                    <div class="col-md-12 col-sm-12 col-xs-12 text-right">
                        <h4><b>{{__('administrator.this_month')}}</b></h4>
                    </div>
                    <div class="col-md-12 col-sm-12 col-xs-12 balance_sheet_tb"></div>
                </div>
            </div>
        </div>
        <div class="col-md-6 col-sm-6 col-xs-12">
            <div class="box-body " style="background: white;">
                <canvas id="income_statement_chart">Your browser does not support the canvas
                    element.
                </canvas>
            </div>
        </div>



        <div class="col-md-12 col-sm-12 col-xs-12">
            <div class="demo-container">
                <div id="pivotgrid-demo">
                    <div id="pivotgrid-chart"></div>
                    <div id="pivotgrid"></div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script>
        $(document).ready(function () {
            $(() => {
                const pivotGridChart = $('#pivotgrid-chart').dxChart({
                    commonSeriesSettings: {
                        type: 'bar',
                    },
                    tooltip: {
                        enabled: true,
                        format: 'currency',
                        customizeTooltip(args) {
                            return {
                                html: `${args.seriesName} | Total<div class='currency'>${args.valueText}</div>`,
                            };
                        },
                    },
                    size: {
                        height: 200,
                    },
                    adaptiveLayout: {
                        width: 450,
                    },
                }).dxChart('instance');

                const pivotGrid = $('#pivotgrid').dxPivotGrid({
                    allowSortingBySummary: true,
                    allowFiltering: true,
                    showBorders: true,
                    showColumnGrandTotals: false,
                    showRowGrandTotals: false,
                    showRowTotals: false,
                    showColumnTotals: false,
                    fieldChooser: {
                        enabled: true,
                        height: 400,
                    },
                    dataSource: {
                        fields: [{
                            caption: 'Partner',
                            width: 120,
                            dataField: 'partner',
                            area: 'row',
                            sortBySummaryField: 'Total',
                        }, {
                            caption: 'Week',
                            dataField: 'week',
                            width: 150,
                            area: 'row',
                        }, {
                            dataField: 'date',
                            dataType: 'date',
                            area: 'column',
                        }, {
                            groupName: 'date',
                            groupInterval: 'month',
                            visible: false,
                        }, {
                            caption: 'Total',
                            dataField: 'amount',
                            dataType: 'number',
                            summaryType: 'sum',
                            format: 'currency',
                            area: 'data',
                        }],
                        store: sales,
                    },
                }).dxPivotGrid('instance');

                pivotGrid.bindChart(pivotGridChart, {
                    dataFieldsDisplayMode: 'splitPanes',
                    alternateDataFields: false,
                });

                function expand() {
                    const dataSource = pivotGrid.getDataSource();
                    dataSource.expandHeaderItem('row', ['test']);
                    dataSource.expandHeaderItem('column', [2023]);
                }

                setTimeout(expand, 0);
            });

            const sales = [{
                id: 10248,
                partner: 'Terk Tla',
                week: 'Week1',
                amount: 1740,
                date: new Date('2013-01-06'),
            }, {
                id: 10249,
                partner: 'Terk Tla',
                week: 'Week2',
                amount: 850,
                date: new Date('2013-01-13'),
            }, {
                id: 10250,
                partner: 'Terk Tla',
                week: 'Week3',
                amount: 2235,
                date: new Date('2013-01-07'),
            }];



            @can('Income by branch')
            BranchChart();
            @endcan
            @can('Report Income Dealer&Partner')
            @if(Auth::user()->branch_id)
            DpChart();
            @endif
            @endcan
            SaleAndPurchase();
            PosRandStockR();
            @can('Report Balance Sheet')
            balanceSheet();
            @endcan
            @can('Report Income Statement')
            incomeStatement();
            @endcan
        });

        function incomeStatement() {
            let ctx = document.getElementById('income_statement_chart');
            let url = '{{route('dashboard-income-statement')}}';
            $.ajax({
                url,
                method: "get",
                dataType: "json",
                success: function (data) {
                    const data_chart = {
                        labels: data.year,
                        datasets: [
                            {
                                label: 'Revenue',
                                data: data.revenue,
                                backgroundColor: [
                                    '#2980b9',
                                ],
                            },
                            {
                                label: 'Net Income',
                                data: data.net_income,
                                backgroundColor: [
                                    '#c0392b',
                                ],
                            },
                        ]
                    };
                    const config = {
                        type: 'bar',
                        data: data_chart,
                    };

                    new Chart(ctx, config);
                }
            });
        }

        function balanceSheet() {
            let blSheet = $('.balance_sheet_tb');
            $.ajax({
                url: "{{ route('accounting-report.trail-balance')}}?balance_sheet=1&from_date={{'01-10-'.date('Y')}}&to_date={{date('d-m-Y')}}",
                method: "get",
                dataType: "html",
                success: function (data) {
                    blSheet.html(data);
                    let assets = blSheet.find('td[data-assets]').data('assets');
                    let liability = blSheet.find('td[data-liability]').data('liability');
                    let equity = blSheet.find('td[data-equity]').data('equity');
                    equity = equity ? equity : 0;
                    let ctx = document.getElementById('balance_sheet_pie');
                    const data_chart = {
                        labels: [
                            'Assets = ' + assets,
                            'Liability = ' + liability,
                            'Equity =' + equity,
                        ],
                        datasets: [{
                            data: [assets, liability, equity],
                            backgroundColor: [
                                '#3498db',
                                '#e74c3c',
                                '#e67e22',
                            ],
                            hoverOffset: 4
                        }]
                    };
                    const config = {
                        type: 'pie',
                        data: data_chart,
                    };

                    new Chart(ctx, config);
                }
            });
        }

        function PosRandStockR() {
            $.get('{{route('dashboard-pos-stock-request')}}', function (data) {
                let sale_request = data.sale_request ? data.sale_request : 0;
                let stock_request = data.stock_request ? data.stock_request : 0;
                let ctx = document.getElementById('posr_stockr_chart');
                const data_chart = {
                    labels: [
                        'POS Request',
                        'Stock Request',
                    ],
                    datasets: [{
                        label: 'My First Dataset',
                        data: [sale_request, stock_request],
                        backgroundColor: [
                            '#e74c3c',
                            '#2ecc71',
                        ],
                        hoverOffset: 4
                    }]
                };
                const config = {
                    type: 'pie',
                    data: data_chart,
                };

                new Chart(ctx, config);
                $('.posr_pie').html(`<p><b>Item : </b>: ${sale_request}</p>`);
                $('.stockr_pie').html(`<p><b>Item : </b>: ${stock_request}</p>`);

            });
        }

        function SaleAndPurchase() {
            $.get('{{route('dashboard-sale-purchase')}}', function (data) {
                let stock_in = data.stock_in;
                let stock_out = data.stock_out;
                let ctx = document.getElementById('sale_and_purchase');
                const data_chart = {
                    labels: [
                        'Purchase',
                        'Sale',
                    ],
                    datasets: [{
                        label: 'My First Dataset',
                        data: [stock_in.in_qty ? stock_in.in_qty : 0, stock_out.out_qty ? stock_out.out_qty : 0],
                        backgroundColor: [
                            '#e67e22',
                            '#3498db',
                        ],
                        hoverOffset: 4
                    }]
                };
                const config = {
                    type: 'pie',
                    data: data_chart,
                };


                new Chart(ctx, config);
                $('.stock_out_pie').html(pie_total(stock_out.total_cost, stock_out.out_qty));
                $('.stock_in_pie').html(pie_total(stock_in.total_cost, stock_in.in_qty));

            });
        }

        function pie_total(cost = 0, qty = 0) {
            return `<p><b>Total</b>: ${cost ? cost.toFixed(2) : ''}</p><p><b>QTY</b>: ${qty ? qty : 0}</p>`;
        }

        function BranchChart() {
            let total = 0;
            $.get('{{route('report-income-by-branch')}}', function (data) {
                let ctx = document.getElementById('branch_chart');
                new Chart(ctx, {
                    type: 'bar',
                    data: {
                        labels: data.branch,
                        datasets: [{
                            label: '{{__('administrator.income')}}',
                            data: data.amount,
                            backgroundColor: [
                                '#1abc9c',
                                '#2ecc71',
                                '#3498db',
                                '#9b59b6',
                                '#34495e',
                                '#f1c40f',
                                '#e67e22',
                                '#e74c3c',
                                '#95a5a6',
                                '#f39c12',
                                '#16a085',
                                '#27ae60',
                                '#2980b9',
                                '#8e44ad',
                            ]
                        }]
                    },
                    options: {
                        scales: {
                            y: { // defining min and max so hiding the dataset does not change scale range
                                beginAtZero: true,
                                min: 0,
                                max: 100
                            }
                        },
                        animations: {
                            tension: {
                                duration: 1000,
                                easing: 'linear',
                                from: 1,
                                to: 0,
                                loop: true
                            }
                        },
                        indexAxis: 'y',
                    }
                });
                $.each(data.amount, function (ii, vv) {
                    total += vv;
                });
                if (total) {
                    $('.total_income_branch').text('$' + total.toFixed(2));
                }
            });
        }

        function DpChart() {
            let total = 0;
            $.get('{{route('report-income-by-dealer-partner')}}', function (data) {
                let ctx = document.getElementById('dp_chart');
                new Chart(ctx, {
                    type: 'bar',
                    data: {
                        labels: data.branch,
                        datasets: [{
                            label: '{{__('administrator.income')}}',
                            data: data.amount,
                            backgroundColor: [
                                '#1abc9c',
                                '#2ecc71',
                                '#3498db',
                                '#9b59b6',
                                '#34495e',
                                '#f1c40f',
                                '#e67e22',
                                '#e74c3c',
                                '#95a5a6',
                                '#f39c12',
                                '#16a085',
                                '#27ae60',
                                '#2980b9',
                                '#8e44ad',
                            ]
                        }]
                    },
                    options: {
                        scales: {
                            y: { // defining min and max so hiding the dataset does not change scale range
                                beginAtZero: true,
                                min: 0,
                                max: 100
                            }
                        },
                        animations: {
                            tension: {
                                duration: 1000,
                                easing: 'linear',
                                from: 1,
                                to: 0,
                                loop: true
                            }
                        },
                        indexAxis: 'y',
                    }
                });
                $.each(data.amount, function (ii, vv) {
                    total += vv;
                });
                if (total) {
                    $('.total_income_dp').text('$' + total.toFixed(2));
                }
            });
        }
    </script>

@endsection
