<?php Fun::lang() ?>
@extends(branchMenu())
@section('content')
    <div class="row">
        <div class="col-xs-12">
            <div class="box">
                <div class="box-header">
                    <div class="row">
                        <div class="col-sm-12 col-xs-12">
                            <div class="title-add">
                                <div class="pull-left">
                                    <h3>{{__('administrator.journal_list')}}</h3>
                                </div>

                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12" id="block-action">
                            <div class="content-action">
                                {!! Form::open(['class'=>'form_search']) !!}
                                <div class="form-group  col-sm-3 col-xs-3">
                                    <label>Reference Number</label>
                                    {!! Form::text('reference_no', null, array('placeholder' => 'Reference Number','class' => 'form-control ref_no')) !!}
                                </div>
                                <div class="form-group col-sm-3 col-xs-3">
                                    <label>Start Date</label>
                                    {!! Form::text('start_date', null, array('placeholder' => 'Start Date','class' => 'form-control date_picker start_date','autocomplete' => 'off')) !!}
                                </div>
                                <div class="form-group col-sm-3 col-xs-3">
                                    <label>End Date</label>
                                    {!! Form::text('end_date', null, array('placeholder' => 'End Date','class' => 'form-control date_picker end_date','autocomplete' => 'off')) !!}
                                </div>
                                {!! Form::close() !!}
                                <div class="col-sm-1">
                                    <label for="">&nbsp;</label>
                                    <button type="button" class="btn btn-info btn_search form-control"><i class="fa fa-search"></i> Search</button>
                                </div>
                                <div class="col-sm-1">
                                    <label for="">&nbsp;</label>
                                    <a class="btn form-control btn-default btn-print"><i class="fa fa-print"></i> Print</a>
                                </div>
                                @can('Journal Create')
                                    <div class="col-sm-1">
                                        <label for="">&nbsp;</label>
                                        <a data-href="{{route('journal.create')}}" data-text="{{__('administrator.create')}} {{__('administrator.journal')}}" class="btn btn-primary form-control btn_action"><i class="fa fa-plus"></i> Add New </a>
                                    </div>
                                @endcan

                            </div>
                        </div>
                    </div>
                </div>
                <div class="box-body" style="overflow-x:auto;">
                    <table id="table_journal" class="table table-bordered table-striped table-hover">
                        <thead>
                        <tr>
                            <th><label for="checkall">
                                    <input type="checkbox" id="checkall">
                                </label>
                            </th>
                            <th>No</th>
                            <th>Journal Date</th>
                            <th>User Name</th>
                            <th>Branch Name</th>
                            <th>Reference Number</th>
                            <th>Voucher Type</th>
                            <th>Voucher Number</th>
                            <th>Transaction Type</th>
                            <th>Debit</th>
                            <th>Credit</th>
                            <th width="7%">Action</th>
                        </tr>
                        </thead>
                        <tbody id="tbody"></tbody>
                        <tfoot id="tfoot">
                        <tr>
                            <td colspan="9" class="text-right bold-green">Total</td>
                            <td class="bold-orange total_debit"></td>
                            <td class="bold-orange total_credit"></td>
                            <td></td>
                        </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')
    <script type="text/javascript">
        $(document).ready(function () {
            getTable();
            $('.btn_search').on('click', function (e) {
                getTable();
            });
            $(document).on('click','.btn_action', function (e) {
                getHtmlForm($(this).data('href'),$(this).data('text'),'1000px');
            });
            $(document).on('click','.btn_delete', function (e) {
                let text = $(this).closest('tr').find('td:nth-child(8)').text();
                confirmForm($(this).data('href'),'Are you sure?','Voucher Ref: '+text,'danger','500px','fa fa-trash','red');
            });
        });

        let ArrId = [];
        $(document).on('change', '#checkall', function () {
            ArrId = [];
            if ($(this).is(':checked')) {
                $('button[type="submit"]').removeAttr('disabled');
                $('.checkbox').each(function () {
                    $(this).prop('checked', true);
                    var id = $(this).attr('id');
                    ArrId.push(id);
                });
            } else {
                $('.checkbox').each(function () {
                    $(this).prop('checked', false);
                    ArrId = [];
                });
            }
            push_data(ArrId);
        });
        $(document).on('change', '.checkbox', function () {
            var id = $(this).attr('id');
            if ($(this).is(':checked')) {
                $('input[type="submit"]').removeAttr('disabled');
                ArrId.push(id);
            } else {
                var index = ArrId.indexOf(id);
                if (index > -1) {
                    ArrId.splice(index, 1);
                }
            }
            push_data(ArrId);
        });

        function push_data(obj) {
            let btn = $('.btn-print');
            let journal_tran_id = '{{route('voucher.print')}}?journal_tran_id='+obj;
            if(obj.length){
                btn.attr('href',journal_tran_id);
                btn.removeClass('btn-default');
                btn.addClass('btn-success');
            }else{
                btn.attr('href','#');
                btn.removeClass('btn-success');
                btn.addClass('btn-default');
            }
        }



        function getTable() {
            let form = $('.form_search').serialize();
            $('#table_journal').DataTable().destroy();
            $('#table_journal').DataTable({
                serverSide: true,
                ordering: false,
                searching: false,
                lengthMenu: tbLength,
                ajax: {
                    url: "{{ route('datatable.get-journal') }}?"+form,
                },
                columns: [
                    {data: 'checkbox'}
                    , {data: 'journal_tran_id'}
                    , {data: 'journal_paydate'}
                    , {data: 'name'}
                    , {data: 'branch_name'}
                    , {data: 'journal_reference_number'}
                    , {data: 'voucher'}
                    , {data: 'voucher_ref'}
                    , {data: 'transaction_type'}
                    , {data: 'debit'}
                    , {data: 'credit'},
                    {data: 'action'}
                ],
                dom: 'lBfrtip',
                "buttons": [
                    {"extend": 'excelHtml5', "text": 'Export', "className": 'btn btn-success'}
                ],
                "initComplete": function (settings, json) {
                },
                "fnDrawCallback": function (row, data, start, end, display) {
                    let tr = $('#tbody tr');
                    let total_debit_usd = 0;
                    let total_credit_usd = 0;
                    $.each(tr, function (ii, vv) {
                        let amount_debit = $(this).find('td:nth-child(10) span').data('debit');
                        let amount_credit = $(this).find('td:nth-child(11) span').data('credit');

                        amount_debit = amount_debit ? parseFloat(amount_debit) : 0;
                        amount_credit = amount_credit ? parseFloat(amount_credit) : 0;
                        total_debit_usd += amount_debit;
                        total_credit_usd += amount_credit;
                    });
                    let tdu = total_debit_usd ? ('$' + parseFloat(total_debit_usd).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')) : '';
                    let tcu = total_credit_usd ? ('$' + parseFloat(total_credit_usd).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')) : '';
                    $('#tfoot tr:first-child ').find('.total_credit').html((tcu ? (tcu + '<br>') : ''));
                    $('#tfoot tr:first-child ').find('.total_debit').html((tdu ? (tdu + '<br>') : ''));
                },
            });
        }
    </script>
{{--    Create Edit Journal--}}
    <script type="text/javascript">
        $(document).on('click', '.btn-add', function () {
            add_journal();
        });
        $(document).on('keyup', '.debit,.credit', function () {
            sum_journal();
        });
        $(document).on('keyup', '.account_code', function () {
            let obj = $(this).val();
            account_code(obj, $(this).closest('tr'));
        });
        $(document).on('click', '.btn-remove', function () {
            $(this).parent().parent().remove();
        });

        function account_code(obj, element) {
            $.ajax({
                url: "{{ route('search-account-code')}}",
                method: "POST",
                dataType: "json",
                data: {
                    obj: obj,
                    _token: '{{ csrf_token() }}',
                },
                success: function (data) {
                    let html = `<option value=""> Please Select </option>`;
                    if (Object.keys(data).length) {
                        $.each(data, function (index, value) {
                            html += `<option value="${value.id}"> ${value.id + " | " + value.acc_name} </option>`;
                        });
                    }
                    element.find('.account_code1').html(html);
                }
            });
        }

        function add_journal() {
            let tbody_tr = $(document).find('#add_journal tr');
            let tbody = $(document).find('#add_journal');
            let count = tbody_tr.length;
            let button = '';
            if (count === 0) {
                button = '<span class="btn btn-success btn-sm btn-add"><i class="fa fa-plus"></i></span>';
            } else {
                button = '<span class="btn btn-danger btn-sm btn-remove"><i class="fa fa-trash"></i></span>';
            }
            let [total_de, total_cr] = sum_journal();
            let debit = 0;
            let credit = 0;
            let $amount = Math.abs(total_de - total_cr);

            if (total_de > total_cr) {
                credit = $amount;
            } else {
                debit = $amount;
            }
            let row = `<tr class="tr">
                     <td>{!! Form::select('account_code[]',[],  null, ['placeholder'=>__('administrator.please_select'),'class' => 'form-control search_account_chart','required']) !!}</td>
                     <td><input type="text" name="debit[]" value="${debit}" class="form-control debit" placeholder="Debit" required></td>
                     <td><input type="text" name="credit[]" value="${credit}" class="form-control credit" placeholder="Credit" required></td>
                     <td>{!! Form::textarea('note[]', null, ['class' => 'form-control','rows'=>1]) !!}</td>
                     <td>${button}</td>
                </tr>`;
            tbody.append(row);
            setTimeout(function () {
                search_account_chart();
                sum_journal();
            },100);

        }

        function sum_journal() {
            let total_de = 0;
            let total_cr = 0;
            $.each($(document).find('#add_journal tr'), function (ii, vv) {
                let de = $(this).find('.debit').val();
                let cr = $(this).find('.credit').val();

                de = de ? parseFloat(de) : 0;
                cr = cr ? parseFloat(cr) : 0;
                total_de += de;
                total_cr += cr;
            });
            if (total_de !== total_cr) {
                $('button[type=submit]').prop('disabled', true);
            } else {
                $('button[type=submit]').prop('disabled', false);
            }
            return [total_de, total_cr]
        }


    </script>

@endsection
