<?php Fun::lang() ?>
@extends(branchMenu())
@section('content')
    <div class="page">
        <div>
            <div class="row">
                <div class="col-sm-12 col-xs-12">
                    <div class="title-add">
                        <div class="pull-left">
                            <h3>Account Chart</h3>
                        </div>
                        <div class="pull-right">
                            <a class="btn btn-primary" href="{{route('account-chart.create')}}"><span
                                        class="fa fa-plus"></span> Create New</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <br>
        <div class="box-body table-responsive">
            <table id="datatable_account_chart" class="table table-bordered table-hover nowrap">
                <thead>
                <tr>
                    <th>Account Code</th>
                    <th>Account Name</th>
                    <th>Account Name Khmer</th>
                    <th>Account Type</th>
                    <th>Description</th>
                    <th>Action</th>
                </tr>
                </thead>
                <tbody>
                @if(isset($account_chart) && count($account_chart) > 0)
                    @foreach($account_chart as $key => $acc_chart)
                        <?php
                        $sub_account_chart = \App\Model\Accounting\AccountChartModel::
                        select("nso007_account_chart.*")
                            ->where('nso007_account_chart.sub_acc', 1)
                            ->where('nso007_account_chart.acctype', $acc_chart->id)
                            ->where('nso007_account_chart.acc_name', 'not like', 'Account Receivable - %')
                            ->where('nso007_account_chart.acc_name', 'not like', 'Account Payable - %')
                            ->where('nso007_account_chart.acc_name', 'not like', 'Saving Point liability - %')
                            ->where('nso007_account_chart.acc_name', 'not like', 'Saving Point Expense - %')
                            ->where(function ($q) {
                                $q->where('branch_id', FindBranchID());
                                $q->orwhere('default', 1);
                            })
                            ->orderBy('nso007_account_chart.id', 'ASC')
                            ->get();
                        ?>
                        <tr id="{{$acc_chart->id}}">
                            <td>{{$acc_chart->id}}</td>
                            <td>{{$acc_chart->acc_name}}</td>
                            <td>{{$acc_chart->acc_namekh}}</td>
                            <td>{{$acc_chart->acctype_name}}</td>
                            <td>{{$acc_chart->acc_des}}</td>
                            <td>
                                @if($acc_chart->acc_status != 0  && Auth::id()===$acc_chart->user_id)
                                    <a href="{{route('account-chart.edit',$acc_chart->id)}}"
                                       class="btn btn-success btn-xs" style="margin-right: 5px"><i class="fa fa-edit" title="Edit"></i></a>
                                    <a href="#" data-id="{{$acc_chart->id}}" data-toggle="modal" data-target="#form-delete" class="btn-xs btn btn-danger confirm_delete"
                                       data-toggle="tooltip" data-placement="top" title="Delete"><i class="fa fa-trash"></i></a>
                                @endif
                            </td>
                        </tr>
                        @foreach($sub_account_chart as $sub_key => $sub_acc_chart)
                            <?php
                            $sub1_account_chart = \App\Model\Accounting\AccountChartModel::
                            select("nso007_account_chart.*")
                                ->where('nso007_account_chart.sub_acc', 1)
                                ->where('nso007_account_chart.acctype', $sub_acc_chart->id)
                                ->where('nso007_account_chart.acc_name', 'not like', 'Account Receivable%')
                                ->where('nso007_account_chart.acc_name', 'not like', 'Account Payable%')
                                ->where('nso007_account_chart.acc_name', 'not like', 'Saving Point liability - %')
                                ->where('nso007_account_chart.acc_name', 'not like', 'Saving Point Expense - %')
                                ->where(function ($q) {
                                    $q->where('branch_id', FindBranchID());
                                    $q->orwhere('default', 1);
                                })
                                ->orderBy('nso007_account_chart.id', 'ASC')
                                ->get();
                            ?>
                            <tr id="{{$sub_acc_chart->id}}">
                                <td>&nbsp;&diams;{{$sub_acc_chart->id}}</td>
                                <td>{{$sub_acc_chart->acc_name}}</td>
                                <td>{{$sub_acc_chart->acc_namekh}}</td>
                                <td></td>
                                <td>{{$sub_acc_chart->acc_des}}</td>
                                <td>
                                    @if($sub_acc_chart->acc_status != 0  && Auth::id()===$sub_acc_chart->user_id)
                                        <a href="{{route('account-chart.edit',$sub_acc_chart->id)}}"
                                           class="btn btn-success btn-xs" style="margin-right: 5px"><i class="fa fa-edit"
                                                                                                       title="Edit"></i></a>
                                        <a href="#" data-id="{{$sub_acc_chart->id}}" data-toggle="modal"
                                           data-target="#form-delete" class="btn-xs btn btn-danger confirm_delete"
                                           data-toggle="tooltip" data-placement="top" title="Delete"><i
                                                    class="fa fa-trash"></i></a>
                                    @endif
                                </td>
                            </tr>
                            @foreach($sub1_account_chart as $sub_key => $sub1_acc_chart)
                                <tr id="{{$sub1_acc_chart->id}}">
                                    <td>&nbsp;&nbsp;&nbsp;&diams;&diams;{{$sub1_acc_chart->id}}</td>
                                    <td>{{$sub1_acc_chart->acc_name}}</td>
                                    <td>{{$sub1_acc_chart->acc_namekh}}</td>
                                    <td></td>
                                    <td>{{$sub1_acc_chart->acc_des}}</td>
                                    <td>
                                        @if($sub1_acc_chart->acc_status != 0 && Auth::id()===$sub1_acc_chart->user_id)
                                                <a href="{{route('account-chart.edit',$sub1_acc_chart->id)}}" class="btn btn-success btn-xs" style="margin-right: 5px"><i class="fa fa-edit" title="Edit"></i></a>
                                                <a href="#" data-id="{{$sub1_acc_chart->id}}" data-toggle="modal" data-target="#form-delete" class="btn-xs btn btn-danger confirm_delete" data-toggle="tooltip" data-placement="top" title="Delete"><i class="fa fa-trash"></i></a>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        @endforeach
                    @endforeach
                @endif
                </tbody>
            </table>
        </div>
    </div>
    @include('Accounting.account-chart.confirm-delete')
@endsection
@section('script')
    <script type="text/javascript">
        $(document).ready(function () {
            $('#datatable_account_chart').DataTable({
                lengthMenu: tbLength,
                ordering: false
            });
            $(document).on('click', '.confirm_delete', function () {
                var id = $(this).data('id');
                $('#delete-id').val(id);
                $('#form-delete').modal('show');
            });
        });
    </script>
@endsection
