<?php

    namespace App;

    use App\Model\setup\MemberTypeModel;
    use Illuminate\Notifications\Notifiable;
    use Illuminate\Foundation\Auth\User as Authenticatable;
    use Spatie\Permission\Traits\HasRoles;

    class User extends Authenticatable
    {
        use Notifiable;
        use HasRoles;

        protected $table = 'users';
        protected $primaryKey = 'id';
        protected $fillable = [
            'id',
            'user_id',
            'leader_id',
            'child_by_branch',
            'branch_id',
            'name',
            'phone',
            'email',
            'gender',
            'user_type',
            'member_type_id',
            'status',
            'id_card',
            'date_of_birth',
            'province_id',
            'district_id',
            'commune_id',
            'village_id',
            'street',
            'house',
            'image',
            'username',
            'password',
            'remember_token',
            'acc_account_payable',
            'acc_account_receivable',
            'created_at',
            'updated_at',
        ];


        protected $hidden = [
            'password', 'remember_token',
        ];

        public function branch()
        {
            return $this->belongsTo('App\Model\Hr\HrBranch', 'branch_id', 'id');
        }

        public function member_type()
        {
            return $this->hasOne(MemberTypeModel::class, 'id','member_type_id');
        }
    }
