<?php

    namespace App\Model;

    use Illuminate\Database\Eloquent\Model;

    class PurchaseModel extends Model
    {
        /**
         * The attributes that are mass assignable.
         *
         * @var array
         */
        protected $table = "nso007_purchases";

        protected $fillable = [
            'branch_id',
            'member_id',
            'delivery_to_member',
            'member_purchase_id',
            'request_to',
            'request_to_type',
            'payment_method',
            'payment_type',
            'reference',
            'user_id',
            'supplier_id',
            'invoice_number',
            'year',
            'purchase_date',
            'grand_total',
            'paid_usd',
            'rate',
            'discount',
            'payment_status',
            'status',
            'confirm_receive',
            'description',
        ];

        public function detail()
        {
            return $this->hasMany(PurchaseDetailsModel::class,'purchase_id','id');
        }
    }
