<?php

namespace App\Model;

use App\Model\product\UnitModel;
use Illuminate\Database\Eloquent\Model;

class ProductUnitModel extends Model
{
    protected $table = 'nso007_product_unit';

    protected $fillable = [
        'product_id',
        'unit_id',
        'sub_unit_id',
        'cost',
        'wholesale_price',
        'retail_price',
        'qty_per_unit',
        'barcode',
        'item_code',
        'image',
    ];

    public function product()
    {
        return $this->belongsTo('App\Model\ProductModel', 'product_id');
    }
    public function unit()
    {
        return $this->belongsTo(UnitModel::class, 'unit_id');
    }

    public function unit_child()
    {
        return $this->belongsTo(UnitModel::class, 'sub_unit_id');
    }
}
