<?php

namespace App\Model;

use App\Model\product\UnitModel;
use Illuminate\Database\Eloquent\Model;

class ProductModel extends Model
{
    protected $table = "nso007_products";

    protected $fillable = [
        'id',
        'brand_id',
        'acc_inventory',
        'acc_cost_of_good_sold',
        'acc_sale_revenue',
        'commission',
        'image',
        'shelf',
        'type',
        'currency',
        'category_id',
        'product_name',
        'item_code',
        'qty_alert',
        'description',
        'status'
    ];

    public function brand()
    {
        return $this->belongsTo('App\Model\product\BrandModel', 'brand_id');
    }

    public function category()
    {
        return $this->belongsTo('App\Model\product\CategoryModel', 'category_id');
    }

    public function product_units()
    {
        return $this->hasMany('App\Model\ProductUnitModel', 'product_id');
    }

}
