<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;

class CRMLeadModel extends Model
{
    protected $table = 'nso007_crm_leads';

    protected $fillable = [
         'id',
        'branch_id',
        'date',
        'agent_id',
        'agent_type',
        'lead_source',
        'known_product_by',
        'contact_by',
        'family_name',
        'name',
        'sex',
        'age',
        'contact',
        'address',
        'district_or_city',
        'email',
        'job',
        'workplace',
        'customer_note',
        'note',
        'category_type',
        'close_deal_note',
        'convert_status',
        'delete_status',
        'illness',
        'illness_status',
        'advice_product',
        'other',
        'province',
        'delete_reason',
        'deleted_by',
        'deleted_at',
        'created_at',
        'updated_at',    ];

    public function tasks()
    {
        return $this->hasMany('App\Model\CRMTaskModel', 'lead_id');
    }

    public function agent_name()
    {
        return \DB::table('users')->where('id', $this->agent_id)->first()->name;
    }

    public function source()
    {
        return \DB::table('nso007_crm_lead_source')->where('id', $this->lead_source)->first()->source_name;
    }
}
