<?php


namespace App\Http\Controllers\setup;


use App\Fun\Fun;
use App\Http\Controllers\Controller;
use App\Model\setup\MemberTypeModel;
use Auth;
use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;

class MemberTypeController extends Controller

{

    function __construct()

    {
        $this->middleware('permission:Member Type Create', ['only' => ['create', 'store']]);
        $this->middleware('permission:Member Type List', ['only' => ['index']]);
        $this->middleware('permission:Member Type Edit', ['only' => ['update', 'edit']]);
    }

    public function index(Request $request)
    {
        if ($request->ajax()) {
            $data = MemberTypeModel::orderBy('level','desc')
                ->take(20);
            $count = $data->count();
            return DataTables::of($data)
                ->with([
                    "recordsTotal" => $count,
                    "recordsFiltered" => $count,
                ])
                ->addColumn('action', function ($action) {
                    $btn = '';
                    if (uCan('Member Type Edit')) {
                        $btn .= '<a data-href = "' . route("member-type.edit", $action->id) . '" class="fa fa-pencil btn btn-warning getHtmlForm" title="' . __('administrator.edit') . '"></a>';
                    }
                    return $btn;
                })
                ->editColumn('discount', function ($action) {
                    return $action->discount.'%';
                })
                ->editColumn('created_at', function ($action) {
                    return myDate($action->created_at);
                })
                ->addIndexColumn()
                ->rawColumns(['action'])
                ->make(true);

        }
        return view('setup.member-type.index');
    }

    public function create(Request $request)
    {
        return view('setup.member-type.create');
    }

    public function store(Request $request)

    {
        return $this->update($request,null);
    }
    public function edit($id)
    {
        $master = MemberTypeModel::find($id);
        return view('setup.member-type.edit', compact('master'));
    }
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required|unique:nso007_member_type,name,'.$id,
            'level' => 'required|unique:nso007_member_type,level,'.$id,
            'discount' => 'required|unique:nso007_member_type,discount,'.$id,
        ]);
        $data = $request->all();
        $data['user_id']= Auth::id();
        MemberTypeModel::updateOrCreate(['id'=>$id],$data);
        return response()->json(['status'=>'ok']);
    }
    public function destroy($id)
    {
        MemberTypeModel::find($id)->delete();
        return response()->json(['status'=>'ok','reload'=>1]);
    }
}
