<?php

    namespace App\Http\Controllers\pos;

    use App\Http\Controllers\Controller;
    use App\Model\Accounting\AccountChartModel;
    use App\Model\Accounting\JournalModel;
    use App\Model\CostOfSoldModel;
    use App\Model\CustomerBranchModel;
    use App\Model\CustomerDiscountModel;
    use App\Model\CustomerIllnessModel;
    use App\Model\CustomerInfoModel;
    use App\Model\CustomerModel;
    use App\Model\DiscountModel;
    use App\Model\ImageModel;
    use App\Model\MemberModel;
    use App\Model\MemberTypeModel;
    use App\Model\PaymentDetailModel;
    use App\Model\PaymentModel;
    use App\Model\product\ProductQtyPriceModel;
    use App\Model\ProductModel;
    use App\Model\ProductUnitModel;
    use App\Model\Promotion;
    use App\Model\purchase_order\PurchaseOrderDetailModel;
    use App\Model\purchase_order\PurchaseOrderModel;
    use App\Model\PurchaseOrder;
    use App\Model\SaleDetailsModel;
    use App\Model\SaleModel;
    use App\Model\setup\CustomerStatusModel;
    use App\Model\StockModel;
    use App\Model\WarehouseModel;
    use App\Models\TypeOfIllness;
    use Auth;
    use Carbon\Carbon;
    use Illuminate\Http\Request;
    use Illuminate\Support\Facades\Crypt;
    use Illuminate\Support\Facades\DB;
    use Illuminate\Validation\ValidationException;
    use Yajra\DataTables\DataTables;

    class PosRetailController extends Controller
    {

        public function index(Request $request)
        {
            if ($request->ajax()) {
                $check = $request['pos_history'];
                if ($request->invoice) {
                    $condition = 'invoice_number';
                } elseif ($request->receipt) {
                    $condition = 'receipt_number';
                } else {
                    $condition = 'sale_date';
                }
                $data = SaleModel::join('nso007_customers', 'nso007_sales.customer_id', 'nso007_customers.id')
                    ->join('users as seller', 'nso007_sales.user_id', 'seller.id')
                    ->join('nso007_payment as payment', 'nso007_sales.id', 'payment.invoice_id')
                    ->when($request['reference_invoice'],function ($q) use ($request) {
                        $q->where('reference_number',$request['reference_invoice']);
                    })
                    ->when($request['payment_type'],function ($q) use ($request) {
                        $q->where('payment_type',$request['payment_type']);
                    })
                    ->when($request['from_date'],function ($q) use ($request) {
                        $q->whereDate('sale_date','>=',sDate($request['from_date']));
                    })

                    ->when($request['to_date'],function ($q) use ($request) {
                        $q->whereDate('sale_date','<=',sDate($request['to_date']));
                    })
                    ->when($request['payment_status'],function ($q) use ($request) {
                        $q->where('nso007_sales.payment_status',$request['payment_status']);
                    })

                    ->where(function ($q) use ($check, $request) {
                        if (!$check) {
                            if ($request->invoice) {
                                $q->where('nso007_sales.payment_status', '!=', 'paid');
                            } else {
                                $q->where('payment.payment_status', 'paid');
                            }
                            $q->whereNull('nso007_sales.delete_at');
                        }
                        $q->where('nso007_sales.sale_type', 'retail');
                        $q->where('payment.type','retail');
                        $q->where('payment.user_id',Auth::id());

                    })
                    ->selectRaw('
                            nso007_sales.invoice_number,
                            nso007_customers.customer_name,
                            seller.name as seller,
                            nso007_sales.id,
                            nso007_sales.reference_number,
                            nso007_sales.receipt_number,
                            nso007_sales.sale_date,
                            nso007_sales.status,
                            nso007_sales.type,
                            nso007_sales.payment_method,
                            nso007_sales.delete_at,
                            nso007_sales.invoice_reference,
                            nso007_sales.delete_reason,
                            nso007_sales.payment_status,
                            nso007_sales.grand_total,
                            nso007_sales.user_id,
                            nso007_sales.remain,
                            payment.paid_amount,
                            payment.id as payment_id
                        ')
                    ->orderBy('nso007_sales.' . $condition, 'DESC')
                    ->take(20);

                return DataTables::of($data)
                    ->with([
                        "recordsTotal" => $data->count(),
                        "recordsFiltered" => $data->count(),
                    ])
                    ->addColumn('action', function ($action) use ($check, $request) {
                        $date = Date('Y-m-d');
                        $payment_status = $action->payment_status;
                        if (!$request->invoice) {
                            $payment_status = 'paid';
                        }
                        $btn = '';
                        if ($action->customer_id && !$action->delete_at) {
                            $btn .= '<a href="' . route('customer_care.view', $action->customer_id) . '" class="btn btn-sm btn-success fa fa-medkit" title="Customer Care" ></a>';
                        }
                        $btn .= ' <i href="javascript:;"
                        class="fa fa-eye btn btn-sm btn-primary showDetail"
                        data-get_payment_url = "' . route("payment.edit", $action->payment_id) . '"
                        data-href="' . route('get-maho-invoice', $action->id) . '"
                        data-status="' . $payment_status . '"
                        title="View Detail"></i> ';

                        $check_file = ImageModel::where(['model' => $action->getTable(), 'model_id' => $action->id])->first();
                        if ($check_file) {
                            $btn .= '
                            <a data-href="' . route('get-image') . '?model=' . $action->getTable() . '&model_id=' . $action->id . '" class="btn btn-primary fa fa-file btn_show_file" ></a>';
                        }
                        if ($action->type !== 'return' && $check && ( $date == sDate($action->sale_date))&&$action->user_id==Auth::id()) {
                            if (!$action->delete_at&&1==2) {
                                $btn .= ' <a type="button"
                            class="fa fa-edit btn btn-sm btn-warning btn_edit display-none"
                            href="' . route('pos-retail.edit', $action->id) . '"
                            title="Edit"></a> ';
                                $btn .= '<button type="button"
                            class="fa fa-trash btn btn-sm btn-danger btn_delete"
                            data-href="' . route('delete-sale', $action->id) . '"
                            title="Delete"></button>';
                            }
                        }
                        return $btn;
                    })
                    ->editColumn('payment_status', function ($action) {
                        return textStatus($action->payment_status);
                    })
                    ->addColumn('paid_amount', function ($action) {
                        return '$' . number_format($action->paid_amount, 2);
                    })
                    ->addColumn('payment_amount', function ($action) {
                        return '<span class="sum_data"
                        data-paid ="' . $action->paid_amount_usd . '"
                        data-payment_amount ="' . $action->payment_amount . '"
                        data-remain ="' . $action->remain . '"
                        data-delete_at ="' . $action->delete_at . '"
                        >$' . number_format($action->payment_amount, 2) . '</span>';
                    })
                    ->addColumn('remain', function ($action) {
                        return '$' . number_format($action->remain, 2);
                    })
                    ->addColumn('grand_total', function ($action) {
                        return '$' . number_format($action->grand_total, 2);
                    })
                    ->editColumn('sale_date', function ($action) {
                        return myDate($action->sale_date);
                    })
                    ->addColumn('payment_method', function ($action) {
                        $acc = AccountChartModel::find($action->payment_method);
                        return $acc->acc_name ?? '';
                    })
                    ->addIndexColumn()
                    ->rawColumns(['action', 'payment_amount', 'bach', 'payment_status', 'status', 'payment_method'])
                    ->make(true);
            }
            $customer_status = CustomerStatusModel::pluck('name', 'id');
            return view('pos.pos-retail.index', compact('customer_status'));
        }

        public function create(Request $request, $id = '')
        {
            //Select Item Code (product_unit_id)
            if ($request->product_unit_id) {
                $stock = StockModel::where(['nso007_stocks.product_unit_id' => $request['product_unit_id'], 'nso007_stocks.member_id' => Auth::id()])->first()->stock_qty ?? 0;
                $product_unit = ProductUnitModel::find($request['product_unit_id']);
                $product = getProductById($product_unit->product_id);
                return response()->json(['stock_qty' => $stock, 'price' => $product_unit->retail_price, 'default_shelf' => $product->shelf]);
            }

            //Select Product
            if ($request->select_product) {
                $product = getProductById($request->select_product);
                $item_code = StockModel::where('nso007_stocks.product_id', $request->select_product)
                    ->join('nso007_product_unit', 'nso007_product_unit.id', 'nso007_stocks.product_unit_id')
                    ->join('nso007_unit', 'nso007_product_unit.unit_id', 'nso007_unit.id')
                    ->where(function ($q) {
                        if (ifMember()) {
                            $q->where('nso007_stocks.member_id', Auth::id());
                        } else {
                            $q->where('nso007_stocks.branch_id', FindBranchID());
                        }
                    })
                    ->selectRaw('CONCAT(nso007_stocks.item_code," | ",nso007_stocks.stock_qty,nso007_unit.unit) as text,nso007_stocks.product_unit_id,nso007_stocks.stock_qty')
                    ->get();

                return response()->json(['product_name' => $product->product_name, 'item_code' => $item_code]);
            }
            if ($request->ajax()) {
                $search = $request->search;
                $stock_item = StockModel::join('nso007_product_unit', 'nso007_product_unit.id', 'nso007_stocks.product_unit_id')
                    ->join('nso007_products', 'nso007_product_unit.product_id', 'nso007_products.id')
                    ->where(function ($q) {
                        if (ifMember()) {
                            $q->where('nso007_stocks.member_id', Auth::id());
                        } else {
                            $q->where('nso007_stocks.branch_id', FindBranchID());
                        }
                    })
                    ->where('nso007_products.delete', 0)
                    ->where(function ($q) use ($search) {
                        if ($search) {
                            $q->where('nso007_products.product_name', 'like', '%' . $search . '%');
                            $q->orwhere('nso007_stocks.item_code', 'like', '%' . $search . '%');
                        }
                    })
                    ->selectRaw('sum(nso007_stocks.stock_qty/nso007_product_unit.qty_per_unit) as total_stock,
                                        nso007_product_unit.qty_per_unit,
                                        nso007_products.image,
                                        nso007_products.product_name,
                                        nso007_products.id,
                                        nso007_product_unit.barcode
                                        ')
                    ->groupBy('nso007_products.id')
                    ->paginate(20);
                $html = view('pos.pos-retail.result-create', compact('stock_item'))->render();
                return response()->json(['html' => $html]);
            }
            $acc_chart = AccountChartModel::whereIn('id', ['11001', '11002'])->pluck((if_kh() ? 'acc_namekh' : 'acc_name'), 'id');
            return view('pos.pos-retail.create', compact('acc_chart'));
        }

        public function store(Request $request, $edit = null)
        {
            if (!$edit) {
                $check1 = $request['payment_type'] === 'pay_now' ? 'required' : 'nullable';
                $this->validate($request, [
                    'customer_id' => 'required|exists:nso007_customers,id',
                    'qty.*' => 'required|min:1|not_in:0',
                    'qty' => 'required',
                    'price.*' => 'required|min:1|not_in:0',
                    'payment_type' => 'required',
                    'payment_method' => $check1,
                    'note' => 'max:250',
                ]);
            }
            $branch_id = FindBranchID();
            $paid_total_us = floatval($request['paid_usd']);
            $grand_total = $request['grand_total'];
            $user_id = Auth::id();
            $sale_date = sDate($request->date) . ' ' . date('H:i:s');
            if ($paid_total_us >= $grand_total) {
                $payment_status = 'paid';
            } else {
                if ($paid_total_us > 0) {
                    $payment_status = 'partial';
                } else {
                    $payment_status = 'due';
                }
            }
            if (!$edit) {$ref = refNumber(Auth::id());}else{$ref=$edit->reference_number;}
            if ($edit) {
                $receipt = $edit->receipt_number;
                $inv = $edit->invoice_number;
            }else{
                if ($payment_status === 'paid') {
                    $receipt = refNumber(Auth::id(), 'receipt', 'RC');
                    $inv='';
                } else {
                    $inv = refNumber(Auth::id(), 'invoice', 'INV');
                    $receipt = '';
                }
            }
            $file = $request['reference'];
            $hasData = 0;

            if($file){foreach ($file as $row) {if ($row) {$hasData++;}}}

            if ($request['payment_type'] === 'pay_later') {$payment_method = '11003';} else {$payment_method = $request['sub_payment_method'] ?? $request['payment_method'];}
            $stock_check = [];
            if (!$edit) {
                if ($request->product_unit_id) {
                    foreach ($request->product_unit_id as $key => $item) {
                        $product_unit = ProductUnitModel::find($item);
                        $product = ProductModel::find($product_unit->product_id);
                        $qty = $request['qty'][$key] * $product_unit->qty_per_unit;
                        $stock = StockModel::where('type', 'member')
                            ->where('product_unit_id', $item)
                            ->where('member_id', Auth::id())
                            ->first();
                        if ($stock) {
                            if ($stock->stock_qty < $qty) {
                                $stock_check[$product->product_name . $key] = $product->product_name . ' is not enough.';
                            }
                        }
                    }
                } else {
                    throw ValidationException::withMessages(['kk' => 'No Item']);
                }
                if (count($stock_check)) {
                    throw ValidationException::withMessages($stock_check);
                }
            }
            $pos = new SaleModel;
            $pos->reference_number = $ref ?: ($inv ?: ($receipt ?: ''));
            $pos->invoice_number = $inv;
            $pos->receipt_number = $receipt;
            $pos->user_id = $user_id;
            $pos->customer_id = $request->customer_id;
            $pos->payment_type = $request['payment_type'];
            $pos->payment_method = $payment_method;
            $pos->payment_status = $payment_status;
            $pos->year = date('Y');
            $pos->paid_amount_usd = $paid_total_us;
            $pos->sale_date = $sale_date;
            $pos->status = 1;
            $pos->rate = currencyExchange();
            $pos->note = $request['note'];
            $pos->subtotal = $request['subtotal'];
            $pos->grand_total = $request['grand_total'];
            $pos->remain = $request['owed_amount'];
            $pos->is_role = Auth::user()->user_type;
            $pos->sale_type = 'retail';
            $pos->type = 'pos';
            $pos->save();
            if ($hasData) {
                $delete = ImageModel::where(['model_id' => $edit['id'], 'model' => $pos->getTable()])->get();
                foreach ($delete as $key => $row) {
                    if ($row->logo) {
                        if (file_exists(public_path() . '/' . $row->logo)) {
                            unlink(public_path() . '/' . $row->logo);
                        }
                    }
                    $row->delete();
                }
                foreach ($file as $key => $row) {
                    if ($row) {
                        $original_name = Auth::user()->id . date('ymdhis') . $key . '.png';
                        $destinationPath = 'images/pos';
                        $row->move($destinationPath, $original_name);
                        $reference = $destinationPath . '/' . $original_name;
                        ImageModel::create(['model_id' => $pos->id, 'model' => $pos->getTable(), 'image' => $reference]);
                    }
                }

            } else {ImageModel::where(['model_id' => $edit['id'], 'model' => $pos->getTable()])->update(['model_id' => $pos->id]);}
            CustomerBranchModel::updateOrCreate([
                'customer_id' => $pos->customer_id,
                'branch_id' => $branch_id,
                'user_id' => $pos->user_id,
            ],[
                    'customer_id' => $pos->customer_id,
                    'branch_id' => $branch_id,
                    'user_id' => $pos->user_id,
                ]);
            $j = JournalModel::selectRaw("Max(journal_tran_id) as last_num")->first();

            foreach ($request->product_unit_id as $key => $item) {
                $product_unit = ProductUnitModel::find($item);
                $pos_detail = new SaleDetailsModel;
                $pos_detail->sale_id = $pos->id;
                $pos_detail->product_unit_id = $item;
                $pos_detail->unit_id = $request['unit'][$key];
                $pos_detail->qty = $request['qty'][$key];
                $pos_detail->shelf = $request['shelf'][$key];
                $pos_detail->currency_id = 2;
                $pos_detail->sale_price = $request['price'][$key];
                $pos_detail->dis = $request['item_discount'][$key];
                $pos_detail->total = $request['total_price'][$key];
                $pos_detail->last_stock = $stock->stock_qty;
                $pos_detail->save();

                adjStockMember(Auth::id(), $item, -$pos_detail->qty);
                //===================================== Account ========================================================
                $cog = CostOfSoldModel::where(['branch_id' => FindBranchID(), 'product_unit_id' => $pos_detail->product_id])->first();
                $product = getProductById($product_unit->product_id);
                createProductAccountChart($product);

                $product = getProductById($product_unit->product_id);

                $cost = $cog->cost ?? 0;
                if ((int)$pos_detail->unit_id !== (int)$product_unit->unit_id) {
                    $cost /= $product_unit->qty_per_unit;
                }
                if ($key === 0) {
                    $last_id = 0;
                } else {
                    $last_id = JournalModel::selectRaw("Max(journal_parentid) as last_num")->first();
                    $last_id = $last_id->last_num ?? 0;
                }
                // create account chat if doesn't existed

                createProductAccountChart($product);
                $journal = new JournalModel;
                $journal->branch_id = $branch_id;
                $journal->journal_parentid = $last_id;
                $journal->journal_type = 5;
                $journal->voucher_type = 1;
                $journal->journal_acccode = $product->acc_cost_of_good_sold;
                $journal->voucher_ref = "V-" . generate_voucher_number(($j->last_num + 1), 8);
                $journal->journal_des = 'Expense cost of goods sold ' . ($product->product_name ?? '') . '(' . ($product->item_code ?? '') . ')';
                $journal->journal_debit = $cost * $pos_detail->qty;
                $journal->journal_credit = 0;
                $journal->journal_tran_id = $j->last_num + 1;
                $journal->journal_transactiondate = $pos->sale_date;;
                $journal->journal_paydate = $pos->sale_date;;
                $journal->journal_currency = 2;
                $journal->transaction_type = $pos->sale_type;
                $journal->journal_referenceid = $pos->id;
                $journal->journal_by = \Auth::id();
                $journal->journal_reference_number = $pos->reference_number;

                $journal->save();

                $jj = JournalModel::select(DB::raw("Max(id) as last_id"))->first();
                $journal = new JournalModel;
                $journal->branch_id = $branch_id;
                $journal->journal_parentid = $jj->last_id;
                $journal->journal_type = 4;
                $journal->voucher_type = 1;
                $journal->journal_acccode = $product->acc_sale_revenue;
                $journal->voucher_ref = "V-" . generate_voucher_number(($j->last_num + 1), 8);
                $journal->journal_des = 'Sale Revenue ' . ($product->product_name ?? '') . '(' . ($product->item_code ?? '') . ')';
                $journal->journal_debit = 0;
                $journal->journal_credit = $pos_detail->sale_price * $pos_detail->qty;
                $journal->journal_tran_id = $j->last_num + 1;
                $journal->journal_transactiondate = $pos->sale_date;
                $journal->journal_paydate = $pos->sale_date;
                $journal->journal_currency = 2;
                $journal->transaction_type = $pos->sale_type;
                $journal->journal_referenceid = $pos->id;
                $journal->journal_by = \Auth::id();
                $journal->journal_reference_number = $pos->reference_number;
                $journal->save();

                $jj = JournalModel::select(DB::raw("Max(id) as last_id"))->first();
                $journal = new JournalModel;
                $journal->branch_id = $branch_id;
                $journal->journal_parentid = $jj->last_id;
                $journal->journal_type = 1;
                $journal->voucher_type = 1;
                $journal->journal_acccode = $product->acc_inventory;
                $journal->voucher_ref = "V-" . generate_voucher_number(($jj->last_num + 1), 8);
                $journal->journal_des = 'Inventory  ' . ($product->product_name ?? '') . '(' . ($product->item_code ?? '') . ')';
                $journal->journal_debit = 0;
                $journal->journal_credit = $cost * $pos_detail->qty;
                $journal->journal_tran_id = $j->last_num + 1;
                $journal->journal_transactiondate = $pos->sale_date;;
                $journal->journal_paydate = $pos->sale_date;;
                $journal->journal_currency = 2;
                $journal->transaction_type = $pos->sale_type;
                $journal->journal_referenceid = $pos->id;
                $journal->journal_by = \Auth::id();
                $journal->journal_reference_number = $pos->reference_number;
                $journal->save();

                // Have discount
                $sub_item_total = $pos_detail->sale_price * $pos_detail->qty;
                $dis = $sub_item_total * ($pos_detail->dis / 100);
                if ($pos_detail->dis) {
                    $jj = JournalModel::select(DB::raw("Max(id) as last_id"))->first();
                    $journal = new JournalModel;
                    $journal->branch_id = $branch_id;
                    $journal->journal_parentid = $jj->last_id;
                    $journal->journal_type = 4;
                    $journal->voucher_type = 1;
                    $journal->journal_acccode = '42000';
                    $journal->voucher_ref = "V-" . generate_voucher_number(($j->last_num + 1), 8);
                    $journal->journal_des = 'Discount ' . $product->product_name . ' ( ' . $pos_detail->dis . '% )';
                    $journal->journal_debit = 0;
                    $journal->journal_credit = -$dis;
                    $journal->journal_tran_id = $j->last_num + 1;
                    $journal->journal_paydate = $pos->sale_date;
                    $journal->journal_paydate = $pos->sale_date;
                    $journal->journal_currency = 2;
                    $journal->transaction_type = $pos->sale_type;
                    $journal->journal_referenceid = $pos->id;
                    $journal->journal_by = \Auth::id();
                    $journal->journal_reference_number = $pos->reference_number;
                    $journal->save();
                }
            }

            $payment = new PaymentModel;
            $payment->invoice_id = $pos->id;
            $payment->branch_id = $branch_id;
            $payment->customer_id = $pos->customer_id;
            $payment->user_id = $user_id;
            $payment->payment_invoice = $pos->receipt_number;
            $payment->payment_date = $pos->sale_date;
            $payment->payment_amount = $grand_total;
            $payment->paid_amount = $paid_total_us;
            $payment->payment_status = $payment_status;
            $payment->type = $pos->sale_type;
            $payment->year = date('Y');
            $payment->status = 1;
            $payment->save();

            $payment_datail = new PaymentDetailModel;
            $payment_datail->payment_id = $payment->id;
            $payment_datail->paid_amount = $paid_total_us;
            $payment_datail->payment_date = $pos->sale_date;
            $payment_datail->note = $pos->sale_type;
            $payment_datail->status = 1;
            $payment_datail->save();


            /* ====== Accounting ====== */
            $customerModel = CustomerModel::find($request->customer);

            $last_id_pos_clothes = $pos->id;
            $paid = $paid_total_us;
            $total = $grand_total;
            if ((double)$paid >= (double)$grand_total) {
                $journal = new JournalModel;
                $journal->branch_id = $branch_id;
                $journal->journal_parentid = 0;
                $journal->journal_type = 1;
                $journal->journal_acccode = $pos->payment_method;
                $journal->voucher_type = 1;
                $journal->voucher_ref = "V-" . generate_voucher_number(($j->last_num + 1), 8);
                $journal->journal_des = 'Cash on hand  ' . '(' . $pos->reference_number . ')';
                $journal->journal_debit = $total;
                $journal->journal_credit = 0;
                $journal->journal_tran_id = $j->last_num + 1;
                $journal->journal_transactiondate = $pos->sale_date;
                $journal->journal_paydate = $pos->sale_date;
                $journal->journal_currency = 2;
                $journal->transaction_type = $pos->sale_type;
                $journal->journal_referenceid = $last_id_pos_clothes;
                $journal->journal_reference_number = $pos->reference_number;
                $journal->journal_by = $user_id;
                $journal->save();
            } else {
                if ($payment_status == 'partial') {
                    $journal = new JournalModel;
                    $journal->branch_id = $branch_id;
                    $journal->journal_parentid = 0;
                    $journal->journal_type = 1;
                    $journal->journal_acccode = $pos->payment_method;
                    $journal->voucher_type = 1;
                    $journal->voucher_ref = "V-" . generate_voucher_number(($j->last_num + 1), 8);
                    $journal->journal_des = 'Cash on hand  ' . '(' . $pos->reference_number . ')';
                    $journal->journal_debit = $paid;
                    $journal->journal_credit = 0;
                    $journal->journal_tran_id = $j->last_num + 1;
                    $journal->journal_transactiondate = $pos->sale_date;
                    $journal->journal_paydate = $pos->sale_date;
                    $journal->journal_currency = 2;
                    $journal->transaction_type = $pos->sale_type;
                    $journal->journal_referenceid = $last_id_pos_clothes;
                    $journal->journal_reference_number = $pos->reference_number;
                    $journal->journal_by = $user_id;
                    $journal->save();

                    $jj1 = JournalModel::select(DB::raw("Max(id) as last_id"))->first();

                    $journal = new JournalModel;
                    $journal->branch_id = $branch_id;
                    $journal->journal_parentid = $jj1->last_id;
                    $journal->journal_type = 1;
                    $journal->journal_acccode = '11003';
                    $journal->voucher_type = 1;
                    $journal->voucher_ref = "V-" . generate_voucher_number(($j->last_num + 1), 8);
                    $journal->journal_des = '.Account Receivable ' . '(' . $inv . ')';
                    $journal->journal_debit = $total - $paid;
                    $journal->journal_credit = 0;
                    $journal->journal_tran_id = $j->last_num + 1;
                    $journal->journal_transactiondate = $pos->sale_date;
                    $journal->journal_paydate = $pos->sale_date;
                    $journal->journal_currency = 2;
                    $journal->transaction_type = $pos->sale_type;
                    $journal->journal_referenceid = $last_id_pos_clothes;
                    $journal->journal_reference_number = $pos->reference_number;
                    $journal->journal_by = $user_id;
                    $journal->save();
                }
                else {

                    $jj = JournalModel::select(DB::raw("Max(id) as last_id"))->first();

                    $journal = new JournalModel;
                    $journal->branch_id = $branch_id;
                    $journal->journal_parentid = $jj->last_id;
                    $journal->journal_type = 1;
                    $journal->journal_acccode = '11003';
                    $journal->voucher_type = 1;
                    $journal->voucher_ref = "V-" . generate_voucher_number(($j->last_num + 1), 8);
                    $journal->journal_des = 'Account Receivable ' . '(' . $inv . ')';
                    $journal->journal_debit = $total;
                    $journal->journal_credit = 0;
                    $journal->journal_tran_id = $j->last_num + 1;
                    $journal->journal_transactiondate = $pos->sale_date;
                    $journal->journal_paydate = $pos->sale_date;
                    $journal->journal_currency = 2;
                    $journal->transaction_type = $pos->sale_type;
                    $journal->journal_referenceid = $last_id_pos_clothes;
                    $journal->journal_reference_number = $pos->reference_number;
                    $journal->journal_by = $user_id;
                    $journal->save();
                }
            }
            // delivery Revenue
            if ($request->delivery_fee) {
                $jj = JournalModel::select(DB::raw("Max(id) as last_id"))->first();
                $journal = new JournalModel;
                $journal->branch_id = $branch_id;
                $journal->journal_parentid = $jj->last_id;
                $journal->journal_type = 4;
                $journal->voucher_type = 1;
                $journal->journal_acccode = $product->acc_sale_revenue;
                $journal->voucher_ref = "V-" . generate_voucher_number(($j->last_num + 1), 8);
                $journal->journal_des = 'Sale Revenue ' . '(Delivery Fee)';
                $journal->journal_debit = 0;
                $journal->journal_credit = $request->delivery_fee;
                $journal->journal_tran_id = $j->last_num + 1;
                $journal->journal_paydate = $pos->sale_date;
                $journal->journal_paydate = $pos->sale_date;
                $journal->journal_currency = 2;
                $journal->transaction_type = $pos->sale_type;
                $journal->journal_referenceid = $pos->id;
                $journal->journal_by = \Auth::id();
                $journal->journal_reference_number = $pos->reference_number;
                $journal->save();
            }

            // using point
            if ((int)$request->using_point) {
                if ($customerModel->new_customer === 1) { // for new customer
                    $jj = JournalModel::select(DB::raw("Max(id) as last_id"))->first();
                    $journal = new JournalModel;
                    $journal->branch_id = $branch_id;
                    $journal->journal_parentid = $jj->last_id;
                    $journal->journal_type = 2;
                    $journal->voucher_type = 1;
                    $journal->journal_acccode = $using_voucher_customer->acc_related_party ?? $customerModel->acc_related_party;
                    $journal->voucher_ref = "V-" . generate_voucher_number(($j->last_num + 1), 8);
                    $journal->journal_des = 'Related Party ' . '(' . ($customerModel->customer_name) . ') Used ' . $request->using_point . ' Point(s)';
                    $journal->journal_debit = (int)$request->using_point / 2;
                    $journal->journal_credit = 0;
                    $journal->journal_tran_id = $j->last_num + 1;
                    $journal->journal_transactiondate = $pos->sale_date;
                    $journal->journal_paydate = $pos->sale_date;
                    $journal->journal_currency = 2;
                    $journal->transaction_type = $pos->sale_type;
                    $journal->journal_referenceid = $pos->id;
                    $journal->journal_by = $user_id;
                    $journal->journal_reference_number = $pos->reference_number;
                    $journal->save();
                } else {// for old customer already have point
                    $jj = JournalModel::select(DB::raw("Max(id) as last_id"))->first();
                    $journal = new JournalModel;
                    $journal->branch_id = $branch_id;
                    $journal->journal_parentid = $jj->last_id;
                    $journal->journal_type = 2;
                    $journal->voucher_type = 1;
                    $journal->journal_acccode = '420001';
                    $journal->voucher_ref = "V-" . generate_voucher_number(($j->last_num + 1), 8);
                    $journal->journal_des = 'Sale Discount Saving Point ( $' . ((int)$request->using_point / 2) . ' )';
                    $journal->journal_debit = 0;
                    $journal->journal_credit = -(int)$request->using_point / 2;
                    $journal->journal_tran_id = $j->last_num + 1;
                    $journal->journal_transactiondate = $pos->sale_date;
                    $journal->journal_paydate = $pos->sale_date;
                    $journal->journal_currency = 2;
                    $journal->transaction_type = $pos->sale_type;
                    $journal->journal_referenceid = $pos->id;
                    $journal->journal_by = $user_id;
                    $journal->journal_reference_number = $pos->reference_number;
                    $journal->save();
                }

            }

            /* ====== End Account ====== */
            return response()->json(['pos_request_route' => route('get-maho-invoice',$pos->id) , 'status' => 'ok']);
        }

        public function show($id)
        {
            $pos = SaleModel::find($id);
            $pos_detail = SaleDetailsModel::where('sale_id', $id)->get();
            return view('pos.pos-retail.show', compact('pos', 'pos_detail'));
        }

        //Narak
        public function destroy($id, $delete_all = null, Request $request)
        {
            if (!$delete_all) {
                $this->validate($request, [
                    'reason' => 'required'
                ]);
            }
            $master = SaleModel::find($id);
            $detail = SaleDetailsModel::where('sale_id', $id)->get();
            foreach ($detail as $key => $value) {
                adjStockMember(Auth::id(),$value->product_unit_id,$value->qty);
            }
            $master->delete_reason = $request['reason'];
            $payment = PaymentModel::where('invoice_id', $id)->where('type', $master->sale_type)->first();
            PaymentDetailModel::where('payment_id', $payment->id)->delete();
            $payment->delete_at = date('Y-m-d H:i:s');
            $payment->update();
            JournalModel::where(['transaction_type' => $master->sale_type, 'journal_referenceid' => $id])->delete();
            if ($delete_all) {
                SaleDetailsModel::where('sale_id', $id)->delete();
                $master->delete();
            } else {
                $master->delete_at = date('Y-m-d H:i:s');
                $master->update();
            }
            return response()->json(['status' => 'ok']);
        }

        public function edit($id, Request $request)
        {
            $member = MemberModel::pluck('nso007_member.name', 'nso007_member.id');
            $branches = getBranch();
            $master = SaleModel::find($id);
            $detail = SaleDetailsModel::where('sale_id', $id)->get();

            if ($request->ajax()) {
                $stock_item = StockModel::
                where('nso007_stocks.warehouse_id', $master->warehouse_id)
                    ->join('nso007_product_unit', 'nso007_stocks.product_unit_id', 'nso007_product_unit.id')
                    ->join('nso007_products', 'nso007_product_unit.product_id', 'nso007_products.id')
                    ->leftJoin('nso007_unit', 'nso007_product_unit.unit_id', 'nso007_unit.id')
                    ->leftJoin('nso007_unit as sub', 'nso007_product_unit.sub_unit_id', 'sub.id')
                    ->groupBy('product_unit_id')
                    ->selectRaw('sum(stock_qty) as qty,
                                        sub.unit as sub,
                                        qty_per_unit,
                                        nso007_unit.unit as unit,
                                        image,
                                        product_name,
                                        nso007_product_unit.id,
                                        nso007_product_unit.barcode,
                                        stock_qty')
                    ->paginate(20);
                $html = view('pos.pos-retail.product', compact('stock_item'))->render();
                return response()->json(['html' => $html]);
            }
            $acc_chart = AccountChartModel::whereIn('id', ['11001', '11002'])->pluck((if_kh() ? 'acc_namekh' : 'acc_name'), 'id');

            return view('pos.pos-retail.edit', compact('master', 'member', 'branches', 'detail', 'acc_chart'));

        }

        public function update($id, Request $request)
        {
            $branch_id = $edit['branch_id'] ?? FindBranchID();
            $check1 = $request['payment_type'] === 'pay_now' ? 'required' : 'nullable';
            $this->validate($request, [
                'branch' => 'required',
                'customer' => 'required',
                'qty.*' => 'required',
                'qty' => 'required|min:1|not_in:0',
                'unit.*' => 'required',
                'price.*' => 'required|min:1|not_in:0',
                'invoice_reference' => $request->branch == $branch_id && !myBranch()->prefix ? ('required') : 'nullable',
                'payment_type' => 'required',
                'payment_method' => $check1,
                'paid_usd' => $check1,
                'note' => 'max:250',
                'get_point' => 'required',
                'customer_type' => 'required',
                'delivery_type' => 'required',
            ]);
            $check = SaleModel::where('reference_number', $request->invoice_reference)->where('id', '!=', $id)->first();
            if ($check) {
                throw ValidationException::withMessages(['field_name' => 'Reference Invoice already existed....']);
            }
            if (!$request->product_key) {
                throw ValidationException::withMessages(['kk' => 'No Item']);
            }

            $arr = [];
            $sale = (findSale($id));
            if ($sale) {
                $arr = $sale;
            }
            $this->destroy($id, 1, $request);
            $this->store($request, $arr);
            return response()->json(['route' => route('pos-retail.index') . '?pos_history=' . encrypt('history'), 'status' => 'ok']);
        }
    }
