<?php

namespace App\Http\Controllers\CRM;

use App\Model\CRMLeadModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Model\CRMTaskModel;
use Auth;
use Validator;

class CRMTaskController extends Controller
{
    public function create(Request $request)

    {
        $lead = CRMLeadModel::find($request->lead_id);
        return view('crm.task.create',compact('lead'));
    }

    public function edit(Request $request,$id)
    {
        $task = CRMTaskModel::find($id);
        $lead = CRMLeadModel::find($task->lead_id);
        return view('crm.task.edit',compact('task','lead'));
    }

    public function store(Request $request)
    {

        $this->validate($request, [
            'lead_id' => 'required',
            'date' => 'required',
//            'subject' => 'required|string',
            'task_type' => 'required',
//            'place' => $request['task_type'] == 'call_log' ? 'nullable' : 'required|string',
            'note' => 'nullable|max:250',
        ]);
        $task = new CRMTaskModel;
        $lead = CRMLeadModel::find($request['lead_id']);
        $user = findUser($lead->agent_id);
        $task->lead_id = $request['lead_id'];
        $task->agent_id = $lead->agent_id;
        $task->branch_id = $user->branch_id??0;
        $task->task_type = $request->task_type;
        $task->subject = $request->subject;
        $task->where = $request->place;
        $task->date = date('Y-m-d', strtotime($request->date));
        $task->note = $request->note;
        $task->save();
        return response()->json(['status' => 'ok','reload'=>1]);
    }

    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'date' => 'required',
//            'subject' => 'required|string',
            'task_type' => 'required',
//            'place' => $request['task_type'] == 'call_log' ? 'nullable' : 'required|string',
            'note' => 'nullable|max:250',
        ]);
        $task = CRMTaskModel::find($id);
        $task->task_type = $request->task_type;
        $task->subject = $request->subject;
        $task->where = $request->place;
        $task->date = date('Y-m-d', strtotime($request->date));
        $task->note = $request->note;
        $task->update();
        session()->put('success', 'Task update successfully');
        return response()->json(['status' => 'ok','reload'=>1]);

    }

    public function complete(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
            'outcome' => 'required|string',
            'percentage' => 'required|numeric',
            'note' => 'nullable|max:255',
        ]);
        $messages = [];
        if ($validator->fails()) {
            foreach ($validator->errors()->getMessages() as $item) {
                $messages[] .= $item[0];
            }
            return response()->json([$messages, 401]);
        } else {
            $call_log = CRMTaskModel::find($id);
            $call_log->out_come = $request->outcome;
            $call_log->result_percentage = $request->percentage;
            $call_log->result = $request->note;
            $call_log->complete_status = 1;
            $call_log->update();
            return response()->json([$call_log, 200]);
        }
    }
}
