<?php

namespace App\Http\Controllers\Branch;

use App\Http\Controllers\Controller;
use App\User;
use DataTables;
use Hash;
use Illuminate\Http\Request;
use Validator;

class SellerController extends Controller
{
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $data = User::where('is_role', 'seller')
                ->where('status', 1)
                ->orderBy('id', 'desc')
                ->paginate($request->record, ['*'], 'page', str_replace(',', '', $request->page));

            return DataTables::of($data->items())
                ->with([
                    "activePage" => $request->page,
                    "records" => $request->record,
                    "recordsTotal" => $data->total(),
                    "recordsFiltered" => $data->total(),
                    'totalPage' => $data->lastPage()
                ])
                ->editColumn('status', function ($action) {
                        $status  = '<span class="fa fa-circle text-'.($action->status?'success':'danger').'"></span>';
                        return $status;
                })
                ->addColumn('action', function ($action) {
                    return '<i href="javascript:;"
                                        data-url = "' . route("branch-seller.update", $action->id) . '"
                                        data-gender="' . $action->gender . '"
                                        data-email="' . $action->email . '"
                                        data-phone="' . $action->phone . '"
                                        data-name="' . $action->name . '"
                                        class="fa fa-pencil btn btn-sm btn-warning" title="Edit"></i>' . ' ' .
                        '<i href="javascript:;" data-url = "' . route("branch-seller.destroy", $action->id) . '" class="fa fa-trash btn btn-sm btn-danger" title="Delete"></i>';
                })
                ->addColumn('avartar', function ($action) {
                    if ($action->avartar) {
                        return '<a href="' . asset($action->avartar) . '"><image src="' . asset($action->avartar) . '" height="60px" /></a>';
                    }
                })
                ->addIndexColumn()
                ->rawColumns(['action', 'avartar','status'])
                ->make(true);
        }
        return view('branch.seller.index');
    }

    public function create()
    {
        //
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required|min:1|max:25|string',
            'phone' => 'required|numeric',
            'email' => 'required|email|unique:users,email',
            'password' => 'required|string|max:25|',
            'confirm_password' => 'required|string|max:25|same:password',
            'gender' => 'required|string',
            'description' => 'nullable|string|max:255',
        ]);

        $messages = [];
        if ($validator->fails()) {
            foreach ($validator->errors()->getMessages() as $item) {
                $messages[] .= $item[0];
            }
            return response()->json([$messages, 401]);
        } else {
            $user = new User;
            $user->branch_id = \Auth::user()->id;
            $user->is_role = 'Seller';
            $user->parent_id = \Auth::id();
            $user->gender = $request['gender'];
            $user->email = $request['email'];
            $user->phone = $request['phone'];
            $user->name = $request['name'];
            $user->status = 1;
            if ($file = $request->file('image')) {
                $original_name = 'SELLER' . date('ymdhis') . '.png';
                $destinationPath = 'images/upload';
                $file->move($destinationPath, $original_name);
                $user->avartar = $destinationPath . '/' . $original_name;
            }
            $user->password = Hash::make($request['password']);
            $user->save();

            // $seller_warehouse = new WarehouseModel();
            // $seller_warehouse->branch_id        =   $user->id;
            // $seller_warehouse->warehouse_name   =   $user->name;
            // $seller_warehouse->user_id          =   $user->id;
            // $seller_warehouse->save();

            return response()->json([$user, 200]);
        }
    }

    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    public function update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required|min:1|max:25|string',
            'phone' => 'required|numeric',
            'email' => 'required|email',
            'gender' => 'required|string',
            'description' => 'nullable|string|max:255',
        ]);

        $messages = [];
        if ($validator->fails()) {
            foreach ($validator->errors()->getMessages() as $item) {
                $messages[] .= $item[0];
            }
            return response()->json([$messages, 401]);
        } else {
            $user = User::find($id);
            $user->branch_id = \Auth::user()->id;
            $user->is_role = 'Seller';
            $user->parent_id = \Auth::id();
            $user->gender = $request['gender'];
            $user->email = $request['email'];
            $user->phone = $request['phone'];
            $user->name = $request['name'];
            $user->status = 1;
            if ($file = $request->file('image')) {
                $original_name = 'SELLER' . date('ymdhis') . '.png';
                $destinationPath = 'images/upload';
                $file->move($destinationPath, $original_name);
                $user->avartar = $destinationPath . '/' . $original_name;
            }
            if ($user->password) {
                $user->password = Hash::make($request['password']);
            }
            $user->save();
            return response()->json([$user, 200]);
        }
    }

    public function destroy($id)
    {
        User::findOrFail($id)->update(['status' => 0]);
        return response()->json(['', 200]);
    }
}
