<?php

    namespace App\Http\Controllers\Branch;

    use App\Model\product\ShelfModel;
    use App\Model\PurchaseDetailsModel;
    use App\Model\PurchaseModel;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Http\Request;
    use App\Http\Controllers\Controller;
    use App\Model\stock_inventory\ItemRequestDetailModel;
    use App\Fun\Fun;
    use App\Model\stock_inventory\ItemRequestModel;
    use App\Model\ProductModel;
    use App\Model\ProductUnitModel;
    use App\Model\StockModel;
    use App\Model\WarehouseModel;
    use Illuminate\Support\Facades\DB;
    use Illuminate\Validation\ValidationException;
    use Yajra\DataTables\DataTables;
    use Auth;

    class RequestStockController extends Controller
    {
        public function index(Request $request)
        {
            if ($request->ajax()) {
                Fun::lang();
                $type = $request->type;
                $search = $request->input('search.value');

                $data = ItemRequestModel::
                where(function ($q) use ($type) {
                    if ($type === 'to') {
                        $q->where('member_id', Auth::user()->id);
                    } else {
                        $q->where('request_to', Auth::user()->id);
                        $q->orwhere('request_to', FindBranchID());
                    }
                })
                    ->where(function ($query) use ($search) {
                        $query->orWhere('nso007_item_request.reference_number', 'LIKE', '%' . $search . '%');
                    })->latest();
                $count_filter = $data->count();
                if ($request->isMethod('get')) {
                    return DataTables::of($data->take(20))
                        ->with([
                            "recordsTotal" => $count_filter,
                            "recordsFiltered" => $count_filter,
                        ])
                        ->editColumn('request_date', function ($item) {
                            return myDate($item->request_date);
                        })
                        ->editColumn('status', function ($item) {
                            return textStatus($item->status);
                        })
                        ->editColumn('member_id', function ($item) {
                            $user = findUser($item->member_id);
                            return $user ? $user->name : '';
                        })
                        ->editColumn('approve_by', function ($item) {
                            $user = findUser($item->approve_by);
                            return $user ? $user->name : '';
                        })
                        ->editColumn('approve_date', function ($item) {
                            if ($item->approve_date)
                                return myDate($item->approve_date, 1);
                        })
                        ->editColumn('request_to', function ($item) {

                            return $item->request_to_type === 'member' ? (findUser($item->request_to)->name ?? '') : (findBranch($item->request_to)->name ?? '');
                        })
                        ->editColumn('confirm_status', function ($item) {
                            return textStatus($item->confirm_status);
                        })
                        ->addColumn('action', function ($item) {
                            $show_approve = 0;
                            $show_receive = 0;
                            if ((Auth::user()->branch_id === $item->request_to || Auth::id() === $item->request_to) && $item->status === 'pending') {
                                $show_approve = 1;
                            }
                            if (Auth::id() === $item->delivery_to_member && $item->status === 'approved' && $item->confirm_status === 'pending') {
                                $show_receive = 1;
                            }
                            $show_item = '<a
                            data-get_update_status_url="' . route('request-stock.get-update-status', $item->id) . '?if_approve=' . encrypt(1) . '"
                            data-update_status_url="' . route('request-stock.update-status', $item->id) . '?status=2"
                            data-confirm_url="' . route('request-stock-update-confirm', encrypt($item->id)) . '"
                            data-show_receive="' . $show_receive . '"
                            data-show_approve="' . $show_approve . '"
                            data-href="' . route("request-stock.show", $item->id) . '"
                            title="' . __('administrator.show') . '"
                            class="btn btn-info show_request btn-sm">' . __('administrator.show') . '</a>';
                            if ($item->status === 'pending' && (Auth::user()->id == $item->member_id)) {
                                $show_item .= ' <a href="' . route("request-stock.edit", $item->id) . '?if_approve=' . encrypt(0) . '"  title="' . __('administrator.edit') . '" class="btn btn-warning btn-sm">' . __('administrator.edit') . '</a>';
                            }
                            return $show_item;
                        })
                        ->addIndexColumn()
                        ->rawColumns(['action', 'status', 'confirm_status'])
                        ->make(true);
                }
            }
            return view('branch.item-request.index');
        }

        public function create(Request $request)
        {
            if($request['product_unit_id']){
                $member_shelf = ShelfModel::where('member_id', Auth::id())->first()->id ?? 0;
                $shelf = \App\Model\StockModel::join('nso007_product_unit', 'nso007_product_unit.id', 'nso007_stocks.product_unit_id')
                    ->join('nso007_shelf', 'nso007_shelf.id', 'nso007_stocks.shelf')
                    ->join('nso007_unit', 'nso007_unit.id', 'nso007_product_unit.unit_id')
                    ->selectRaw('CONCAT(nso007_shelf.name," | ",ROUND(nso007_stocks.stock_qty/nso007_product_unit.qty_per_unit),nso007_unit.unit) as name,
                    nso007_shelf.id,(nso007_stocks.stock_qty/nso007_product_unit.qty_per_unit) as stock_qty')
                    ->where(['nso007_stocks.product_unit_id' => $request['product_unit_id'], 'nso007_stocks.shelf' => $member_shelf])
                    ->first();

                return response()->json(['member_shelf'=>$member_shelf,'shelf'=>$shelf]);
            }
            $member_po = $request['poreq'] ? decrypt($request['poreq']) : '';
            $purchase_detail = PurchaseDetailsModel::where('purchase_id', $member_po)->get();
            return view('branch.item-request.create', compact('purchase_detail'));
        }

        public function store(Request $request)
        {
            return $this->update($request, null);
        }

        public function edit($id)
        {
            $master = ItemRequestModel::find($id);
            return view('branch.item-request.edit', compact('master'));
        }

        public function get_update_status($id)
        {
            $master = ItemRequestModel::find($id);
            return view('branch.item-request.approve', compact('master'));
        }

        public function update(Request $request, $id)
        {
            $this->validate($request, [
                'product_unit_id.*' => 'required',
                'qty.*' => 'required',
                'shelf.*' => 'required',
                'request_date' => 'required',
            ]);
            $product_unit_id = $request->product_unit_id;
            $qty = $request->qty;
            $cost = $request->cost;
            $parent = myParent();
            $delivery_to = PurchaseModel::find($request['poreq']);
            if ($delivery_to) {
                $delivery_to->status = 'processing';
                $delivery_to->update();
            }
            $delivery_to_member = $delivery_to->delivery_to_member ?? Auth::user()->id;
            if($delivery_to){
                $member_purchase_id = $delivery_to->member_purchase_id ?? $delivery_to->id;
                $first_purchase = findPurchase($member_purchase_id);
                if($first_purchase){
                    PurchaseDetailsModel::where('purchase_id', $first_purchase->id)->delete();
                }
            }else{
                $member_purchase_id = 0;
                $first_purchase = null;
            }

            $master = ItemRequestModel::UpdateOrCreate(['id' => $id], [
                'member_id' => Auth::user()->id,
                'delivery_to_member' => $delivery_to_member,
                'member_purchase_id' => $member_purchase_id,
                'member_shelf' => $request['shelf'] ? array_values($request['shelf'])[0] : '',
                'branch_id' => mainBranch()->id,
                'request_to' => $parent->id,
                'request_to_type' => $parent->type,
                'reference_number' => refNumber(mainBranch()->id, 'item_request', 'ITR'),
                'request_date' => sDate($request['request_date']),
                'year' => date('Y'),
                'note' => $request['note'],
                'status' => 'pending',
                'confirm_status' => 'pending',
            ]);
            if ($id) {
                ItemRequestDetailModel::where('request_id', $id)->delete();
            }
            foreach ($product_unit_id as $key => $value) {
                $detail = new ItemRequestDetailModel();
                $detail->request_id = $master->id;
                $detail->product_unit_id = $value;
                $detail->qty = $qty[$key];
                $detail->cost = $cost[$key];
                $detail->save();
                if($first_purchase){
                    $purchase_array['purchase_id'] = $first_purchase->id;
                    $purchase_array['product_unit_id'] = $detail->product_unit_id;
                    $purchase_array['qty'] = $detail->qty;
                    $purchase_array['deliver_qty'] = $detail->qty;
                    $purchase_array['store_qty'] = 0;
                    $purchase_array['cost'] = $detail->cost;
                    PurchaseDetailsModel::create($purchase_array);
                }
            }
            return response()->json(['status' => 'ok', 'route' => route('request-stock.index') . '?type=to']);
        }

        public function show($id)
        {
            $master = ItemRequestModel::find($id);
            $view = view('branch.item-request.show', compact('master'))->render();
            return response()->json(['view' => $view, 'status' => $master->status]);
        }

        public function update_status(Request $request, $id)
        {
            $master = ItemRequestModel::find($id);
            $purchase = findPurchase($master->member_purchase_id);
            $check_ = $master->request_to_type === 'branch';
            if ($request->status == 2) {
                $master->status = 'rejected';
                $master->update();
                session()->put('danger', 'Request was Rejected');
                return response()->json(['status' => 'ok']);
            } else {
                $this->validate($request, [
                    'detail_id' => 'required',
                    'shelf.*' => ($check_ ? 'required' : 'nullable'),
                ]);
                foreach ($request['product_unit_id'] as $key => $item) {
                    if (ifMember()) {
                        $stock = StockModel::where(['member_id' => Auth::id(), 'product_unit_id' => $item])->first();
                    } else {
                        $stock = StockModel::where(['shelf' => $request['shelf'][$key], 'product_unit_id' => $item, 'type' => 'admin'])->first();
                    }

                    $punit = ProductUnitModel::find($item);
                    $product = getProductById($punit->product_id)->product_name ?? '';
                    if (!$stock) {
                        throw ValidationException::withMessages(['field_name' => $product . ' | ' . $punit->item_code . ' don\'t have stock']);
                    }
                    if ($stock->stock_qty < $request['qty'][$key]) {
                        throw ValidationException::withMessages(['field_name' => $product . ' | ' . $punit->item_code . ' not enough qty']);
                    }
                }
                $shelf = $request->shelf;
                $master->status = 'approved';
                $master->approve_by = Auth::id();
                $master->approve_date = date('Y-m-d H:i:s');
                $master->update();

                //if purchase request
                if ($purchase) {
                    PurchaseModel::where('member_purchase_id', $purchase->id)->update(['confirm_receive' => 'received', 'status' => 'approved']);
                    PurchaseModel::where('id', $purchase->id)->update(['status' => 'approved', 'confirm_receive' => 'pending']);
                }
                //==========================


                foreach ($request->detail_id as $key => $row) {
                    $detail = ItemRequestDetailModel::find($row);
                    if (ifMember()) {
                        $shelf[$key] = null;
                    }
                    $detail->qty = $request->qty[$key];
                    $detail->shelf = $request['shelf'][$key];
                    $detail->update();
                    if ($check_) {
                        adjStockAdmin(mainBranch()->id, $request['shelf'][$key], $detail->product_unit_id, -$detail->qty);
                    } else {
                        adjStockMember($master->request_to, $detail->product_unit_id, -$detail->qty);
                    }
                }
                session()->put('success', 'Request was Approved');
                return response()->json(['status' => 'ok', 'route' => route('request-stock.index') . '?type=from']);
            }

        }

        public function request_stock_update_confirm(Request $request, $id)
        {
            if ($request->method() == 'GET') {
                $id = decrypt($id);
                $master = ItemRequestModel::find($id);
                return view('branch.item-request.confirm_receive', compact('master'));
            } else {
                $id = decrypt($id);
                $this->validate($request, [
                    'status' => 'required',
                    'detail_id.*' => 'required',
                    'qty.*' => 'required'
                ]);
                $status = $request->status;
                $status_text = $status == 1 ? 'received' : 'return';

                $request_stock = ItemRequestModel::find($id);
                $request_stock->confirm_status = $status_text;
                if ($status == 1) {
                    foreach ($request->detail_id as $key => $row) {
                        $request_detail = ItemRequestDetailModel::find($row);
                        $product_unit = ProductUnitModel::find($request_detail->product_unit_id);
                        $qty = $request->qty[$key];
                        adjStockMember($request_stock->member_id, $product_unit->id, $qty);
                    }
                }
                if ($status == 2) {
                    $request_detail = ItemRequestDetailModel::where('request_id', $id)->get();
                    foreach ($request_detail as $row) {
                        $product_unit = ProductUnitModel::find($row->product_unit_id);
                        $qty = $row->qty;
                        adjStockAdmin(mainBranch()->id, $request_stock->member_shelf, $product_unit->id, $qty);
                    }
                }
                $request_stock->update();
                session()->put('success', 'Item has been ' . $status_text . ' !!!');
                return response()->json(['status' => 'success', 'route' => route('request-stock.index') . '?type=to']);
            }

        }

        public function return_stock($id)
        {
            $request_stock_detail = getSaleDetail($id);
            foreach ($request_stock_detail as $key => $row) {
                $stock = StockModel::where([
                    'warehouse_id' => $row->warehouse_id,
                    'product_id' => $row->product_id,])->first();
                if ($stock->stock_qty >= $row->qty) {
                    $stock->stock_qty += $row->qty;
                    $stock->save();
                }
            }
            return response()->json(['status' => 'success']);
        }

    }
