<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;

use Illuminate\Foundation\Auth\AuthenticatesUsers;

use Illuminate\Http\Request;
use Auth;
use Illuminate\Support\Facades\Session;

class LoginController extends Controller
{

    use AuthenticatesUsers;

    protected function authenticated(Request $request, $user)
    {
        if ($user->status != 0) {
            $output = [
                'status' => 'success',
                'route' => route('app_dashboard'),
            ];
            return response()->json($output);
        } else {
            Auth::logout($request);
            $output = [
                'status' => 'fail',
                'route' => route('customer_login'),
            ];
            return response()->json($output);
            //Auth::logout($request);
        }
    }


    protected function validateLogin(Request $request)
    {
        $this->validate($request, [
            $this->username() => 'required',
            'password' => 'required|string',
            //    'g-recaptcha-response' => 'required|captcha',
        ]);
    }

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
//protected $redirectTo = '/admin';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {

        $this->middleware('guest', ['except' => 'logout']);
    }
}
