<?php

namespace App\Http\Controllers\Administrator\payment;

use Auth;
use App\Fun\Fun;
use App\Model\PaymentDetailModel;
use App\Model\PaymentModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Yajra\DataTables\DataTables;
use Illuminate\Support\Facades\Gate;
use App\User;
use App\Model\CustomerModel;

class SaleRequestPaymentController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:Sale Request Payment List', ['only' => ['index', 'getpayment']]);
        $this->middleware('permission:Sale Request Payment show', ['only' => ['show']]);
    }

    public function index(Request $request)
    {
        Fun::lang();
        $seller = PaymentModel::where('status', '1')->where('type', 'sale-request')->pluck('user_id');
        $seller = User::whereIn('id', $seller)->pluck('name', 'id');
        $customer = PaymentModel::where('type', 'sale-request')->pluck('customer_id');
        $customer = CustomerModel::whereIn('id', $customer)->pluck('customer_name', 'id');
        if ($request->ajax()) {
            $value = $request->value;
            $seller = $request->user_id;
            $from_date = $request->start_date;
            $to_date = $request->end_date;
            $status = $request->status;
            $customer = $request->customer_id;
            $count_total = PaymentModel::where('nso007_payment.type', 'sale-request')
                ->count();
            $count_filter = PaymentModel::select('nso007_payment.id')
                ->join('nso007_sales', 'nso007_sales.id', 'nso007_payment.invoice_id')
                ->where('nso007_payment.status', 1)
                ->where('nso007_payment.type', 'sale-request')
                ->where(function ($q) use ($value) {
                    if ($value) {
                        $q->where('nso007_sales.invoice_number', 'like', '%' . $value . '%');
                    }
                })
                ->where(function ($q) use ($from_date, $to_date) {
                    if ($from_date) {
                        $q->whereDate('nso007_payment.payment_date', '>=', date('Y-m-d', strtotime($from_date)));
                    }
                    if ($to_date) {
                        $q->whereDate('nso007_payment.payment_date', '<=', date('Y-m-d', strtotime($to_date)));
                    }

                })
                ->where(function ($q) use ($status) {
                    if ($status) {
                        $q->where('nso007_payment.payment_status', $status);
                    }
                })
                ->where(function ($q) use ($seller) {
                    if ($seller) {
                        $q->where('nso007_payment.user_id', $seller);
                    }
                })
                ->where(function ($q) use ($customer) {
                    if ($customer) {
                        $q->where('nso007_payment.customer_id', $customer);
                    }
                })
                ->count();
            $data = PaymentModel::select('nso007_sales.invoice_number', 'nso007_payment.*')
                ->join('nso007_sales', 'nso007_sales.id', 'nso007_payment.invoice_id')
                ->where('nso007_payment.status', 1)
                ->where('nso007_payment.type', 'sale-request')
                ->where(function ($q) use ($value) {
                    if ($value) {
                        $q->where('nso007_sales.invoice_number', 'like', '%' . $value . '%');
                    }
                })
                ->where(function ($q) use ($from_date, $to_date) {
                    if ($from_date) {
                        $q->whereDate('nso007_payment.payment_date', '>=', date('Y-m-d', strtotime($from_date)));
                    }
                    if ($to_date) {
                        $q->whereDate('nso007_payment.payment_date', '<=', date('Y-m-d', strtotime($to_date)));
                    }

                })
                ->where(function ($q) use ($status) {
                    if ($status) {
                        $q->where('nso007_payment.payment_status', $status);
                    }
                })
                ->where(function ($q) use ($seller) {
                    if ($seller) {
                        $q->where('nso007_payment.user_id', $seller);
                    }
                })
                ->where(function ($q) use ($customer) {
                    if ($customer) {
                        $q->where('nso007_payment.customer_id', $customer);
                    }
                })
                ->orderBy('nso007_payment.created_at', 'DESC')
                ->take(20);
            return DataTables::of($data)
                ->with([
                    "recordsTotal" => $count_total,
                    "recordsFiltered" => $count_filter,
                ])
                ->editColumn('payment_date', function ($data) {
                    return date('d-m-Y', strtotime($data->payment_date));
                })
                ->editColumn('user_id', function ($data) {
                    return findUser($data->user_id)->name;
                })
                ->editColumn('customer_name', function ($data) {
                    return findCustomer($data->customer_id)->customer_name;
                })
                ->editColumn('customer_phone', function ($data) {
                    return findCustomer($data->customer_id)->customer_phone;
                })
                ->editColumn('payment_amount', function ($data) {
                    return '$' . number_format($data->payment_amount, 2);
                })
                ->editColumn('paid_amount', function ($data) {
                    return '$' . number_format($data->paid_amount, 2);
                })
                ->editColumn('remain', function ($data) {
                    return '$' . number_format($data->payment_amount - $data->paid_amount, 2);
                })
                ->editColumn('payment_status', function ($data) {
                    $bg = '';
                    if ($data->payment_status == 'due') {
                        $bg = 'danger';
                    }
                    if ($data->payment_status == 'partial') {
                        $bg = 'warning';
                    }
                    if ($data->payment_status == 'paid') {
                        $bg = 'success';
                    }
                    return '<span class="label label-' . $bg . '">' . __('administrator.' . $data->payment_status) . '</span>';
                })
                ->addColumn('action', function ($data) {
                    $btn = '';
                    if (strtolower($data->payment_status) != 'paid') {
                        $btn .= ' <a  title="' . __('administrator.add_payment') . '" class="btn bg-olive btn-flat margin btn_add_payment"  data-id="' . $data->id . '">' . __('administrator.add_payment') . '</a>';
                    }
                    if (Gate::check('Sale Request Payment show')) {
                        $btn .= '<a href="' . route("payment-sale-request.show", $data->id) . '" title="' . __('administrator.show') . '" class="button_info">' . __('administrator.show') . '</a>';
                    }

                    return $btn;
                })
                ->addIndexColumn()
                ->rawColumns(['action' => 'action', 'payment_status' => 'payment_status', 'customer_name' => 'customer_name', 'customer_phone' => 'customer_phone', 'remain' => 'remain',])
                ->make(true);
        }
        return view('administrator.payment.sale-request.index', compact('seller', 'customer'));
    }

    public function show($id)
    {
        $master = PaymentModel::find($id);
        $detail = PaymentDetailModel::where('payment_id', $id)->get();
        return view('administrator.payment.sale-request.show', compact('master', 'detail'));
    }

    public function get_payment($id)
    {
        $payment = PaymentModel::find($id);

        $std = new \stdClass();
        $std->remain = number_format(($payment->payment_amount - $payment->paid_amount), 2);

        $std->invoice = findSale($payment->invoice_id)->invoice_number;

        $std->payment_id = $payment->id;
        return view('administrator.payment.add-payment', compact('std'));

    }

    public function add_payment(Request $request)
    {
        $this->validate($request, [
            'amount' => 'required|numeric',
            'payment_id' => 'required',
            'date' => 'required',
        ]);
        $payment = PaymentModel::find($request->payment_id);

        $pos = findSale($payment->invoice_id);
        $pos->paid_amount_usd += $request->amount;

        $payment->paid_amount += $request->amount;

        $payment->payment_status = 'partial';
        if ($payment->paid_amount >= $payment->payment_amount) {
            $payment->payment_status = 'paid';
            $pos->payment_status = 'paid';
        }
        $payment->update();
        $pos->update();
        $payment_detail = new PaymentDetailModel();
        $payment_detail->payment_id = $payment->id;
        $payment_detail->paid_amount = $request->amount;
        $payment_detail->payment_date = $request->date;
        $payment_detail->note = $request->note;
        $payment_detail->status = 1;
        $payment_detail->save();
        return response()->json(['status' => 'alert']);
    }
}
