<?php

namespace App\Http\Controllers\Administrator;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Model\SupplierTypeModel;
use App\Model\SupplierModel;
use DB;
use Image;
use DataTables;
use App\Model\PurchaseModel;
use Session;
use App\Model\PurchaseDetailsModel;

class SupplierController extends Controller

{
    function __construct()
    {
       $this->middleware('permission:Supplier Create', ['only' => [ 'create','store']]);
       $this->middleware('permission:Supplier List', ['only' => ['index']]);
       $this->middleware('permission:Supplier Edit', ['only' => ['edit']]);
    }
    public function index()
    {
        $data = SupplierModel::paginate(20);
         return view('administrator.supplier.index',compact('data'));
    }
    public function create()

    {
        return view('administrator.supplier.create');
    }

    public function store(Request $request)
    {
        return $this->update($request,null);
    }
    public function edit($id)

    {
        $supplier = SupplierModel::find($id);
        return view('administrator.supplier.edit',compact('supplier'));
    }

    public function update(Request $request, $id)

    {
        $this->validate($request, [
            'name'      => 'required',
            'phone'      => 'required',
        ]);
        $master=SupplierModel::UpdateOrCreate(['id'=>$id],$request->all());
        if($request['input_name']){
            return response()->json(['value'=>$master->id,'text'=>$master->name,'input_name'=>$request['input_name']]);
        }
        return response()->json(['status'=>'ok','reload'=>1]);
    }


}

