<?php

namespace App\Http\Controllers\Administrator;


use Illuminate\Http\Request;

use App\Http\Controllers\Controller;

use session;

use DB;

use Auth;

use yajra\Datatables\Datatables;

use App\Model\SupplierTypeModel;

use App\Model\SupplierModel;

use App\Model\ProductModel;

use App\Model\PurchaseDetailsModel;

use App\Model\PurchaseModel;

use App\Model\StockModel;

class ReportPurchaseDetailController extends Controller

{

    // function __construct()

    // {
    //  $this->middleware('permission:Report Purchase List', ['only' => ['index']]);
    // }

    public function index(Request $request)
    {

        $supplier = PurchaseModel::where('status', 1)->pluck('supplier_id');
        $supplier = SupplierModel::whereIn('id',$supplier)->pluck('supplier_name','id');
        $type = PurchaseModel::groupBy('type')->pluck('type', 'type');
        $product = PurchaseDetailsModel::where('status',1)->pluck('product_id');
        $product = ProductModel::whereIn('id',$product)->pluck('product_name','id');
        if($request->ajax()) {
        $search = $request->input('search.value');
        $type = $request->type;
        $supplier = $request->supplier_id;
        $product = $request->product_id;
        $from_date = $request->start_date;
        $to_date = $request->end_date;
        $count_total = PurchaseDetailsModel::select('nso007_purchases.invoice_number')
            ->join('nso007_purchases','nso007_purchases.id','nso007_purchase_details.purchase_id')
            ->where(['nso007_purchases.status' => 1])
            ->count();
        $data = PurchaseDetailsModel::select('nso007_purchases.invoice_number','nso007_purchases.supplier_id','nso007_purchases.purchase_date','nso007_purchases.type','nso007_purchase_details.*')
            ->join('nso007_purchases','nso007_purchases.id','nso007_purchase_details.purchase_id')
            ->where(['nso007_purchases.status' => 1])
            ->where(function ($query) use ($supplier){
                if($supplier){
                    $query->where('nso007_purchases.supplier_id',$supplier);
                }
            })
            ->where(function ($query) use ($from_date, $to_date) {
                if ($from_date) {
                    $query->whereDate('nso007_purchases.purchase_date', '>=', date('Y-m-d', strtotime($from_date)));
                }
                if ($to_date) {
                    $query->whereDate('nso007_purchases.purchase_date', '<=', date('Y-m-d', strtotime($to_date)));
                }
            })
            ->where(function ($query) use ($product){
                if($product){
                    $query->where('nso007_purchase_details.product_id',$product);
                }
            })
            ->where(function ($query) use ($type){
                if($type){
                    $query->where('nso007_purchases.type',$type);
                }
            })
            ->where(function ($query) use ($search) {
                if ($search) {
                    $query->where('nso007_purchases.invoice_number', 'like', '%' . $search . '%');
                    $query->orwhere('nso007_purchase_details.barcode', 'like', '%' . $search . '%');
                }
            })
            ->orderBy('nso007_purchases.id', 'DESC');
        $count_filter = $data->count();
            return Datatables::of($data->take(10))
                ->with([

                    "recordsTotal" => $count_total,
                    "recordsFiltered" => $count_filter,

                ])
                ->addColumn('amount', function ($purchaseDetail) {
                    $amount= $purchaseDetail->qty*$purchaseDetail->cost;
                    return  '$' . number_format(($amount), 2);

                })
                ->addColumn('cost', function ($purchaseDetail) {
                    $currency = findCurrency(getProductById($purchaseDetail->product_id)->currency);
                    return $currency->symbol. number_format($purchaseDetail->cost, 2);
                })
                ->addColumn('type', function ($purchaseDetail) {
                    return __('administrator.'.$purchaseDetail->type);

                })
                ->addColumn('purchase_date', function ($purchaseDetail) {

                    return date('d-m-Y', strtotime($purchaseDetail->purchase_date));

                })

                ->editColumn('product_id', function ($purchaseDetail) {

                    return getProductById($purchaseDetail->product_id)->product_name;

                })
                ->editColumn('supplier_id', function ($purchaseDetail) {

                    return findSupplier($purchaseDetail->supplier_id)->supplier_name;

                })
                ->editColumn('supplier_phone', function ($purchaseDetail) {

                    return findSupplier($purchaseDetail->supplier_id)->supplier_phone;

                })
                ->addColumn('invoice_number', function ($purchaseDetail) {

                    return $purchaseDetail->invoice_number;

                })
                ->addColumn('qty', function ($purchaseDetail) {

                    return $purchaseDetail->qty.' '.findUnit($purchaseDetail->unit_id)->unit_name_en;

                })
                ->addColumn('dis', function ($purchaseDetail) {

                    return $purchaseDetail->dis.'%';

                })

                ->addColumn('action', function ($purchaseDetail) {

                })
                ->addIndexColumn()
                ->rawColumns(['invoice_number' => 'invoice_number', 'action' => 'action', 'supplier_phone' => 'supplier_phone'])
                ->make(true);

        }

        return view('administrator.report-purchase-detail.index',compact('type','supplier','product'));

    }



}

