<?php

    namespace App\Http\Controllers\Administrator;


    use Illuminate\Http\Request;

    use App\Http\Controllers\Controller;

    use session;

    use DB;

    use Auth;

    use DataTables;

    use App\Model\SupplierTypeModel;

    use App\Model\SupplierModel;

    use App\Model\ProductModel;


    use App\Model\PurchaseModel;

    use App\Model\StockModel;
    use App\Fun\Fun;
    use App\Model\WarehouseModel;
    use App\Model\ProductUnitModel;
    use Carbon\Carbon;

    class ReportPurchaseController extends Controller

    {
        function __construct()

        {
            $this->middleware('permission:Report Purchase', ['only' => ['index']]);
        }

        public function index(Request $request)
        {
            if ($request->ajax()) {
                $user_id = Auth::id();
                $data = PurchaseModel::with('detail')
                    ->where('status', 'approved')
                    ->where(function ($q) use($user_id) {
                        if (!ifMember()) {
                            $q->where('request_to', FindBranchID());
                            $q->orwhere('request_to', $user_id);
                            $q->orwhere('branch_id', FindBranchID());
                        }else{
                            $q->where('user_id', $user_id);
                            $q->orwhere('request_to', $user_id);
                        }
                    })
                    ->where(function ($q) use ($request) {
                        if ($request->invoice_number) {
                            $q->where('invoice_number', 'like', '%' . $request->invoice_number . '%');
                        }
                        if ($request->payment_status) {
                            $q->where('payment_status', 'like', '%' . $request->payment_status . '%');
                        }
                        if ($request->created_at) {
                            $q->whereDate('purchase_date', $request->created_at);
                        }
                    })
                    ->orderBy('id', 'desc')
                    ->take(20);
                return DataTables::of($data)
                    ->with([
                        "recordsTotal" => $data->count(),
                        "recordsFiltered" => $data->count(),
                    ])
                    ->editColumn('payment_status', function ($action) {
                        return textStatus($action->payment_status);
                    })
                    ->editColumn('invoice_number', function ($action) {
                        return '<a data-href="'.route('purchases-item.show',$action->id).'" class="getHtmlFormShow" data-width="700px"><u>'.$action->invoice_number.'</u></a>';
                    })
                    ->editColumn('paid_usd', function ($action) {
                        return number_format($action->paid_usd, 2) . '$';
                    })
                    ->addColumn('total', function ($action) {
                        return number_format($action->grand_total, 2) . '$';
                    })
                    ->addColumn('total_qty', function ($action) {
                        return $action->detail->sum('qty').' ឯកតា';
                    })
                    ->addColumn('remain_amount', function ($action) {
                        $total = $action->grand_total - $action->paid_usd;
                        return number_format($total, 2) . '$';
                    })
                    ->addIndexColumn()
                    ->rawColumns(['payment_status','total_qty','invoice_number'])
                    ->make(true);
            }
            return view('administrator.reportpurchases.index');
        }


    }

