<?php


namespace App\Http\Controllers\Administrator;


use App\BranchModel;
use App\Model\ImageModel;
use App\Model\ItemRequestDetailModel;
use App\Model\ProductModel;
use App\Http\Controllers\Controller;
use App\Model\CustomerModel;
use App\Model\purchase_order\PurchaseOrderDetailModel;
use App\Model\PurchaseDetailsModel;
use App\Model\SaleDetailsModel;
use App\Model\SaleModel;
use DB;
use Auth;
use Illuminate\Http\Request;


class DashboardAdministratorController extends Controller

{

    public function index()
    {
        $total_customer = 0;
        $total_partner = BranchModel::where('type', 'partner')->count();
        $total_dealer = BranchModel::where('type', 'dealer')->count();
        $all_item = ProductModel::where(['status' => 1,'delete'=>0])->count();
        return view('administrator.dashboard-administrator', compact('all_item', 'total_customer', 'total_partner', 'total_dealer'));
    }

    public function sale_purchase()
    {
        $myBranch = myBranch();
        $stock_in = PurchaseDetailsModel::join('nso007_purchases as p', 'p.id', 'nso007_purchase_details.purchase_id')
            ->join('nso007_product_unit as pu', 'pu.id', 'nso007_purchase_details.product_unit_id')
            ->where(function ($q) use ($myBranch) {
                $q->where('p.branch_id', $myBranch->id);
            })
            ->selectRaw('
            SUM(case when nso007_purchase_details.unit_id = pu.sub_unit_id then (nso007_purchase_details.qty/pu.qty_per_unit) else nso007_purchase_details.qty end) as in_qty,
            SUM(nso007_purchase_details.qty*nso007_purchase_details.cost-(nso007_purchase_details.qty*nso007_purchase_details.cost*(if(nso007_purchase_details.dis,nso007_purchase_details.dis,0))/100)) as total_cost
            ')
            ->first();
        $stock_out = SaleDetailsModel::join('nso007_sales as p', 'p.id', 'nso007_sale_details.sale_id')
            ->join('nso007_product_unit as pu', 'pu.id', 'nso007_sale_details.product_id')
            ->where(function ($q) use ($myBranch) {
                $q->where('p.branch_id', $myBranch->id);
            })
            ->selectRaw('
            SUM(case when nso007_sale_details.unit_id = pu.sub_unit_id then (nso007_sale_details.qty/pu.qty_per_unit) else nso007_sale_details.qty end) as out_qty,
            SUM(nso007_sale_details.qty*nso007_sale_details.sale_price-(nso007_sale_details.qty*nso007_sale_details.sale_price*(if(nso007_sale_details.dis,nso007_sale_details.dis,0))/100)) as total_cost
            ')
            ->first();
        return response()->json(['stock_in'=>$stock_in,'stock_out'=>$stock_out]);
    }

    public function pos_request_stock_request()
    {
        $myBranch = myBranch();
        $sale_request = PurchaseOrderDetailModel::join('nso007_purchase_order as p', 'p.id', 'nso007_purchase_order_detail.purchase_order_id')
            ->join('nso007_product_unit as pu', 'pu.id', 'nso007_purchase_order_detail.product_unit_id')
            ->where(function ($q) use ($myBranch) {
                $q->where('p.request_to', $myBranch->id);
            })
            ->selectRaw('
            SUM(case when nso007_purchase_order_detail.unit_id = pu.sub_unit_id then (nso007_purchase_order_detail.qty/pu.qty_per_unit) else nso007_purchase_order_detail.qty end) as request_qty
            ')
            ->first();

        $stock_request = DB::table('nso007_item_request_detail')
            ->join('nso007_item_request as p', 'p.id', 'nso007_item_request_detail.request_id')
            ->join('nso007_product_unit as pu', 'pu.id', 'nso007_item_request_detail.product_unit_id')
            ->where(function ($q) use ($myBranch) {
                $q->where('p.branch_id', $myBranch->id);
            })
            ->selectRaw('
             SUM(case when nso007_item_request_detail.unit_id = pu.sub_unit_id then (nso007_item_request_detail.qty/pu.qty_per_unit) else nso007_item_request_detail.qty end) as request_qty
            ')
            ->first();
        $sale_request = $sale_request->request_qty??0;
        $stock_request = $stock_request->request_qty??0;
        return response()->json(['sale_request'=>$sale_request,'stock_stock'=>$stock_request]);
    }

    public function sidebar_mini(Request $request)
    {
        if ($request->data == 'true') {
            session()->put('sidebar_collapse', 'sidebar-collapse');
        } else {
            session()->put('sidebar_collapse', '');
        }
    }

    public function get_image(Request $request)
    {
        $image = ImageModel::where(['model' => $request->model, 'model_id' => $request->model_id])->pluck('image');
        return view('administrator.view-image', compact('image'));
    }

    public function get_income_statement()
    {
        $journal_revenue = DB::table('nso007_journal as jn')
            ->join('nso007_account_chart as chart', 'chart.id', '=', 'jn.journal_acccode')
            ->selectRaw('SUM(jn.journal_credit-jn.journal_debit) AS balance,(DATE_FORMAT(jn.journal_paydate, "%Y")) as year')
            ->where('chart.acctype', 'LIKE', "4%")
            ->where(function ($query) {
                $query->where('jn.branch_id', FindBranchID());
            })
            ->whereBetween('jn.journal_paydate', [ date('Y-m-').'01', date('Y-m-d')])
            ->groupBy(DB::raw("DATE_FORMAT(jn.journal_paydate, '%Y')"))
            ->pluck('balance','year');
        $journal_expense = DB::table('nso007_journal as jn')
            ->join('nso007_account_chart as chart', 'chart.id', '=', 'jn.journal_acccode')
            ->selectRaw('SUM(jn.journal_debit-jn.journal_credit) AS balance,(DATE_FORMAT(jn.journal_paydate, "%Y")) as year')
            ->where('chart.acctype', 'LIKE', "5%")
            ->where(function ($query) {
                $query->where('jn.branch_id', FindBranchID());
            })
            ->whereBetween('jn.journal_paydate', ['2020-11-01', date('Y-m-d')])
            ->groupBy(DB::raw("DATE_FORMAT(jn.journal_paydate, '%Y')"))
            ->pluck('balance','year');
        $year = [];
        $revenue = [];
        $net_income = [];
        foreach ($journal_revenue as $key=>$row){
            $year[] = $key;
            $revenue[] = $row;
            $net_income[] = $row-$journal_expense[$key];
        }
        return response()->json(['year'=>$year,'revenue'=>$revenue,'net_income'=>$net_income,]);
    }


}

