<?php

namespace App\Http\Controllers\Administrator;

use App\Fun\Fun;
use App\Http\Controllers\Controller;
use App\Model\CustomeCaseModel;
use App\Model\CustomerBranchModel;
use App\Model\CustomerIllnessModel;
use App\Model\CustomerModel;
use App\Model\ImageModel;
use App\Model\location\ProvinceModel;
use App\Model\ProductModel;
use App\Model\purchase_order\PurchaseOrderModel;
use App\Model\SaleDetailsModel;
use App\Model\SaleModel;
use App\Model\setup\CustomerStatusModel;
use App\Model\setup\ReasonModel;
use App\Models\TypeOfIllness;
use App\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\DataTables;

class CustomerController extends Controller

{

    function __construct()
    {
        $this->middleware('permission:Customer Create', ['only' => ['create', 'store']]);
        $this->middleware('permission:Customer List', ['only' => ['index']]);
        $this->middleware('permission:Customer Edit', ['only' => ['update', 'edit']]);
        Fun::lang();
    }

    public function customer_dealer(Request $request, $type = '')
    {

        if ($request->ajax()) {
            $customers = CustomerModel::
            select('nso007_customers.*')
                ->where('nso007_customers.member_type_id', 2)
                ->where(function ($query) {
                    $query->where('nso007_customers.agent_id', Auth::id());
                })
                ->with([
                    'typeIllness' => function ($q) {
                        return $q->select('id', 'name_km', 'name_en');
                    },

                ]);
            // check if have only filter start date of register date
            if (isset($request->register_start_date) && !isset($request->register_end_date))
                $customers = $customers->whereDate('nso007_customers.register_date', $request->register_start_date);
            // check if have filter start date && end date of register date
            if (isset($request->register_start_date) && isset($request->register_end_date)) {
                $customers = $customers->whereBetween('nso007_customers.register_date', [date('Y-m-d', strtotime($request->register_start_date)), date('Y-m-d', strtotime($request->register_end_date))]);
            }
            // check if have only filter start date of birth
            if (isset($request->dob_start_date) && !isset($request->dob_end_date))
                $customers = $customers->whereDate('nso007_customers.date_of_birth', $request->dob_start_date);
            // check if have filter start date && end date of birth
            if (isset($request->dob_start_date) && isset($request->dob_end_date))
                $customers = $customers->whereBetween('nso007_customers.date_of_birth', [date('Y-m-d', strtotime($request->dob_start_date)) . ' 00:00:00', date('Y-m-d', strtotime($request->dob_end_date)) . ' 23:59:59']);

            if (isset($request->name))
                $customers = $customers->where('nso007_customers.customer_name', 'LIKE', '%' . $request->name . '%');

            if (isset($request->phone))
                $customers = $customers->where('nso007_customers.customer_phone', 'LIKE', '%' . $request->phone . '%');

            if (isset($request->sex))
                $customers = $customers->where('nso007_customers.sex', $request->sex);

            if (isset($request->age))
                $customers = $customers->where('nso007_customers.age', 'LIKE', '%' . $request->age . '%');

            if (isset($request->type_illness))
                $customers = $customers->where('nso007_customers.type_illness_id', $request->type_illness);

            if (isset($request->know_product_from))
                $customers = $customers->where('nso007_customers.known_this_from', $request->know_product_from);

            if (isset($request->agent_id))
                $customers = $customers->where('nso007_customers.agent_id', $request->agent_id);

            if (isset($request->customer_type))
                $customers = $customers->where('nso007_customers.customer_type', $request->customer_type);

            if (isset($request->type_of_customer))
                $customers = $customers->where('nso007_customers.type_of_customer', $request->type_of_customer);

            if (isset($request->user_insert_last_customer_case))
                $customers = $customers->where('nso007_customers.user_insert_last_customer_case', $request->user_insert_last_customer_case);

            if (isset($request->customer_status_id))
                $customers = $customers->where('nso007_customers.customer_status_id', $request->customer_status_id);

            if (isset($request->reason_id))
                $customers = $customers->where('nso007_customers.reason_id', $request->reason_id);

            if (isset($request->bach_number))
                $customers = $customers->where('nso007_customers.bach_number', 'like', '%' . $request->bach_number . '%');


            $customers->latest();

            return DataTables::of($customers->take(20))
                ->with([
                    "recordsTotal" => $customers->count(),
                    "recordsFiltered" => $customers->count(),
                ])
                ->addIndexColumn()
                ->addColumn('type_illness', function ($customer) {
                    if ($customer->type_illness) {
                        $ill = TypeOfIllness::whereIn('id', json_decode($customer->type_illness))->pluck(if_kh() ? 'name_km' : 'name_en');
                        $ill = $ill->implode(', ');
                        return $ill;
                    }
                })
                ->editColumn('reason_id', function ($customer) {
                    return ReasonModel::find($customer->reason_id)->reason??'';
                })
                ->editColumn('register_date', function ($customer) {
                    return  myDate($customer->register_date);
                })
                ->editColumn('date_of_birth', function ($date_of_birth) {
                    if ($date_of_birth->date_of_birth) {
                        return date('d-m-Y', strtotime($date_of_birth->date_of_birth));
                    }
                })
                ->addColumn('know_product_from', function ($customer) {
                    return $customer->known_this_from ? @know_product_from()[$customer->known_this_from] : '';
                })
                ->addColumn('agent_id', function ($customer) {
                    $user = findUser($customer->agent_id);
                    if ($user) {
                        return $user->name ?: $user->name_kh;
                    }
                })
                ->editColumn('status', function ($customer) {
                    $customer_status = CustomerStatusModel::find($customer->customer_status_id);
                    if($customer_status){
                        return $customer_status->name??'';
                    }

                })
                ->editColumn('sex', function ($customer) {
                    if ($customer->sex) {
                        return __('administrator.' . $customer->sex);
                    }

                })
                ->editColumn('customer_status_id', function ($customer) {
                    if ($customer->customer_status_id) {
                        return $customer->CustomerStatus->name ?? '';
                    }
                })
                ->editColumn('user_insert_last_customer_case', function ($customer) {
                    if ($customer->user_insert_last_customer_case) {
                        return $customer->user_insert_last->name ?? '';
                    }
                })
                ->addColumn('action', function ($customer) {

                    Fun::lang();
                    $action = '';
                    $cus_id = $customer->id;
                    $cus_br = $customer->agent_id ==Auth::id();
                    if (!$customer->deleted_at) {
                        $action .= '<a href="' . route("pos-retail.create") . '?hellowajitnomotocambo=hibbbyerequestbyeloveyou&customer=' . Crypt::encrypt($cus_id) . '"><i href="javascript:;" class="fa fa-shopping-cart btn btn-sm btn-success" title="POS"></i></a> ';
                        $action .= '<a href="' . route('customer_care.view', $cus_id) . '" class="btn btn-sm btn-primary" title="Customer Care" ><i class="fa fa-medkit" aria-hidden="true"></i></a>';
                    }
                    $action .= '&nbsp;<a href="' . route('customer.history', $cus_id) . '" class="btn btn-sm btn-info" >' . __('administrator.history') . '&nbsp;  <i class="fa fa-history" aria-hidden="true"></i></a>';
                    if (!$customer->deleted_at) {
                        if ($cus_br) {
                            $action .= '&nbsp;<a data-href="' . route('customer.edit', $cus_id) . '" class="  btn btn-sm btn-warning edit_customer"   title="' . __('administrator.edit') . ' ' . __('administrator.customer') . '">' . __('administrator.edit') . '</a>';
                        }
                        if ($cus_br && Auth::user()->can('Customer Delete')) {
                            $action .= '&nbsp;<a data-href="' . route('customer-delete', $cus_id) . '" class="btn btn-sm btn-danger btn-delete-customer" data-id="' . $cus_id . '">' . __('administrator.delete') . '</a>';
                        }
                    }
                    return $action;
                })
                ->rawColumns(['action'])
                ->make('true');
        }
        $user = CustomerModel::groupby('agent_id')->pluck('agent_id');
        $user = User::whereIn('id', $user)->pluck('name', 'id');
        $customer_status = CustomerStatusModel::pluck('name', 'id');
        return view('administrator.customers.admin_dealer', compact('user', 'customer_status'));
    }

    public function change_agent($id, Request $request)
    {
        if ($request->method() === "POST") {
            $this->validate($request, [
                'agent_id' => 'required'
            ]);
            $customer = CustomerModel::find($id);

            CustomeCaseModel::where(['customer_id' => $id])
                ->where(function ($q) use ($customer, $request) {
                    if ($customer->agent_id === Auth::user()->id) {
                        $q->where('user_created', $customer->agent_id);
                    }
                })
                ->update(['user_created' => $request->agent_id]);


            $customer->update($request->all());
            return response()->json(['status' => 'ok']);
        }
        $user = User::pluck('name', 'id');
        $customer = findCustomer($id);
        return view('administrator.customers.change-agent', compact('user', 'customer'));
    }

    public function history(Request $request, $id)
    {
        $array = [];
        $array1 = [];
        $url = route("customer.history", $id);
        $url_product = route("customer.product-history", $id);
        $customer = CustomerModel::find($id);
        $customer_case = CustomeCaseModel::where('customer_id', $id)->latest()->get();
        /////////////////////////////Product Buy///////////////////////////////////////
        $product = ProductModel::select('id', 'product_name AS label')->get();
        $year = date('Y');
        if ($request->date) {
            $year = $request->date;
        }
        if ($request->ajax()) {
            $data = SaleModel::
                leftJoin('nso007_payment as payment', 'nso007_sales.id', 'payment.invoice_id')
                ->where(function ($q) use ($id) {
                    $q->where('nso007_sales.customer_id', $id);
                    $q->orwhere('nso007_sales.using_voucher_customer', $id);
                })
                ->where(function ($q) use ($request) {
                    if (isset($request->sell_type)) {
                        $q->where('payment.payment_status', $request->sell_type);
                    }
                    if ($request->from_date) {
                        $q->where('nso007_sales.created_at', '>=', date('Y-m-d', strtotime($request->from_date)));
                    }
                    if ($request->to_date) {
                        $q->where('nso007_sales.created_at', '<=', date('Y-m-d', strtotime($request->to_date)));
                    }
                })
                ->selectRaw(
                    'nso007_sales.discount,
                nso007_sales.created_at,
                invoice_number,
                nso007_sales.id,
                nso007_sales.status,
                payment.payment_status,
                paid_amount_kh,
                paid_amount_usd,
                nso007_sales.points,
                nso007_sales.using_point,
                nso007_sales.balance_point,
                payment.id as payment_id,
                nso007_sales.reference_number,
                payment.payment_amount,
                payment.paid_amount as paid_payment_amount
            ')
                ->orderBy('id', 'desc')->paginate($request->record, ['*'], 'page', str_replace(',', '', $request->page));
            return DataTables::of($data->items())
                ->with([
                    "activePage" => $request->page,
                    "records" => $request->record,
                    "recordsTotal" => $data->total(),
                    "recordsFiltered" => $data->total(),
                    'totalPage' => $data->lastPage()
                ])
                ->addColumn('total', function ($action) {
                    $total = 0;
                    $sale_details = DB::table('nso007_sale_details')
                        ->where('sale_id', $action->id)
                        ->selectRaw('sale_price, dis, currency_id, qty, status')
                        ->get();
                    foreach ($sale_details as $sale_detail) {
                        if ($sale_detail->status != 0) {
                            $grand_total = ($sale_detail->sale_price * $sale_detail->qty) - (($sale_detail->sale_price * $sale_detail->qty) * ($sale_detail->dis / 100));
                            $grand_total = $sale_detail->currency_id == 1 ? $grand_total / currencyExchange() : $grand_total;
                            $total += $grand_total;
                        }
                    }
                    $total = $total - ($total * $action->discount / 100);
                    $total = $total - ($action->using_point / 2);
                    return number_format($total, 2) . '$';
                })
                ->addColumn('remain', function ($action) {
                    $total = ($action->payment_amount - $action->paid_payment_amount) > 0 ? ($action->payment_amount - $action->paid_payment_amount) : 0;
                    return $total . '$';
                })
                ->addColumn('date', function ($date) {
                    return date_format($date->created_at, 'd-m-Y H:i:s');
                })
                ->addIndexColumn()
                ->rawColumns(['action', 'payment_status', 'status'])
                ->make(true);
        }
        foreach ($product as $product_productkey2 => $product_val) {
            for ($i = 0; $i < 12; $i++) {
                $analysis_by_product = SaleModel::where('customer_id', $id)
                    ->join('nso007_sale_details', 'nso007_sale_details.sale_id', 'nso007_sales.id')
                    ->selectRaw('YEAR(nso007_sale_details.created_at) year,
                            MONTH(nso007_sale_details.created_at) as month,
                            nso007_sale_details.product_unit_id,
                            SUM(nso007_sale_details.qty * nso007_sale_details.sale_price) as total_qty,
                            count(nso007_sales.id) as data')
                    ->where('nso007_sale_details.product_unit_id', $product_val->id)
                    ->whereYear('nso007_sale_details.created_at', '=', $year)
                    ->having('month', $i + 1)
                    ->groupby('month')
                    ->first();

                $array_1[$i] = array("label" => FIndlMonth($i + 1), "y" => ($analysis_by_product == null ? 0 : $analysis_by_product->data));
                $array_2[$i] = array("date_x" => ($year . ',' . ($i) . ',01'), "date_Y" => ($analysis_by_product == null ? 0 : $analysis_by_product->total_qty));
            }
            $array[$product_val->label] = $array_1;
            $array1[$product_val->label] = $array_2;
        }
        $cus_img = ImageModel::where(['model_id' => $id, 'model' => 'customer'])->get();
        $po_file = PurchaseOrderModel::where(['customer_id' => $id])->get();
        $sale_file = ImageModel::join('nso007_sales', 'nso007_sales.id', 'nso007_images.model_id')
            ->select('nso007_sales.*', 'nso007_images.image')
            ->where('nso007_sales.customer_id', $id)
            ->where(['model' => 'nso007_sales'])
            ->get();
        return view('administrator.customers.history', compact('cus_img', 'array', 'customer', 'array1', 'id', 'url', 'year', 'url_product', 'customer_case', 'po_file', 'sale_file'));
    }

    public function product_history(Request $request, $id)
    {
        if ($request->ajax()) {
            $data = SaleDetailsModel::leftJoin('nso007_sales', 'nso007_sales.id', 'nso007_sale_details.sale_id')
                ->leftJoin('nso007_products', 'nso007_sale_details.product_unit_id', 'nso007_products.id')
                ->selectRaw(
                    'nso007_sales.invoice_number,nso007_products.product_name,SUM(nso007_sale_details.qty) as total_qty,nso007_sales.reference_number
            ')
                ->where('nso007_sales.customer_id', $id)
                ->groupBy('nso007_sale_details.product_unit_id');
            return DataTables::of($data->take(10))
                ->addColumn('date', function ($date) {

                })
                ->addIndexColumn()
                ->rawColumns(['action', 'payment_status', 'status'])
                ->make(true);
        }
    }

    public function create()
    {
        $province = ProvinceModel::pluck(if_kh() ? 'name_kh' : 'name_en', 'id');
        $illness_types = TypeOfIllness::whereNull('deleted_at')->pluck('name_km', 'id');
        return view('administrator.customers.create', compact('province', 'illness_types'));
    }

    public function store(Request $request)
    {
        return $this->update($request,null);
    }

    public function edit($id)
    {
        $customer = CustomerModel::find($id);
        $cus_image = ImageModel::where(['model' => 'customer', 'model_id' => $id])->get();
        $edit = 0;
        $province = ProvinceModel::pluck('province_km', 'province_id');
        $illness_types = TypeOfIllness::whereNull('deleted_at')->pluck('name_km', 'id');


        $cust_ill = CustomerIllnessModel::where('customer_id', $id)->pluck('illness_id');

        return view('administrator.customers.edit', compact('cus_image', 'customer', 'edit', 'province', 'illness_types', 'cust_ill'));
    }

    function translate($key)
    {
        return __('administrator.' . $key) . ' ' . __('administrator.field is required.');
    }

    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'customer_name' => 'required|max:255',
            'customer_phone' => 'max:100|unique:nso007_customers,customer_phone,' . $id,
            'sex' => 'required',
            'register_date' => 'required',
            'contact_by' => 'required',
        ], [
            'customer_name.required' => $this->translate('customer_name'),
            'sex.required' => $this->translate('sex'),
            'register_date.required' => $this->translate('register_date'),
        ]);
        $customer = CustomerModel::updateOrCreate([
            'id' => $id
        ]);
        $customer->agent_id = Auth::user()->id;
        $customer->user_id = Auth::user()->id;
        $customer->branch_id = FindBranchID();
        $customer->customer_name = $request->customer_name;
        $customer->customer_phone = $request->customer_phone;
        $customer->customer_email = $request->customer_email;
        if ($request->register_date) {
            $customer->register_date = date('Y-m-d h:i:s', strtotime($request->register_date));
        }
        $customer->sex = $request->sex;
        if ($request->date_of_birth) {
            $customer->date_of_birth = date('Y-m-d', strtotime($request->date_of_birth));
        }
        $customer->age = $request->age;
        $customer->known_this_from = $request->known_this_from;
        $customer->known_product_by = $request->known_product_by;
        $customer->contact_by = $request->contact_by;
        $customer->district_or_city = $request->district_or_city;
        $customer->province = $request->province;
        $customer->customer_address = $request->address;
        $customer->customer_note = $request->customer_note;
        $customer->status = 1;
        $customer->member_type_id = $request->member_type;
        $customer->illness_status = $request->illness_status;

        if ($request->type_of_illness) {
            $customer->type_illness = json_encode($request->type_of_illness);
            CustomerIllnessModel::where('customer_id', $customer->id)->delete();
            foreach ($request->type_of_illness as $row) {
                $ill = new CustomerIllnessModel();
                $ill->customer_id = $customer->id;
                $ill->illness_id = $row;
                $ill->save();
            }
        }
        if ($customer->save()) {
            if ($request->image) {
                $if_change = $request->if_change;
                ImageModel::whereNotIn('id', $request->image_id)->where('model_id', $customer->id)->delete();
                foreach ($request->image_id as $key => $img_id) {
                    $files = $request->image[$key];
                    if ($if_change[$key] == 1) {
                        $original_name = date('ymdhis') . $key . '.png';
                        $destinationPath = 'images/customer';
                        $files->move($destinationPath, $original_name);
                        $image = $destinationPath . '/' . $original_name;
                        $cus_img = ImageModel::updateOrCreate([
                            'id' => $img_id
                        ]);
                        $cus_img->model_id = $customer->id;
                        if (file_exists($cus_img->image)) {
                            unlink($cus_img->image);
                        }
                        $cus_img->image = $image;
                        $cus_img->model = 'customer';
                        $cus_img->save();
                    }
                }
            }
            session()->put('success', 'Record was update successful');
            if($request['input_name']){
                return response()->json(['value'=>$customer->id,'text'=>$customer->customer_name,'input_name'=>$request['input_name']]);
            }
            return response()->json(['status' => 'ok']);
        }
        return response()->json(['status' => 'fail']);
    }

    public function destroy($id, Request $request)

    {
        $this->validate($request,[
            'delete_reason'=>'required|max:200'
        ]);
        CustomerModel::find($id)->update(['deleted_by' => Auth::user()->id, 'deleted_at' => date('Y-m-d h:i:s'), 'delete_reason' => $request['delete_reason']]);
        CustomeCaseModel::where('customer_id', $id)->delete();
        CustomerIllnessModel::where('customer_id', $id)->delete();
        return response()->json(['status' => 'ok']);
    }

    public function upcoming_customer_care(Request $request)
    {
        if ($request->ajax()) {
            $agent_id = $request->agent_id;
            $customer = $request->customer;
            $customer_status = $request->customer_status;
            $from_date = $request->from_date ? date('Y-m-d', strtotime($request->from_date)) : null;
            $to_date = $request->to_date ? date('Y-m-d', strtotime($request->to_date)) : null;
            $bach_number = $request->bach_number;
            $reason_id = $request->reason_id;

            $data = DB::table('nso007_customer_case as m')
                ->select('m.*',
                    'nso007_customers.sex',
                    'nso007_customers.customer_name',
                    'nso007_customers.customer_phone',
                    'nso007_customers.age',
                    'nso007_customers.reason_id',
                    'nso007_customers.bach_number',
                    'nso007_customers.customer_status_id')
                ->join(DB::raw('(Select max(id) as id from nso007_customer_case group by customer_id,user_created) c1'), function ($join) {
                    // join to get latest record groupby
                    $join->on('m.id', '=', 'c1.id');
                })
                ->join('nso007_customers', 'nso007_customers.id', 'm.customer_id')
                ->where(function ($q) {
                    $q->where('m.user_created', Auth::id());
                })
                ->where(function ($q) use ($from_date, $to_date) {
                    if ($from_date || $to_date) {
                        if ($from_date) {
                            $q->where('m.date', '>=', $from_date);
                        }
                        if ($to_date) {
                            $q->where('m.date', '<=', $to_date);
                        }

                    } else {
                        $q->where('m.date', Carbon::today());
                    }
                })
                ->where(function ($q) use ($agent_id) {
                    if ($agent_id) {
                        $q->where('m.user_created', $agent_id);
                    }
                })
                ->where(function ($q) use ($bach_number) {
                    if ($bach_number) {
                        $q->where('nso007_customers.bach_number', 'like', '%' . $bach_number . '%');
                    }
                })
                ->where(function ($q) use ($customer_status) {
                    if ($customer_status) {
                        $q->where('nso007_customers.customer_status_id', $customer_status);
                    }
                })
                ->where(function ($q) use ($customer) {
                    if ($customer) {
                        $q->where('m.customer_id', $customer);
                    }
                })
                ->where(function ($q) use ($reason_id) {
                    if ($reason_id) {
                        $q->where('nso007_customers.reason_id', $reason_id);
                    }
                })
                ->orderBy('m.created_at', 'DESC');

            return DataTables::of($data->take(20))
                ->with([
                    "recordsTotal" => $data->count(),
                    "recordsFiltered" => $data->count(),
                ])
                ->editColumn('reason_id', function ($customer) {
                    return ReasonModel::find($customer->reason_id)->reason??'';
                })
                ->editColumn('type_of_illness', function ($customer) {
                    $customer->customer = findCustomer($customer->customer_id);
                    $cus = $customer->customer;
                    if ($cus) {
                        $ill = TypeOfIllness::find($cus->type_illness_id);
                        return $ill ? $ill->name_en : '';
                    }

                })
                ->editColumn('next_meeting', function ($customer) {
                    return date('d-m-Y', strtotime(($customer->date)));
                })
                ->addColumn('user_created', function ($customer) {
                    $user = findUser($customer->user_created);
                    if ($user) {
                        return $user->name ?? $user->name_kh;
                    }
                })
                ->addColumn('illness', function ($customer) {
                    if ($customer->type_illness) {
                        $ill = TypeOfIllness::whereIn('id', json_decode($customer->type_illness))->pluck(if_kh() ? 'name_km' : 'name_en');
                        $ill = $ill->implode(', ');
                        return $ill;
                    }
                })
                ->addColumn('age', function ($customer) {
                    return $customer->age;
                })
                ->editColumn('customer_status_id', function ($customer) {
                    $status = CustomerStatusModel::find($customer->customer_status_id);
                    return $status->name ?? '';
                })
                ->editColumn('sex', function ($customer) {
                    return $customer->sex ? __('administrator.' . $customer->sex) : '';
                })
                ->editColumn('note_next_meeting', function ($customer) {
                    return '<textarea rows="3" class="no-border" readonly style="width: 100%">'.$customer->note_next_meeting.'</textarea>';
                })
                ->addColumn('action', function ($data) {
                    $action = '<a href="' . route('customer_care.view', $data->customer_id) . '" class="btn btn-sm btn-primary" title="Customer Care" ><i class="fa fa-medkit" aria-hidden="true"></i></a>';
                    if (Auth::user()->can('CRM Leader') || $data->user_created === Auth::user()->id) {
                        $action .= '&nbsp;<a data-href="' . route('customer-change-agent', $data->customer_id) . '" class="btn btn-sm btn-warning edit_customer" title="Change Agent" data-width="600px"></i><i class="fa fa-exchange"> <i class="fa fa-user"></i></a>';
                    }
                    return $action;
                })
                ->addIndexColumn()
                ->rawColumns(['customer_phone', 'customer_name', 'illness', 'age', 'sex', 'action','note_next_meeting'])
                ->make(true);
        }
        $status = CustomerStatusModel::pluck('name', 'id');
        return view('administrator.customers.upcoming-customer-care', compact('status'));
    }

    public function upcoming_customer_product(Request $request)
    {
        if ($request->ajax()) {
            $agent_id = $request->agent_id;
            $bach_number = $request->bach_number;
            $customer = $request->customer;
            $reason_id = $request->reason_id;
            $customer_status = $request->customer_status;
            $from_date = $request->from_date ? date('Y-m-d', strtotime($request->from_date)) : null;
            $to_date = $request->to_date ? date('Y-m-d', strtotime($request->to_date)) : null;
            $data = DB::table('nso007_customer_case as m')
                ->select('nso007_customers.bach_number','nso007_customers.reason_id', 'm.*', 'nso007_customers.sex', 'nso007_customers.customer_name', 'nso007_customers.customer_phone', 'nso007_customers.age', 'nso007_customers.customer_status_id')
                ->join(DB::raw('(Select max(id) as id from nso007_customer_case group by customer_id,user_created) c1'), function ($join) {
                    // join to get latest record groupby
                    $join->on('m.id', '=', 'c1.id');
                })
                ->join('nso007_customers', 'nso007_customers.id', 'm.customer_id')
                ->where(function ($q) {
                    $q->where('m.user_created', Auth::id());
                })
                ->where(function ($q) use ($from_date, $to_date) {
                    if ($from_date || $to_date) {
                        if ($from_date) {
                            $q->where('m.next_meeting', '>=', $from_date);
                        }
                        if ($to_date) {
                            $q->where('m.next_meeting', '<=', $to_date);
                        }
                    } else {
                        $q->where('m.next_meeting', Carbon::today());
                    }
                })
                ->where(function ($q) use ($agent_id) {
                    if ($agent_id) {
                        $q->where('m.user_created', $agent_id);
                    }
                })
                ->where(function ($q) use ($bach_number) {
                    if ($bach_number) {
                        $q->where('nso007_customers.bach_number', 'like', '%' . $bach_number . '%');
                    }
                })
                ->where(function ($q) use ($customer_status) {
                    if ($customer_status) {
                        $q->where('nso007_customers.customer_status_id', $customer_status);
                    }
                })
                ->where(function ($q) use ($customer) {
                    if ($customer) {
                        $q->where('m.customer_id', $customer);
                    }
                })
                ->where(function ($q) use ($reason_id) {
                    if ($reason_id) {
                        $q->where('nso007_customers.reason_id', $reason_id);
                    }
                })
                ->orderBy('m.created_at', 'DESC');

            $count_filter = $data->count();
            return DataTables::of($data->take(20))
                ->with([
                    "recordsTotal" => $count_filter,
                    "recordsFiltered" => $count_filter,
                ])
                ->editColumn('reason_id', function ($customer) {
                    return ReasonModel::find($customer->reason_id)->reason??'';
                })
                ->editColumn('date', function ($customer) {
                    return date('d-m-Y', strtotime(($customer->next_meeting)));
                })
                ->addColumn('user_created', function ($customer) {
                    $user = findUser($customer->user_created);
                    if ($user) {
                        return $user->name ?: $user->name_kh;
                    }
                })
                ->addColumn('customer_phone', function ($customer) {
                    return $customer->customer_phone ?? '';
                })
                ->addColumn('customer_name', function ($customer) {
                    return $customer->customer_name ?? '';
                })
                ->addColumn('illness', function ($customer) {
                    if ($customer->type_illness) {
                        return getCustomerIllnessJson($customer->type_illness);
                    }
                })
                ->addColumn('age', function ($customer) {
                    return $customer->age ?? '';
                })
                ->addColumn('sex', function ($customer) {
                    return $customer->sex ? __('administrator.' . $customer->sex) : '';
                })
                ->editColumn('note_next_meeting', function ($customer) {
                    return '<textarea rows="3" class="no-border" style="width: 100%" readonly>'.$customer->note_next_meeting.'</textarea>';
                })
                ->addColumn('action', function ($data) {
                    return '<a href="' . route('customer_care.view', $data->customer_id) . '" class="btn btn-sm btn-primary" title="Customer Care" ><i class="fa fa-medkit" aria-hidden="true"></i></a>';
                })
                ->editColumn('customer_status_id', function ($customer) {
                    $status = CustomerStatusModel::find($customer->customer_status_id);
                    return $status->name ?? '';
                })
                ->addIndexColumn()
                ->rawColumns(['customer_phone', 'customer_name', 'illness', 'age', 'sex', 'action','note_next_meeting'])
                ->make(true);
        }
        $status = CustomerStatusModel::pluck('name', 'id');
        return view('administrator.customers.upcoming-customer-product', compact('status'));
    }

    public function search_customer(Request $request)

    {
        $key = $request->term['term'];
        $customer = CustomerModel::where(function ($q) use ($key) {
            if ($key) {
                $q->where('customer_name', 'like', $key . '%');
                $q->orwhere('customer_phone', 'like', $key . '%');
            }
        })
            ->where(function ($q){
                if(ifMember()){
                    $q->where('agent_id', Auth::id());
                }else{
                    $q->where('branch_id', FindBranchID());
                }
            })
            ->where('member_type_id', 2)
            ->where('deleted_by', null)
            ->limit(30)->pluck('customer_name', 'id')->prepend('Please Select', '');
        $arr = [];

        foreach ($customer as $key => $row) {
            $arr[] = ['id' => $key, 'text' => $row];
        }
        return \Response::json($arr);

    }

    public function change_type_customer($id, Request $request)
    {
        $cus = findCustomer($id);
        if ($request->method() === "POST") {
            $cus->type_of_customer = $request->type_of_customer;
            $cus->update();
            return response()->json(['status' => 'ok', 'reload' => 1]);
        }
        return view('administrator.customers.change_type_of_customer', compact('cus'));
    }

    public function changeStatus(Request $request, $id)
    {
        $customer_status = CustomerStatusModel::pluck('name', 'id');
        $customer = CustomerModel::find($id);
        $reason = ReasonModel::latest()->pluck('reason','id');

        if ($request->method() === "POST") {
            $this->validate($request, [
                'customer_status' => 'required',
                'reason_id' => 'required'
            ]);
            $customer->customer_status_id = $request['customer_status'];
            $customer->reason_id = $request['reason_id'];
            $customer->user_insert_last_customer_case = Auth::user()->id;
            $customer->update();
            return response()->json(['status' => 'ok', 'reload' => 1]);
        }
        return view('administrator.customers.change_status', compact('customer_status', 'customer','reason'));

    }
}

