<?php

namespace App\Http\Controllers\Administrator;

use App\Http\Controllers\Controller;
use App\Model\CustomeCaseModel;
use App\Model\CustomerBranchModel;
use App\Model\CustomerModel;
use App\Model\setup\ReasonModel;
use App\Models\TypeOfIllness;
use DataTables;
use Illuminate\Http\Request;
use Validator;
use Auth;

class CustomerCaseController extends Controller
{
    public function index(Request $request, $id)
    {
        $customer = CustomerModel::find($id);
        $customer_case = CustomeCaseModel::where('customer_id', $id)->latest()->get();
        return view('administrator.customer-case.index', compact('customer', 'customer_case'));
    }

    public function create(Request $request)
    {
        $check = CustomeCaseModel::where(['customer_id'=>$request->customer_id,'is_first'=>1])->first();
        $illness_types = TypeOfIllness::whereNull('deleted_at')->pluck('name_km', 'id');
        return view('administrator.customer-case.create',compact('illness_types','check'));
    }

    public function edit($id)
    {
        $customer_case = CustomeCaseModel::find($id);
        $illness_types = TypeOfIllness::whereNull('deleted_at')->pluck('name_km', 'id');
        return view('administrator.customer-case.edit', compact('customer_case','illness_types'));
    }

    public function store(Request $request)
    {
        $check = CustomeCaseModel::where(['customer_id'=>$request->customer_id,'is_first'=>1])->first();

        $this->validate($request, [
            'disease_status' => 'required',
            'treatment_history' => 'required',
            'product' => $check?'nullable':'required',
            'date' => 'required',
            'type_of_illness' =>  $check?'nullable':'required',
        ]);

        $data = new CustomeCaseModel;
        if($request->type_of_illness){
            $data->type_illness = json_encode($request->type_of_illness);
        }
        $data->customer_id = $request->customer_id;
        $data->disease_status = $request->disease_status;
        $data->reviewed_by = $request->reviewed_by;
        $data->user_created = $request->user_created;
        $data->treatment_history = $request->treatment_history;
        $data->if_change_product_or_usage = $request->if_change_product_or_usage;
        $data->is_first = $check?0:1;
        $product = '';
        if ($request->product != null) {
            foreach ($request->product as $key => $item) {
                $product .= '*' . $item . '&@' . $request->product_description[$key];
            }
        }
        $data->product = $product;
        if ($request->follow_up_three_day) {
            $data->follow_up_three_day = '1&@' . $request->follow_up_three_day_dis;
        }
        if ($request->follow_up_continuous) {
            $data->follow_up_continuous = '1&@' . $request->follow_up_continuous_dis;
        }

        if ($request->next_meeting != null) {
            $data->next_meeting = date('Y-m-d', strtotime($request->next_meeting));
        }
        $data->date = date('Y-m-d', strtotime($request->date));
        $data->note_next_meeting = $request->note_next_meeting;

        $customer = CustomerModel::find($request->customer_id);
        $customer->user_insert_last_customer_case = Auth::user()->id;
        $customer->update();
        $data->save();
        return response()->json(['status' => 'ok','reload'=>1]);
    }

    public function update(Request $request, $id)
    {
        $data = CustomeCaseModel::find($request->id);

        $check = $data->is_first;
        $this->validate($request, [
            'disease_status' => 'required',
            'treatment_history' => 'required',
            'product' => $check?'required':'',
            'date' => 'required',
            'type_of_illness' =>$check?'required':'',
        ]);
        if($request->type_of_illness){
            $data->type_illness = json_encode($request->type_of_illness);
        }
        $data->branch_id = FindBranchID();
        $data->customer_id = $request->customer_id;
        $data->disease_status = $request->disease_status;
        $data->reviewed_by = $request->reviewed_by;
        $data->user_created = $request->user_created;
        $data->treatment_history = $request->treatment_history;
        $data->if_change_product_or_usage = $request->if_change_product_or_usage;
        $product = '';
        if ($request->product != null) {
            foreach ($request->product as $key => $item) {
                $product .= '*' . $item . '&@' . $request->product_description[$key];
            }
        }
        $data->product = $product;
        if ($request->follow_up_three_day) {
            $data->follow_up_three_day = '1&@' . $request->follow_up_three_day_dis;
        }
        if ($request->follow_up_continuous) {
            $data->follow_up_continuous = '1&@' . $request->follow_up_continuous_dis;
        }

        if ($request->next_meeting != null) {
            $data->next_meeting = date('Y-m-d', strtotime($request->next_meeting));
        }
        $data->date = date('Y-m-d', strtotime($request->date));
        $data->note_next_meeting = $request->note_next_meeting;
        $data->update();
        $customer = CustomerModel::find($request->customer_id);
        $customer->user_insert_last_customer_case = Auth::user()->id;
        $customer->update();
        return response()->json(['status' => 'ok','reload'=>1]);
    }

    public function destroy($id)
    {
        CustomeCaseModel::find($id)->delete();
        return response()->json(['status'=>'ok','reload'=>1]);
    }
}
